/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.swing.JPointer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSliderPlus
extends JPanel {
    private double startValue;
    private double endValue;
    private double minorTic = 10.0;
    private double majorTic = 20.0;
    private boolean setPaintMinorTicks = true;
    private boolean setPaintMajorTicks = true;
    private boolean setPaintLabels = true;
    private ArrayList sliders = new ArrayList();
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            JSliderPlus.this.repaint();
        }
    };
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private Line2D[] minorTics = null;
    private Line2D[] majorTics = null;
    private Point2D[] ticLabelPos = null;
    private String[] ticLabelText = null;
    private static NumberFormat formatter = NumberFormat.getNumberInstance();
    private JPointer dragged = null;
    private double dragDelta;

    public JSliderPlus(int n, double d, double d2) {
        this.startValue = d;
        this.endValue = d2;
        this.setSize(this.getPreferredSize());
        this.updateMinorTics();
        this.updateMajorTics();
        this.addMouseListener(new TheMouseListener());
        this.addMouseMotionListener(new TheMouseMotionListener());
    }

    public void setLimits(double d, double d2) {
        this.startValue = d;
        this.endValue = d2;
        this.setSize(this.getPreferredSize());
        this.updateMinorTics();
        this.updateMajorTics();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 200);
    }

    public void setMinorTickSpacing(double d) {
        this.minorTic = d;
        this.updateMinorTics();
        this.repaint();
    }

    public void setMajorTickSpacing(double d) {
        this.majorTic = d;
        this.updateMajorTics();
        this.repaint();
    }

    public void setPaintMinorTicks(boolean bl) {
        this.setPaintMinorTicks = bl;
        this.repaint();
    }

    public void setPaintMajorTicks(boolean bl) {
        this.setPaintMajorTicks = bl;
        this.repaint();
    }

    public void setPaintLabels(boolean bl) {
        this.setPaintLabels = bl;
        this.repaint();
    }

    private void updateMinorTics() {
        double d = this.getSize().getWidth();
        double d2 = this.getSize().getHeight();
        int n = (int)Math.abs((this.endValue - this.startValue) / this.minorTic);
        this.minorTics = new Line2D[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.minorTics[i] = new Line2D.Double(d * 0.3, d2 * (0.9 - (double)i * 0.8 / (double)n), d * 0.4, d2 * (0.9 - (double)i * 0.8 / (double)n));
        }
    }

    private void updateMajorTics() {
        double d = this.getSize().getWidth();
        double d2 = this.getSize().getHeight();
        int n = (int)Math.abs((this.endValue - this.startValue) / this.majorTic);
        this.majorTics = new Line2D[n + 1];
        this.ticLabelPos = new Point2D[n + 1];
        this.ticLabelText = new String[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.majorTics[i] = new Line2D.Double(d * 0.25, d2 * (0.9 - (double)i * 0.8 / (double)n), d * 0.4, d2 * (0.9 - (double)i * 0.8 / (double)n));
            this.ticLabelText[i] = formatter.format(this.startValue + (double)i * (this.endValue - this.startValue) / (double)n);
            this.ticLabelPos[i] = new Point2D.Double(0.0, d2 * (0.9 - (double)i * 0.8 / (double)n) + 6.0);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.draw(new Rectangle2D.Double(this.getSize().getWidth() * 0.45, this.getSize().getHeight() * 0.05, this.getSize().getWidth() * 0.1, this.getSize().getHeight() * 0.9));
        if (this.setPaintMinorTicks) {
            for (n = 0; n < this.minorTics.length; ++n) {
                graphics2D.draw(this.minorTics[n]);
            }
        }
        if (this.setPaintMajorTicks) {
            for (n = 0; n < this.majorTics.length; ++n) {
                graphics2D.draw(this.majorTics[n]);
            }
        }
        if (this.setPaintLabels) {
            for (n = 0; n < this.majorTics.length; ++n) {
                graphics2D.drawString(this.ticLabelText[n], (int)this.ticLabelPos[n].getX(), (int)this.ticLabelPos[n].getY());
            }
        }
        Color color = graphics2D.getColor();
        for (int i = 0; i < this.sliders.size(); ++i) {
            ((JPointer)this.sliders.get(i)).paintOnSlider(graphics2D, this.startValue, this.endValue, this.getSize().getWidth(), this.getSize().getHeight());
        }
        graphics2D.setColor(color);
    }

    public void addJPointer(JPointer jPointer) {
        for (int i = 0; i < this.sliders.size(); ++i) {
            if (!this.sliders.get(i).equals(jPointer)) continue;
            return;
        }
        this.sliders.add(jPointer);
        jPointer.addChangeListener(this.changeListener);
        this.repaint();
    }

    public void removeJPointer(JPointer jPointer) {
        int n = 0;
        while (n < this.sliders.size()) {
            if (this.sliders.get(n).equals(jPointer)) {
                this.sliders.remove(n);
                continue;
            }
            ++n;
        }
        jPointer.removeChangeListener(this.changeListener);
        this.repaint();
    }

    private double mousePosition(MouseEvent mouseEvent) {
        return this.startValue + (0.9 - (double)mouseEvent.getY() / this.getSize().getHeight()) / 0.8 * (this.endValue - this.startValue);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JSliderPlus jSliderPlus = new JSliderPlus(0, 0.0, 100.0);
        jFrame.getContentPane().add(jSliderPlus);
        jFrame.pack();
        jFrame.show();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JPointer jPointer = new JPointer(4);
        jPointer.setColor(Color.MAGENTA);
        jPointer.setValue(25.0);
        jSliderPlus.addJPointer(jPointer);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JPointer jPointer2 = new JPointer(3);
        jPointer2.setColor(Color.CYAN);
        jPointer2.setValue(75.0);
        jSliderPlus.addJPointer(jPointer2);
        jPointer2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((JPointer)changeEvent.getSource()).getValue();
                System.out.println("State changed: " + d);
            }
        });
        jSliderPlus.setLimits(-10.0, 140.0);
        jSliderPlus.setMinorTickSpacing(10.0);
        jSliderPlus.setMajorTickSpacing(30.0);
    }

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMaximumIntegerDigits(3);
    }

    private class TheMouseMotionListener
    extends MouseMotionAdapter {
        private TheMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = false;
            for (int i = 0; i < JSliderPlus.this.sliders.size(); ++i) {
                if (!((JPointer)JSliderPlus.this.sliders.get(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                break;
            }
            if (bl) {
                JSliderPlus.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                JSliderPlus.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JSliderPlus.this.dragged != null) {
                double d = JSliderPlus.this.mousePosition(mouseEvent) + JSliderPlus.this.dragDelta;
                if (d > Math.max(JSliderPlus.this.startValue, JSliderPlus.this.endValue)) {
                    d = Math.max(JSliderPlus.this.startValue, JSliderPlus.this.endValue);
                }
                if (d < Math.min(JSliderPlus.this.startValue, JSliderPlus.this.endValue)) {
                    d = Math.min(JSliderPlus.this.startValue, JSliderPlus.this.endValue);
                }
                JSliderPlus.this.dragged.setValue(d);
                JSliderPlus.this.repaint();
            }
        }
    }

    private class TheMouseListener
    extends MouseAdapter {
        private TheMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            for (int i = JSliderPlus.this.sliders.size() - 1; i >= 0; --i) {
                if (!((JPointer)JSliderPlus.this.sliders.get(i)).contains(mouseEvent.getPoint())) continue;
                JSliderPlus.this.dragged = (JPointer)JSliderPlus.this.sliders.get(i);
                JSliderPlus.this.dragDelta = JSliderPlus.this.dragged.getValue() - JSliderPlus.this.mousePosition(mouseEvent);
                JSliderPlus.this.dragged.setAdjusting(true);
                break;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JSliderPlus.this.dragged != null) {
                JSliderPlus.this.dragged.setAdjusting(false);
            }
            JSliderPlus.this.dragged = null;
            boolean bl = false;
            for (int i = 0; i < JSliderPlus.this.sliders.size(); ++i) {
                if (!((JPointer)JSliderPlus.this.sliders.get(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                break;
            }
            if (bl) {
                JSliderPlus.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                JSliderPlus.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

