// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Probability.java

package cern.jet.stat;

import cern.jet.math.Constants;
import cern.jet.math.Polynomial;

// Referenced classes of package cern.jet.stat:
//            Gamma

public class Probability extends Constants
{

    protected Probability()
    {
    }

    public static double beta(double a, double b, double x)
    {
        return Gamma.incompleteBeta(a, b, x);
    }

    public static double betaComplemented(double a, double b, double x)
    {
        return Gamma.incompleteBeta(b, a, x);
    }

    public static double binomial(int k, int n, double p)
    {
        if(p < 0.0D || p > 1.0D)
            throw new IllegalArgumentException();
        if(k < 0 || n < k)
            throw new IllegalArgumentException();
        if(k == n)
            return 1.0D;
        if(k == 0)
            return Math.pow(1.0D - p, n - k);
        else
            return Gamma.incompleteBeta(n - k, k + 1, 1.0D - p);
    }

    public static double binomialComplemented(int k, int n, double p)
    {
        if(p < 0.0D || p > 1.0D)
            throw new IllegalArgumentException();
        if(k < 0 || n < k)
            throw new IllegalArgumentException();
        if(k == n)
            return 0.0D;
        if(k == 0)
            return 1.0D - Math.pow(1.0D - p, n - k);
        else
            return Gamma.incompleteBeta(k + 1, n - k, p);
    }

    public static double chiSquare(double v, double x)
        throws ArithmeticException
    {
        if(x < 0.0D || v < 1.0D)
            return 0.0D;
        else
            return Gamma.incompleteGamma(v / 2D, x / 2D);
    }

    public static double chiSquareComplemented(double v, double x)
        throws ArithmeticException
    {
        if(x < 0.0D || v < 1.0D)
            return 0.0D;
        else
            return Gamma.incompleteGammaComplement(v / 2D, x / 2D);
    }

    public static double errorFunction(double x)
        throws ArithmeticException
    {
        double T[] = {
            9.6049737398705162D, 90.026019720384269D, 2232.0053459468431D, 7003.3251411280507D, 55592.301301039493D
        };
        double U[] = {
            33.561714164750313D, 521.35794978015269D, 4594.3238297098014D, 22629.000061389095D, 49267.394260863592D
        };
        if(Math.abs(x) > 1.0D)
        {
            return 1.0D - errorFunctionComplemented(x);
        } else
        {
            double z = x * x;
            double y = (x * Polynomial.polevl(z, T, 4)) / Polynomial.p1evl(z, U, 5);
            return y;
        }
    }

    public static double errorFunctionComplemented(double a)
        throws ArithmeticException
    {
        double P[] = {
            2.4619698147353052E-10D, 0.56418956483106886D, 7.4632105644226989D, 48.637197098568137D, 196.5208329560771D, 526.44519499547732D, 934.52852717195765D, 1027.5518868951572D, 557.53533536939938D
        };
        double Q[] = {
            13.228195115474499D, 86.707214088598974D, 354.93777888781989D, 975.70850174320549D, 1823.9091668790973D, 2246.3376081871097D, 1656.6630919416134D, 557.53534081772773D
        };
        double R[] = {
            0.56418958354775506D, 1.275366707599781D, 5.0190504225118051D, 6.160210979930536D, 7.4097426995044895D, 2.9788666537210022D
        };
        double S[] = {
            2.2605286322011726D, 9.3960352493800148D, 12.048953980809666D, 17.081445074756591D, 9.6089680906328585D, 3.3690764510008151D
        };
        double x;
        if(a < 0.0D)
            x = -a;
        else
            x = a;
        if(x < 1.0D)
            return 1.0D - errorFunction(a);
        double z = -a * a;
        if(z < -709.78271289338397D)
            return a >= 0.0D ? 0.0D : 2D;
        z = Math.exp(z);
        double p;
        double q;
        if(x < 8D)
        {
            p = Polynomial.polevl(x, P, 8);
            q = Polynomial.p1evl(x, Q, 8);
        } else
        {
            p = Polynomial.polevl(x, R, 5);
            q = Polynomial.p1evl(x, S, 6);
        }
        double y = (z * p) / q;
        if(a < 0.0D)
            y = 2D - y;
        if(y == 0.0D)
            return a >= 0.0D ? 0.0D : 2D;
        else
            return y;
    }

    public static double gamma(double a, double b, double x)
    {
        if(x < 0.0D)
            return 0.0D;
        else
            return Gamma.incompleteGamma(b, a * x);
    }

    public static double gammaComplemented(double a, double b, double x)
    {
        if(x < 0.0D)
            return 0.0D;
        else
            return Gamma.incompleteGammaComplement(b, a * x);
    }

    public static double negativeBinomial(int k, int n, double p)
    {
        if(p < 0.0D || p > 1.0D)
            throw new IllegalArgumentException();
        if(k < 0)
            return 0.0D;
        else
            return Gamma.incompleteBeta(n, k + 1, p);
    }

    public static double negativeBinomialComplemented(int k, int n, double p)
    {
        if(p < 0.0D || p > 1.0D)
            throw new IllegalArgumentException();
        if(k < 0)
            return 0.0D;
        else
            return Gamma.incompleteBeta(k + 1, n, 1.0D - p);
    }

    public static double normal(double a)
        throws ArithmeticException
    {
        double x = a * 0.70710678118654757D;
        double z = Math.abs(x);
        double y;
        if(z < 0.70710678118654757D)
        {
            y = 0.5D + 0.5D * errorFunction(x);
        } else
        {
            y = 0.5D * errorFunctionComplemented(z);
            if(x > 0.0D)
                y = 1.0D - y;
        }
        return y;
    }

    public static double normal(double mean, double variance, double x)
        throws ArithmeticException
    {
        if(x > 0.0D)
            return 0.5D + 0.5D * errorFunction((x - mean) / Math.sqrt(2D * variance));
        else
            return 0.5D - 0.5D * errorFunction(-(x - mean) / Math.sqrt(2D * variance));
    }

    public static double normalInverse(double y0)
        throws ArithmeticException
    {
        double s2pi = Math.sqrt(6.2831853071795862D);
        if(y0 <= 0.0D)
            throw new IllegalArgumentException();
        if(y0 >= 1.0D)
            throw new IllegalArgumentException();
        int code = 1;
        double y = y0;
        if(y > 0.8646647167633873D)
        {
            y = 1.0D - y;
            code = 0;
        }
        double x;
        if(y > 0.1353352832366127D)
        {
            y -= 0.5D;
            double y2 = y * y;
            x = y + y * ((y2 * Polynomial.polevl(y2, P0, 4)) / Polynomial.p1evl(y2, Q0, 8));
            x *= s2pi;
            return x;
        }
        x = Math.sqrt(-2D * Math.log(y));
        double x0 = x - Math.log(x) / x;
        double z = 1.0D / x;
        double x1;
        if(x < 8D)
            x1 = (z * Polynomial.polevl(z, P1, 8)) / Polynomial.p1evl(z, Q1, 8);
        else
            x1 = (z * Polynomial.polevl(z, P2, 8)) / Polynomial.p1evl(z, Q2, 8);
        x = x0 - x1;
        if(code != 0)
            x = -x;
        return x;
    }

    public static double poisson(int k, double mean)
        throws ArithmeticException
    {
        if(mean < 0.0D)
            throw new IllegalArgumentException();
        if(k < 0)
            return 0.0D;
        else
            return Gamma.incompleteGammaComplement(k + 1, mean);
    }

    public static double poissonComplemented(int k, double mean)
        throws ArithmeticException
    {
        if(mean < 0.0D)
            throw new IllegalArgumentException();
        if(k < -1)
            return 0.0D;
        else
            return Gamma.incompleteGamma(k + 1, mean);
    }

    public static double studentT(double k, double t)
        throws ArithmeticException
    {
        if(k <= 0.0D)
            throw new IllegalArgumentException();
        if(t == 0.0D)
            return 0.5D;
        double cdf = 0.5D * Gamma.incompleteBeta(0.5D * k, 0.5D, k / (k + t * t));
        if(t >= 0.0D)
            cdf = 1.0D - cdf;
        return cdf;
    }

    public static double studentTInverse(double alpha, int size)
    {
        double cumProb = 1.0D - alpha / 2D;
        cumProb = 1.0D - alpha / 2D;
        double x1 = normalInverse(cumProb);
        if(size > 200)
            return x1;
        double f1 = studentT(size, x1) - cumProb;
        double x2 = x1;
        double f2 = f1;
        do
        {
            if(f1 > 0.0D)
                x2 /= 2D;
            else
                x2 += x1;
            f2 = studentT(size, x2) - cumProb;
        } while(f1 * f2 > 0.0D);
        do
        {
            double s12 = (f2 - f1) / (x2 - x1);
            double x3 = x2 - f2 / s12;
            double f3 = studentT(size, x3) - cumProb;
            if(Math.abs(f3) < 1E-08D)
                return x3;
            if(f3 * f2 < 0.0D)
            {
                x1 = x2;
                f1 = f2;
                x2 = x3;
                f2 = f3;
            } else
            {
                double g = f2 / (f2 + f3);
                f1 = g * f1;
                x2 = x3;
                f2 = f3;
            }
        } while(Math.abs(x2 - x1) > 0.001D);
        if(Math.abs(f2) <= Math.abs(f1))
            return x2;
        else
            return x1;
    }

    protected static final double P0[] = {
        -59.963350101410789D, 98.001075418599967D, -56.676285746907027D, 13.931260938727968D, -1.2391658386738125D
    };
    protected static final double Q0[] = {
        1.9544885833814176D, 4.6762791289888153D, 86.360242139089053D, -225.46268785411937D, 200.26021238006066D, -82.037225616833339D, 15.90562251262117D, -1.1833162112133D
    };
    protected static final double P1[] = {
        4.0554489230596245D, 31.525109459989388D, 57.162819224642128D, 44.080507389320083D, 14.684956192885803D, 2.1866330685079025D, -0.14025607917135449D, -0.035042462682784818D, -0.00085745678515468545D
    };
    protected static final double Q1[] = {
        15.779988325646675D, 45.390763512887922D, 41.317203825467203D, 15.04253856929075D, 2.5046494620830941D, -0.14218292285478779D, -0.038080640769157827D, -0.00093325948089545744D
    };
    protected static final double P2[] = {
        3.2377489177694603D, 6.9152288906898418D, 3.9388102529247444D, 1.3330346081580755D, 0.20148538954917908D, 0.012371663481782003D, 0.00030158155350823543D, 2.6580697468673755E-06D, 6.2397453918498331E-09D
    };
    protected static final double Q2[] = {
        6.02427039364742D, 3.6798356385616087D, 1.3770209948908132D, 0.21623699359449663D, 0.013420400608854318D, 0.00032801446468212774D, 2.8924786474538068E-06D, 6.7901940800998127E-09D
    };

}
