// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Descriptive.java

package cern.jet.stat;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.math.Arithmetic;

// Referenced classes of package cern.jet.stat:
//            Gamma

public class Descriptive
{

    protected Descriptive()
    {
    }

    public static double autoCorrelation(DoubleArrayList data, int lag, double mean, double variance)
    {
        int N = data.size();
        if(lag >= N)
            throw new IllegalArgumentException("Lag is too large");
        double elements[] = data.elements();
        double run = 0.0D;
        for(int i = lag; i < N; i++)
            run += (elements[i] - mean) * (elements[i - lag] - mean);

        return run / (double)(N - lag) / variance;
    }

    protected static void checkRangeFromTo(int from, int to, int theSize)
    {
        if(to == from - 1)
            return;
        if(from < 0 || from > to || to >= theSize)
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size=" + theSize);
        else
            return;
    }

    public static double correlation(DoubleArrayList data1, double standardDev1, DoubleArrayList data2, double standardDev2)
    {
        return covariance(data1, data2) / (standardDev1 * standardDev2);
    }

    public static double covariance(DoubleArrayList data1, DoubleArrayList data2)
    {
        int size = data1.size();
        if(size != data2.size() || size == 0)
            throw new IllegalArgumentException();
        double elements1[] = data1.elements();
        double elements2[] = data2.elements();
        double sumx = elements1[0];
        double sumy = elements2[0];
        double Sxy = 0.0D;
        for(int i = 1; i < size; i++)
        {
            double x = elements1[i];
            double y = elements2[i];
            sumx += x;
            Sxy += (x - sumx / (double)(i + 1)) * (y - sumy / (double)i);
            sumy += y;
        }

        return Sxy / (double)size;
    }

    public static double durbinWatson(DoubleArrayList data)
    {
        int size = data.size();
        if(size < 2)
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        double elements[] = data.elements();
        double run = 0.0D;
        double run_sq = 0.0D;
        run_sq = elements[0] * elements[0];
        for(int i = 1; i < size; i++)
        {
            double x = elements[i] - elements[i - 1];
            run += x * x;
            run_sq += elements[i] * elements[i];
        }

        return run / run_sq;
    }

    public static void frequencies(DoubleArrayList sortedData, DoubleArrayList distinctValues, IntArrayList frequencies)
    {
        distinctValues.clear();
        if(frequencies != null)
            frequencies.clear();
        double sortedElements[] = sortedData.elements();
        int size = sortedData.size();
        for(int i = 0; i < size;)
        {
            double element = sortedElements[i];
            int cursor = i;
            while(++i < size && sortedElements[i] == element) ;
            int runLength = i - cursor;
            distinctValues.add(element);
            if(frequencies != null)
                frequencies.add(runLength);
        }

    }

    public static double geometricMean(int size, double sumOfLogarithms)
    {
        return Math.exp(sumOfLogarithms / (double)size);
    }

    public static double geometricMean(DoubleArrayList data)
    {
        return geometricMean(data.size(), sumOfLogarithms(data, 0, data.size() - 1));
    }

    public static double harmonicMean(int size, double sumOfInversions)
    {
        return (double)size / sumOfInversions;
    }

    public static void incrementalUpdate(DoubleArrayList data, int from, int to, double inOut[])
    {
        checkRangeFromTo(from, to, data.size());
        double min = inOut[0];
        double max = inOut[1];
        double sum = inOut[2];
        double sumSquares = inOut[3];
        double elements[] = data.elements();
        for(; from <= to; from++)
        {
            double element = elements[from];
            sum += element;
            sumSquares += element * element;
            if(element < min)
                min = element;
            if(element > max)
                max = element;
        }

        inOut[0] = min;
        inOut[1] = max;
        inOut[2] = sum;
        inOut[3] = sumSquares;
    }

    public static void incrementalUpdateSumsOfPowers(DoubleArrayList data, int from, int to, int fromSumIndex, int toSumIndex, double sumOfPowers[])
    {
        int size = data.size();
        int lastIndex = toSumIndex - fromSumIndex;
        if(from > size || lastIndex + 1 > sumOfPowers.length)
            throw new IllegalArgumentException();
        double elements[];
        if(fromSumIndex == 1)
        {
            if(toSumIndex == 2)
            {
                elements = data.elements();
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                for(int i = from - 1; ++i <= to;)
                {
                    double element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                }

                sumOfPowers[0] += sum;
                sumOfPowers[1] += sumSquares;
                return;
            }
            if(toSumIndex == 3)
            {
                elements = data.elements();
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                double sum_xxx = sumOfPowers[2];
                for(int i = from - 1; ++i <= to;)
                {
                    double element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                }

                sumOfPowers[0] += sum;
                sumOfPowers[1] += sumSquares;
                sumOfPowers[2] += sum_xxx;
                return;
            }
            if(toSumIndex == 4)
            {
                elements = data.elements();
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                double sum_xxx = sumOfPowers[2];
                double sum_xxxx = sumOfPowers[3];
                for(int i = from - 1; ++i <= to;)
                {
                    double element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                    sum_xxxx += element * element * element * element;
                }

                sumOfPowers[0] += sum;
                sumOfPowers[1] += sumSquares;
                sumOfPowers[2] += sum_xxx;
                sumOfPowers[3] += sum_xxxx;
                return;
            }
        }
        if(fromSumIndex == toSumIndex || fromSumIndex >= -1 && toSumIndex <= 5)
        {
            for(int i = fromSumIndex; i <= toSumIndex; i++)
                sumOfPowers[i - fromSumIndex] += sumOfPowerDeviations(data, i, 0.0D, from, to);

            return;
        }
        i = data.elements();
        for(int i = from - 1; ++i <= to;)
        {
            double element = i[i];
            double pow = Math.pow(element, fromSumIndex);
            int j = 0;
            for(int m = lastIndex; --m >= 0;)
            {
                sumOfPowers[j++] += pow;
                pow *= element;
            }

            sumOfPowers[j] += pow;
        }

    }

    public static void incrementalWeightedUpdate(DoubleArrayList data, DoubleArrayList weights, int from, int to, double inOut[])
    {
        int dataSize = data.size();
        checkRangeFromTo(from, to, dataSize);
        if(dataSize != weights.size())
            throw new IllegalArgumentException("from=" + from + ", to=" + to + ", data.size()=" + dataSize + ", weights.size()=" + weights.size());
        double sum = inOut[0];
        double sumOfSquares = inOut[1];
        double elements[] = data.elements();
        double w[] = weights.elements();
        for(int i = from - 1; ++i <= to;)
        {
            double element = elements[i];
            double weight = w[i];
            double prod = element * weight;
            sum += prod;
            sumOfSquares += element * prod;
        }

        inOut[0] = sum;
        inOut[1] = sumOfSquares;
    }

    public static double kurtosis(double moment4, double standardDeviation)
    {
        return -3D + moment4 / (standardDeviation * standardDeviation * standardDeviation * standardDeviation);
    }

    public static double kurtosis(DoubleArrayList data, double mean, double standardDeviation)
    {
        return kurtosis(moment(data, 4, mean), standardDeviation);
    }

    public static double lag1(DoubleArrayList data, double mean)
    {
        int size = data.size();
        double elements[] = data.elements();
        double q = 0.0D;
        double v = (elements[0] - mean) * (elements[0] - mean);
        for(int i = 1; i < size; i++)
        {
            double delta0 = elements[i - 1] - mean;
            double delta1 = elements[i] - mean;
            q += (delta0 * delta1 - q) / (double)(i + 1);
            v += (delta1 * delta1 - v) / (double)(i + 1);
        }

        double r1 = q / v;
        return r1;
    }

    public static double max(DoubleArrayList data)
    {
        int size = data.size();
        if(size == 0)
            throw new IllegalArgumentException();
        double elements[] = data.elements();
        double max = elements[size - 1];
        for(int i = size - 1; --i >= 0;)
            if(elements[i] > max)
                max = elements[i];

        return max;
    }

    public static double mean(DoubleArrayList data)
    {
        return sum(data) / (double)data.size();
    }

    public static double meanDeviation(DoubleArrayList data, double mean)
    {
        double elements[] = data.elements();
        int size = data.size();
        double sum = 0.0D;
        for(int i = size; --i >= 0;)
            sum += Math.abs(elements[i] - mean);

        return sum / (double)size;
    }

    public static double median(DoubleArrayList sortedData)
    {
        return quantile(sortedData, 0.5D);
    }

    public static double min(DoubleArrayList data)
    {
        int size = data.size();
        if(size == 0)
            throw new IllegalArgumentException();
        double elements[] = data.elements();
        double min = elements[size - 1];
        for(int i = size - 1; --i >= 0;)
            if(elements[i] < min)
                min = elements[i];

        return min;
    }

    public static double moment(int k, double c, int size, double sumOfPowers[])
    {
        double sum = 0.0D;
        int sign = 1;
        for(int i = 0; i <= k; i++)
        {
            double y;
            if(i == 0)
                y = 1.0D;
            else
            if(i == 1)
                y = c;
            else
            if(i == 2)
                y = c * c;
            else
            if(i == 3)
                y = c * c * c;
            else
                y = Math.pow(c, i);
            sum += (double)sign * Arithmetic.binomial(k, i) * y * sumOfPowers[k - i];
            sign = -sign;
        }

        return sum / (double)size;
    }

    public static double moment(DoubleArrayList data, int k, double c)
    {
        return sumOfPowerDeviations(data, k, c) / (double)data.size();
    }

    public static double pooledMean(int size1, double mean1, int size2, double mean2)
    {
        return ((double)size1 * mean1 + (double)size2 * mean2) / (double)(size1 + size2);
    }

    public static double pooledVariance(int size1, double variance1, int size2, double variance2)
    {
        return ((double)size1 * variance1 + (double)size2 * variance2) / (double)(size1 + size2);
    }

    public static double product(int size, double sumOfLogarithms)
    {
        return Math.pow(Math.exp(sumOfLogarithms / (double)size), size);
    }

    public static double product(DoubleArrayList data)
    {
        int size = data.size();
        double elements[] = data.elements();
        double product = 1.0D;
        for(int i = size; --i >= 0;)
            product *= elements[i];

        return product;
    }

    public static double quantile(DoubleArrayList sortedData, double phi)
    {
        double sortedElements[] = sortedData.elements();
        int n = sortedData.size();
        double index = phi * (double)(n - 1);
        int lhs = (int)index;
        double delta = index - (double)lhs;
        if(n == 0)
            return 0.0D;
        double result;
        if(lhs == n - 1)
            result = sortedElements[lhs];
        else
            result = (1.0D - delta) * sortedElements[lhs] + delta * sortedElements[lhs + 1];
        return result;
    }

    public static double quantileInverse(DoubleArrayList sortedList, double element)
    {
        return rankInterpolated(sortedList, element) / (double)sortedList.size();
    }

    public static DoubleArrayList quantiles(DoubleArrayList sortedData, DoubleArrayList percentages)
    {
        int s = percentages.size();
        DoubleArrayList quantiles = new DoubleArrayList(s);
        for(int i = 0; i < s; i++)
            quantiles.add(quantile(sortedData, percentages.get(i)));

        return quantiles;
    }

    public static double rankInterpolated(DoubleArrayList sortedList, double element)
    {
        int index = sortedList.binarySearch(element);
        if(index >= 0)
        {
            int to = index + 1;
            for(int s = sortedList.size(); to < s && sortedList.get(to) == element; to++);
            return (double)to;
        }
        int insertionPoint = -index - 1;
        if(insertionPoint == 0 || insertionPoint == sortedList.size())
        {
            return (double)insertionPoint;
        } else
        {
            double from = sortedList.get(insertionPoint - 1);
            double to = sortedList.get(insertionPoint);
            double delta = (element - from) / (to - from);
            return (double)insertionPoint + delta;
        }
    }

    public static double rms(int size, double sumOfSquares)
    {
        return Math.sqrt(sumOfSquares / (double)size);
    }

    public static double sampleKurtosis(int size, double moment4, double sampleVariance)
    {
        int n = size;
        double s2 = sampleVariance;
        double m4 = moment4 * (double)n;
        return (m4 * (double)n * (double)(n + 1)) / ((double)((n - 1) * (n - 2) * (n - 3)) * s2 * s2) - (3D * (double)(n - 1) * (double)(n - 1)) / (double)((n - 2) * (n - 3));
    }

    public static double sampleKurtosis(DoubleArrayList data, double mean, double sampleVariance)
    {
        return sampleKurtosis(data.size(), moment(data, 4, mean), sampleVariance);
    }

    public static double sampleKurtosisStandardError(int size)
    {
        int n = size;
        return Math.sqrt((24D * (double)n * (double)(n - 1) * (double)(n - 1)) / (double)((n - 3) * (n - 2) * (n + 3) * (n + 5)));
    }

    public static double sampleSkew(int size, double moment3, double sampleVariance)
    {
        int n = size;
        double s = Math.sqrt(sampleVariance);
        double m3 = moment3 * (double)n;
        return ((double)n * m3) / ((double)((n - 1) * (n - 2)) * s * s * s);
    }

    public static double sampleSkew(DoubleArrayList data, double mean, double sampleVariance)
    {
        return sampleSkew(data.size(), moment(data, 3, mean), sampleVariance);
    }

    public static double sampleSkewStandardError(int size)
    {
        int n = size;
        return Math.sqrt((6D * (double)n * (double)(n - 1)) / (double)((n - 2) * (n + 1) * (n + 3)));
    }

    public static double sampleStandardDeviation(int size, double sampleVariance)
    {
        int n = size;
        double s = Math.sqrt(sampleVariance);
        double Cn;
        if(n > 30)
            Cn = 1.0D + 1.0D / (double)(4 * (n - 1));
        else
            Cn = (Math.sqrt((double)(n - 1) * 0.5D) * Gamma.gamma((double)(n - 1) * 0.5D)) / Gamma.gamma((double)n * 0.5D);
        return Cn * s;
    }

    public static double sampleVariance(int size, double sum, double sumOfSquares)
    {
        double mean = sum / (double)size;
        return (sumOfSquares - mean * sum) / (double)(size - 1);
    }

    public static double sampleVariance(DoubleArrayList data, double mean)
    {
        double elements[] = data.elements();
        int size = data.size();
        double sum = 0.0D;
        for(int i = size; --i >= 0;)
        {
            double delta = elements[i] - mean;
            sum += delta * delta;
        }

        return sum / (double)(size - 1);
    }

    public static double sampleWeightedVariance(double sumOfWeights, double sumOfProducts, double sumOfSquaredProducts)
    {
        return (sumOfSquaredProducts - (sumOfProducts * sumOfProducts) / sumOfWeights) / (sumOfWeights - 1.0D);
    }

    public static double skew(double moment3, double standardDeviation)
    {
        return moment3 / (standardDeviation * standardDeviation * standardDeviation);
    }

    public static double skew(DoubleArrayList data, double mean, double standardDeviation)
    {
        return skew(moment(data, 3, mean), standardDeviation);
    }

    public static DoubleArrayList[] split(DoubleArrayList sortedList, DoubleArrayList splitters)
    {
        int noOfBins = splitters.size() + 1;
        DoubleArrayList bins[] = new DoubleArrayList[noOfBins];
        for(int i = noOfBins; --i >= 0;)
            bins[i] = new DoubleArrayList();

        int listSize = sortedList.size();
        int nextStart = 0;
        for(int i = 0; nextStart < listSize && i < noOfBins - 1; i++)
        {
            double splitValue = splitters.get(i);
            int index = sortedList.binarySearch(splitValue);
            if(index < 0)
            {
                int insertionPosition = -index - 1;
                bins[i].addAllOfFromTo(sortedList, nextStart, insertionPosition - 1);
                nextStart = insertionPosition;
            } else
            {
                while(--index >= 0 && sortedList.get(index) == splitValue) ;
                bins[i].addAllOfFromTo(sortedList, nextStart, index);
                nextStart = index + 1;
            }
        }

        bins[noOfBins - 1].addAllOfFromTo(sortedList, nextStart, sortedList.size() - 1);
        return bins;
    }

    public static double standardDeviation(double variance)
    {
        return Math.sqrt(variance);
    }

    public static double standardError(int size, double variance)
    {
        return Math.sqrt(variance / (double)size);
    }

    public static void standardize(DoubleArrayList data, double mean, double standardDeviation)
    {
        double elements[] = data.elements();
        for(int i = data.size(); --i >= 0;)
            elements[i] = (elements[i] - mean) / standardDeviation;

    }

    public static double sum(DoubleArrayList data)
    {
        return sumOfPowerDeviations(data, 1, 0.0D);
    }

    public static double sumOfInversions(DoubleArrayList data, int from, int to)
    {
        return sumOfPowerDeviations(data, -1, 0.0D, from, to);
    }

    public static double sumOfLogarithms(DoubleArrayList data, int from, int to)
    {
        double elements[] = data.elements();
        double logsum = 0.0D;
        for(int i = from - 1; ++i <= to;)
            logsum += Math.log(elements[i]);

        return logsum;
    }

    public static double sumOfPowerDeviations(DoubleArrayList data, int k, double c)
    {
        return sumOfPowerDeviations(data, k, c, 0, data.size() - 1);
    }

    public static double sumOfPowerDeviations(DoubleArrayList data, int k, double c, int from, int to)
    {
        double elements[] = data.elements();
        double sum = 0.0D;
        switch(k)
        {
        case -2: 
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                {
                    double v = elements[i];
                    sum += 1.0D / (v * v);
                }

                break;
            }
            for(int i = from - 1; ++i <= to;)
            {
                double v = elements[i] - c;
                sum += 1.0D / (v * v);
            }

            break;

        case -1: 
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                    sum += 1.0D / elements[i];

                break;
            }
            for(int i = from - 1; ++i <= to;)
                sum += 1.0D / (elements[i] - c);

            break;

        case 0: // '\0'
            sum += (to - from) + 1;
            break;

        case 1: // '\001'
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                    sum += elements[i];

                break;
            }
            for(int i = from - 1; ++i <= to;)
                sum += elements[i] - c;

            break;

        case 2: // '\002'
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                {
                    double v = elements[i];
                    sum += v * v;
                }

                break;
            }
            for(int i = from - 1; ++i <= to;)
            {
                double v = elements[i] - c;
                sum += v * v;
            }

            break;

        case 3: // '\003'
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                {
                    double v = elements[i];
                    sum += v * v * v;
                }

                break;
            }
            for(int i = from - 1; ++i <= to;)
            {
                double v = elements[i] - c;
                sum += v * v * v;
            }

            break;

        case 4: // '\004'
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                {
                    double v = elements[i];
                    sum += v * v * v * v;
                }

                break;
            }
            for(int i = from - 1; ++i <= to;)
            {
                double v = elements[i] - c;
                sum += v * v * v * v;
            }

            break;

        case 5: // '\005'
            if(c == 0.0D)
            {
                for(int i = from - 1; ++i <= to;)
                {
                    double v = elements[i];
                    sum += v * v * v * v * v;
                }

                break;
            }
            for(int i = from - 1; ++i <= to;)
            {
                double v = elements[i] - c;
                sum += v * v * v * v * v;
            }

            break;

        default:
            for(int i = from - 1; ++i <= to;)
                sum += Math.pow(elements[i] - c, k);

            break;
        }
        return sum;
    }

    public static double sumOfPowers(DoubleArrayList data, int k)
    {
        return sumOfPowerDeviations(data, k, 0.0D);
    }

    public static double sumOfSquaredDeviations(int size, double variance)
    {
        return variance * (double)(size - 1);
    }

    public static double sumOfSquares(DoubleArrayList data)
    {
        return sumOfPowerDeviations(data, 2, 0.0D);
    }

    public static double trimmedMean(DoubleArrayList sortedData, double mean, int left, int right)
    {
        int N = sortedData.size();
        if(N == 0)
            throw new IllegalArgumentException("Empty data.");
        if(left + right >= N)
            throw new IllegalArgumentException("Not enough data.");
        double sortedElements[] = sortedData.elements();
        int N0 = N;
        for(int i = 0; i < left; i++)
            mean += (mean - sortedElements[i]) / (double)(--N);

        for(int i = 0; i < right; i++)
            mean += (mean - sortedElements[N0 - 1 - i]) / (double)(--N);

        return mean;
    }

    public static double variance(double standardDeviation)
    {
        return standardDeviation * standardDeviation;
    }

    public static double variance(int size, double sum, double sumOfSquares)
    {
        double mean = sum / (double)size;
        return (sumOfSquares - mean * sum) / (double)size;
    }

    public static double weightedMean(DoubleArrayList data, DoubleArrayList weights)
    {
        int size = data.size();
        if(size != weights.size() || size == 0)
            throw new IllegalArgumentException();
        double elements[] = data.elements();
        double theWeights[] = weights.elements();
        double sum = 0.0D;
        double weightsSum = 0.0D;
        for(int i = size; --i >= 0;)
        {
            double w = theWeights[i];
            sum += elements[i] * w;
            weightsSum += w;
        }

        return sum / weightsSum;
    }

    public static double weightedRMS(double sumOfProducts, double sumOfSquaredProducts)
    {
        return sumOfProducts / sumOfSquaredProducts;
    }

    public static double winsorizedMean(DoubleArrayList sortedData, double mean, int left, int right)
    {
        int N = sortedData.size();
        if(N == 0)
            throw new IllegalArgumentException("Empty data.");
        if(left + right >= N)
            throw new IllegalArgumentException("Not enough data.");
        double sortedElements[] = sortedData.elements();
        double leftElement = sortedElements[left];
        for(int i = 0; i < left; i++)
            mean += (leftElement - sortedElements[i]) / (double)N;

        double rightElement = sortedElements[N - 1 - right];
        for(int i = 0; i < right; i++)
            mean += (rightElement - sortedElements[N - 1 - i]) / (double)N;

        return mean;
    }
}
