/*
 * Decompiled with CFR 0.152.
 */
package com.cflex.util.lpSolve;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Display
extends JPanel {
    long value = 0L;
    long lastUpdate = 0L;
    int nDigits = 8;
    Color backgroundColor = Color.black;
    public long updateTimeInterval = 1500L;
    Image[] digitos;
    Image image;

    public ImageIcon loadImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL, null);
    }

    public void timedSetValue(long l) {
        this.value = l;
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastUpdate > this.updateTimeInterval) {
            this.lastUpdate = l2;
            this.setValue(l);
        }
    }

    public void setValue(long l) {
        this.value = l;
        this.repaint(0L);
    }

    public void increment() {
        if (this.value == Long.MAX_VALUE) {
            this.value = 0L;
        }
        ++this.value;
        this.setValue(this.value);
    }

    public void timedIncrement() {
        if (this.value == Long.MAX_VALUE) {
            this.value = 0L;
        }
        ++this.value;
        this.timedSetValue(this.value);
    }

    public void setDigits(int n) {
        this.nDigits = n;
        this.repaint(0L);
    }

    public Display() {
        super(true);
        this.leDigitos();
        this.image = null;
        this.setPreferredSize(new Dimension(408, 60));
    }

    public void setImage(ImageIcon imageIcon) {
        this.image = imageIcon.getImage();
        this.repaint(0L);
    }

    public void clearImage() {
        this.image = null;
        this.repaint(0L);
    }

    public void leDigitos() {
        this.digitos = new Image[10];
        int n = 0;
        while (n < 10) {
            ImageIcon imageIcon = this.loadImageIcon("images/" + n + ".gif");
            if (imageIcon == null) {
                JOptionPane.showMessageDialog(null, "NOT FOUND:images/" + n + ".gif ABORTING!", "Error", 0);
                System.exit(0);
            } else {
                this.digitos[n] = imageIcon.getImage();
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = dimension.height;
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, (int)d, (int)d2);
        if (this.image == null) {
            int n = (int)(d / (double)this.nDigits);
            int n2 = (int)d2;
            String string = Long.toString(this.value);
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.nDigits) {
                int n6 = n3 - this.nDigits + n5;
                if (n6 < 0) {
                    graphics.drawImage(this.digitos[0], n4, 0, n, n2, null);
                } else {
                    graphics.drawImage(this.digitos[cArray[n6] - 48], n4, 0, n, n2, null);
                }
                n4 += n;
                ++n5;
            }
        } else {
            graphics.drawImage(this.image, 0, 0, (int)d, (int)d2, null);
        }
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        JFrame jFrame = new JFrame("Teste");
        jFrame.getContentPane().add(display);
        jFrame.setSize(200, 100);
        jFrame.show();
        System.out.println("Ok");
        long l = 0L;
        while (l < Long.MAX_VALUE) {
            long l2 = 0L;
            while (l2 < Long.MAX_VALUE) {
                display.setValue(l2);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++l2;
            }
            ++l;
        }
    }
}

