/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.Simulator;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

public class DESSSimulator
extends Simulator
implements DESSSimulatorInterface {
    protected double timeStep = 0.1;

    public void initialize(Replication replication) throws RemoteException, SimRuntimeException {
        super.initialize(replication);
        this.replication.getRunControl().getTreatment().getExperiment().getModel().constructModel(this);
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.simulatorTime <= this.replication.getRunControl().getRunLength() && this.isRunning()) {
            Object object = this.semaphore;
            synchronized (object) {
                this.simulatorTime += this.timeStep;
                if (this.simulatorTime > this.replication.getRunControl().getRunLength()) {
                    this.simulatorTime = this.replication.getRunControl().getRunLength();
                    this.stop();
                }
                this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStep(double timeStep) {
        Object object = this.semaphore;
        synchronized (object) {
            if (timeStep < 0.0) {
                throw new IllegalArgumentException("timeStep <0 ?");
            }
            this.timeStep = timeStep;
            Logger.finer((Object)this, (String)"setTimeStep", (String)("set the timeStep to " + timeStep));
            this.fireEvent(DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT, timeStep);
        }
    }
}

