/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulator;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

public class AnimatorWithThread
extends DEVDESSSimulator
implements AnimatorInterface {
    protected long animationDelay = 100L;

    public AnimatorWithThread() {
        new AnimationThread(this).start();
        System.out.println("Animator tread started");
    }

    public long getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(long animationDelay) {
        this.animationDelay = animationDelay;
        Logger.finer((Object)this, (String)"setAnimationDelay", (String)("set the animationDelay to " + animationDelay));
        this.fireEvent(AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT, animationDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning() && !this.eventList.isEmpty() && this.simulatorTime <= this.replication.getRunControl().getRunLength()) {
            try {
                if (this.animationDelay > 0L) {
                    Thread.sleep(this.animationDelay);
                }
            }
            catch (Exception exception2) {
                Object exception2 = null;
            }
            double runUntil = this.simulatorTime + this.timeStep;
            while (!this.eventList.isEmpty() && this.running && runUntil >= this.eventList.first().getAbsoluteExecutionTime()) {
                Object object = this.semaphore;
                synchronized (object) {
                    SimEventInterface event = this.eventList.removeFirst();
                    this.simulatorTime = event.getAbsoluteExecutionTime();
                    this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
                    try {
                        event.execute();
                    }
                    catch (Exception exception) {
                        Logger.severe((Object)this, (String)"run", (Throwable)exception);
                    }
                }
            }
            if (this.running) {
                this.simulatorTime = runUntil;
            }
            this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
        }
    }

    protected void fireAnimationEvent() {
        this.fireEvent(AnimatorInterface.UPDATE_ANIMATION_EVENT, this.simulatorTime);
        System.out.print(".");
    }

    protected class AnimationThread
    extends Thread {
        private AnimatorWithThread animator;

        public AnimationThread(AnimatorWithThread animator) {
            this.animator = animator;
        }

        public void run() {
            while (this.animator.isRunning()) {
                try {
                    if (this.animator.getAnimationDelay() <= 0L) continue;
                    Thread.sleep(this.animator.getAnimationDelay());
                    this.animator.fireAnimationEvent();
                }
                catch (Exception exception) {
                    Logger.severe((Object)this, (String)"run", (Throwable)exception);
                }
            }
        }
    }
}

