/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Requires;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;

public final class FastGenotype
extends Genotype {
    private final List<Allele> alleles;
    private final boolean isPhased;
    private final int GQ;
    private final int DP;
    private final int[] AD;
    private final int[] PL;
    private final Map<String, Object> extendedAttributes;

    @Requires(value={"sampleName != null", "alleles != null", "GQ >= -1", "DP >= -1", "validADorPLField(AD)", "validADorPLField(PL)", "extendedAttributes != null", "! hasForbiddenKey(extendedAttributes)"})
    protected FastGenotype(String string, List<Allele> list, boolean bl, int n, int n2, int[] nArray, int[] nArray2, String string2, Map<String, Object> map) {
        super(string, string2);
        this.alleles = list;
        this.isPhased = bl;
        this.GQ = n;
        this.DP = n2;
        this.AD = nArray;
        this.PL = nArray2;
        this.extendedAttributes = map;
    }

    @Override
    public List<Allele> getAlleles() {
        return this.alleles;
    }

    @Override
    public Allele getAllele(int n) {
        return this.alleles.get(n);
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public int getDP() {
        return this.DP;
    }

    @Override
    public int[] getAD() {
        return this.AD;
    }

    @Override
    public int getGQ() {
        return this.GQ;
    }

    @Override
    public int[] getPL() {
        return this.PL;
    }

    @Override
    public Map<String, Object> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    private static boolean validADorPLField(int[] nArray) {
        if (nArray != null) {
            for (int n : nArray) {
                if (n >= 0) continue;
                return false;
            }
        }
        return true;
    }
}

