/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broadinstitute.variant.bcf2.BCF2Decoder;
import org.broadinstitute.variant.bcf2.BCF2GenotypeFieldDecoders;
import org.broadinstitute.variant.bcf2.BCF2LazyGenotypesDecoder;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.bcf2.BCFVersion;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;

public final class BCF2Codec
implements FeatureCodec<VariantContext> {
    private static final int ALLOWED_MAJOR_VERSION = 2;
    private static final int MIN_MINOR_VERSION = 1;
    private BCFVersion bcfVersion = null;
    private VCFHeader header = null;
    private final ArrayList<String> contigNames = new ArrayList();
    private ArrayList<String> dictionary;
    private final BCF2Decoder decoder = new BCF2Decoder();
    private static final int MAX_HEADER_SIZE = 0x8000000;
    private BCF2GenotypeFieldDecoders gtFieldDecoders = null;
    private GenotypeBuilder[] builders = null;
    private int recordNo = 0;
    private int pos = 0;

    @Override
    public Feature decodeLoc(PositionalBufferedStream positionalBufferedStream) {
        return this.decode(positionalBufferedStream);
    }

    @Override
    public VariantContext decode(PositionalBufferedStream positionalBufferedStream) {
        try {
            ++this.recordNo;
            VariantContextBuilder variantContextBuilder = new VariantContextBuilder();
            int n = this.decoder.readBlockSize(positionalBufferedStream);
            int n2 = this.decoder.readBlockSize(positionalBufferedStream);
            this.decoder.readNextBlock(n, positionalBufferedStream);
            this.decodeSiteLoc(variantContextBuilder);
            SitesInfoForDecoding sitesInfoForDecoding = this.decodeSitesExtendedInfo(variantContextBuilder);
            this.decoder.readNextBlock(n2, positionalBufferedStream);
            this.createLazyGenotypesDecoder(sitesInfoForDecoding, variantContextBuilder);
            return variantContextBuilder.fullyDecoded(true).make();
        }
        catch (IOException iOException) {
            throw new TribbleException("Failed to read BCF file", iOException);
        }
    }

    @Override
    public Class<VariantContext> getFeatureType() {
        return VariantContext.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream positionalBufferedStream) {
        void var3_10;
        try {
            byte[] object;
            int n;
            this.bcfVersion = BCFVersion.readBCFVersion(positionalBufferedStream);
            if (this.bcfVersion == null) {
                this.error("Input stream does not contain a BCF encoded file; BCF magic header info not found");
            }
            if (this.bcfVersion.getMajorVersion() != 2) {
                this.error("BCF2Codec can only process BCF2 files, this file has major version " + this.bcfVersion.getMajorVersion());
            }
            if (this.bcfVersion.getMinorVersion() < 1) {
                this.error("BCF2Codec can only process BCF2 files with minor version >= 1 but this file has minor version " + this.bcfVersion.getMinorVersion());
            }
            if ((n = BCF2Type.INT32.read(positionalBufferedStream)) <= 0 || n > 0x8000000) {
                this.error("BCF2 header has invalid length: " + n + " must be >= 0 and < " + 0x8000000);
            }
            if (positionalBufferedStream.read(object = new byte[n]) != n) {
                this.error("Couldn't read all of the bytes specified in the header length = " + n);
            }
            PositionalBufferedStream positionalBufferedStream2 = new PositionalBufferedStream(new ByteArrayInputStream(object));
            AsciiLineReader asciiLineReader = new AsciiLineReader(positionalBufferedStream2);
            VCFCodec vCFCodec = new VCFCodec();
            this.header = (VCFHeader)vCFCodec.readHeader(asciiLineReader);
            positionalBufferedStream2.close();
        }
        catch (IOException iOException) {
            throw new TribbleException("I/O error while reading BCF2 header");
        }
        if (!this.header.getContigLines().isEmpty()) {
            this.contigNames.clear();
            for (VCFContigHeaderLine vCFContigHeaderLine : this.header.getContigLines()) {
                if (vCFContigHeaderLine.getID() == null || vCFContigHeaderLine.getID().equals("")) {
                    this.error("found a contig with an invalid ID " + vCFContigHeaderLine);
                }
                this.contigNames.add(vCFContigHeaderLine.getID());
            }
        } else {
            this.error("Didn't find any contig lines in BCF2 file header");
        }
        this.dictionary = this.parseDictionary(this.header);
        this.gtFieldDecoders = new BCF2GenotypeFieldDecoders(this.header);
        int n = this.header.getNGenotypeSamples();
        this.builders = new GenotypeBuilder[n];
        boolean bl = false;
        while (var3_10 < n) {
            this.builders[var3_10] = new GenotypeBuilder(this.header.getGenotypeSamples().get((int)var3_10));
            ++var3_10;
        }
        return new FeatureCodecHeader(this.header, positionalBufferedStream.getPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecode(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            BCFVersion bCFVersion = BCFVersion.readBCFVersion(fileInputStream);
            boolean bl = bCFVersion != null && bCFVersion.getMajorVersion() == 2;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Requires(value={"builder != null"})
    private final void decodeSiteLoc(VariantContextBuilder variantContextBuilder) throws IOException {
        int n = this.decoder.decodeInt(BCF2Type.INT32);
        String string = this.lookupContigName(n);
        variantContextBuilder.chr(string);
        this.pos = this.decoder.decodeInt(BCF2Type.INT32) + 1;
        int n2 = this.decoder.decodeInt(BCF2Type.INT32);
        variantContextBuilder.start(this.pos);
        variantContextBuilder.stop(this.pos + n2 - 1);
    }

    @Requires(value={"builder != null", "decoder != null"})
    @Ensures(value={"result != null", "result.isValid()"})
    private final SitesInfoForDecoding decodeSitesExtendedInfo(VariantContextBuilder variantContextBuilder) throws IOException {
        Object object = this.decoder.decodeSingleValue(BCF2Type.FLOAT);
        if (object != null) {
            variantContextBuilder.log10PError((Double)object / -10.0);
        }
        int n = this.decoder.decodeInt(BCF2Type.INT32);
        int n2 = this.decoder.decodeInt(BCF2Type.INT32);
        int n3 = n >> 16;
        int n4 = n & 0xFFFF;
        int n5 = n2 >> 24;
        int n6 = n2 & 0xFFFFF;
        if (this.header.getNGenotypeSamples() != n6) {
            this.error("Reading BCF2 files with different numbers of samples per record is not currently supported.  Saw " + this.header.getNGenotypeSamples() + " samples in header but have a record with " + n6 + " samples");
        }
        this.decodeID(variantContextBuilder);
        List<Allele> list = this.decodeAlleles(variantContextBuilder, this.pos, n3);
        this.decodeFilter(variantContextBuilder);
        this.decodeInfo(variantContextBuilder, n4);
        SitesInfoForDecoding sitesInfoForDecoding = new SitesInfoForDecoding(n5, n6, list);
        if (!sitesInfoForDecoding.isValid()) {
            this.error("Sites info is malformed: " + sitesInfoForDecoding);
        }
        return sitesInfoForDecoding;
    }

    private void decodeID(VariantContextBuilder variantContextBuilder) throws IOException {
        String string = (String)this.decoder.decodeTypedValue();
        if (string == null) {
            variantContextBuilder.noID();
        } else {
            variantContextBuilder.id(string);
        }
    }

    @Requires(value={"nAlleles > 0"})
    private List<Allele> decodeAlleles(VariantContextBuilder variantContextBuilder, int n, int n2) throws IOException {
        ArrayList<Allele> arrayList = new ArrayList<Allele>(n2);
        String string = null;
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)this.decoder.decodeTypedValue();
            boolean bl = i == 0;
            Allele allele = Allele.create(string2, bl);
            if (bl) {
                string = string2;
            }
            arrayList.add(allele);
        }
        assert (string != null);
        variantContextBuilder.alleles((Collection<Allele>)arrayList);
        assert (string.length() > 0);
        return arrayList;
    }

    private void decodeFilter(VariantContextBuilder variantContextBuilder) throws IOException {
        Object object = this.decoder.decodeTypedValue();
        if (object == null) {
            variantContextBuilder.unfiltered();
        } else if (object instanceof Integer) {
            String string = this.getDictionaryString((Integer)object);
            if ("PASS".equals(string)) {
                variantContextBuilder.passFilters();
            } else {
                variantContextBuilder.filter(string);
            }
        } else {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                variantContextBuilder.filter(this.getDictionaryString(n));
            }
        }
    }

    @Requires(value={"numInfoFields >= 0"})
    private void decodeInfo(VariantContextBuilder variantContextBuilder, int n) throws IOException {
        if (n == 0) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.getDictionaryString();
            Object object = this.decoder.decodeTypedValue();
            VCFCompoundHeaderLine vCFCompoundHeaderLine = VariantContextUtils.getMetaDataForField(this.header, string);
            if (vCFCompoundHeaderLine.getType() == VCFHeaderLineType.Flag) {
                object = true;
            }
            hashMap.put(string, object);
        }
        variantContextBuilder.attributes(hashMap);
    }

    private void createLazyGenotypesDecoder(SitesInfoForDecoding sitesInfoForDecoding, VariantContextBuilder variantContextBuilder) {
        if (sitesInfoForDecoding.nSamples > 0) {
            BCF2LazyGenotypesDecoder bCF2LazyGenotypesDecoder = new BCF2LazyGenotypesDecoder(this, sitesInfoForDecoding.alleles, sitesInfoForDecoding.nSamples, sitesInfoForDecoding.nFormatFields, this.builders);
            LazyData lazyData = new LazyData(this.header, sitesInfoForDecoding.nFormatFields, this.decoder.getRecordBytes());
            LazyGenotypesContext lazyGenotypesContext = new LazyGenotypesContext(bCF2LazyGenotypesDecoder, lazyData, this.header.getNGenotypeSamples());
            if (!this.header.samplesWereAlreadySorted()) {
                lazyGenotypesContext.decode();
            }
            variantContextBuilder.genotypesNoValidation(lazyGenotypesContext);
        }
    }

    @Ensures(value={"result != null"})
    private final String getDictionaryString() throws IOException {
        return this.getDictionaryString((Integer)this.decoder.decodeTypedValue());
    }

    @Requires(value={"offset < dictionary.size()"})
    @Ensures(value={"result != null"})
    protected final String getDictionaryString(int n) {
        return this.dictionary.get(n);
    }

    @Requires(value={"contigOffset >= 0", "contigOffset < contigNames.size()"})
    @Ensures(value={"result != null"})
    private final String lookupContigName(int n) {
        return this.contigNames.get(n);
    }

    @Requires(value={"header != null"})
    @Ensures(value={"result != null", "! result.isEmpty()"})
    private final ArrayList<String> parseDictionary(VCFHeader vCFHeader) {
        ArrayList<String> arrayList = BCF2Utils.makeDictionary(vCFHeader);
        if (arrayList.isEmpty()) {
            this.error("Dictionary header element was absent or empty");
        }
        return arrayList;
    }

    protected VCFHeader getHeader() {
        return this.header;
    }

    @Requires(value={"field != null"})
    @Ensures(value={"result != null"})
    protected BCF2GenotypeFieldDecoders.Decoder getGenotypeFieldDecoder(String string) {
        return this.gtFieldDecoders.getDecoder(string);
    }

    private void error(String string) throws RuntimeException {
        throw new TribbleException(String.format("%s, at record %d with position %d:", string, this.recordNo, this.pos));
    }

    public static class LazyData {
        public final VCFHeader header;
        public final int nGenotypeFields;
        public final byte[] bytes;

        @Requires(value={"nGenotypeFields > 0", "bytes != null"})
        public LazyData(VCFHeader vCFHeader, int n, byte[] byArray) {
            this.header = vCFHeader;
            this.nGenotypeFields = n;
            this.bytes = byArray;
        }
    }

    protected static final class SitesInfoForDecoding {
        final int nFormatFields;
        final int nSamples;
        final List<Allele> alleles;

        private SitesInfoForDecoding(int n, int n2, List<Allele> list) {
            this.nFormatFields = n;
            this.nSamples = n2;
            this.alleles = list;
        }

        public boolean isValid() {
            return this.nFormatFields >= 0 && this.nSamples >= 0 && this.alleles != null && !this.alleles.isEmpty() && this.alleles.get(0).isReference();
        }

        public String toString() {
            return String.format("nFormatFields = %d, nSamples = %d, alleles = %s", this.nFormatFields, this.nSamples, this.alleles);
        }
    }
}

