/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.seekablestream.SeekableStreamFactory;
import net.sf.samtools.util.BlockCompressedInputStream;

public class TabixReader {
    private String mFn;
    BlockCompressedInputStream mFp;
    private int mPreset;
    private int mSc;
    private int mBc;
    private int mEc;
    private int mMeta;
    private int mSkip;
    private String[] mSeq;
    public HashMap<String, Integer> mChr2tid;
    private static int MAX_BIN = 37450;
    private static int TAD_MIN_CHUNK_GAP = 32768;
    private static int TAD_LIDX_SHIFT = 14;
    protected TIndex[] mIndex;

    private static boolean less64(long l, long l2) {
        return l < l2 ^ l < 0L ^ l2 < 0L;
    }

    public TabixReader(String string) throws IOException {
        this.mFn = string;
        this.mFp = new BlockCompressedInputStream(SeekableStreamFactory.getStreamFor(string));
        this.readIndex();
    }

    public TabixReader(String string, SeekableStream seekableStream) throws IOException {
        this.mFn = string;
        this.mFp = new BlockCompressedInputStream(seekableStream);
        this.readIndex();
    }

    private static int reg2bins(int n, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = n2;
        if (n >= n4) {
            return 0;
        }
        if (n4 >= 0x20000000) {
            n4 = 0x20000000;
        }
        --n4;
        nArray[n3++] = 0;
        int n5 = 1 + (n >> 26);
        while (n5 <= 1 + (n4 >> 26)) {
            nArray[n3++] = n5++;
        }
        n5 = 9 + (n >> 23);
        while (n5 <= 9 + (n4 >> 23)) {
            nArray[n3++] = n5++;
        }
        n5 = 73 + (n >> 20);
        while (n5 <= 73 + (n4 >> 20)) {
            nArray[n3++] = n5++;
        }
        n5 = 585 + (n >> 17);
        while (n5 <= 585 + (n4 >> 17)) {
            nArray[n3++] = n5++;
        }
        n5 = 4681 + (n >> 14);
        while (n5 <= 4681 + (n4 >> 14)) {
            nArray[n3++] = n5++;
        }
        return n3;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        inputStream.read(byArray);
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public void readIndex(SeekableStream seekableStream) throws IOException {
        int n;
        if (seekableStream == null) {
            return;
        }
        BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(seekableStream);
        byte[] byArray = new byte[4];
        blockCompressedInputStream.read(byArray, 0, 4);
        this.mSeq = new String[TabixReader.readInt(blockCompressedInputStream)];
        this.mChr2tid = new HashMap();
        this.mPreset = TabixReader.readInt(blockCompressedInputStream);
        this.mSc = TabixReader.readInt(blockCompressedInputStream);
        this.mBc = TabixReader.readInt(blockCompressedInputStream);
        this.mEc = TabixReader.readInt(blockCompressedInputStream);
        this.mMeta = TabixReader.readInt(blockCompressedInputStream);
        this.mSkip = TabixReader.readInt(blockCompressedInputStream);
        int n2 = TabixReader.readInt(blockCompressedInputStream);
        byArray = new byte[n2];
        blockCompressedInputStream.read(byArray);
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 0) continue;
            byte[] byArray2 = new byte[n - n4];
            System.arraycopy(byArray, n4, byArray2, 0, byArray2.length);
            String string = new String(byArray2);
            this.mChr2tid.put(string, n3);
            this.mSeq[n3++] = string;
            n4 = n + 1;
        }
        this.mIndex = new TIndex[this.mSeq.length];
        for (n = 0; n < this.mSeq.length; ++n) {
            int n5 = TabixReader.readInt(blockCompressedInputStream);
            this.mIndex[n] = new TIndex();
            this.mIndex[n].b = new HashMap();
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = TabixReader.readInt(blockCompressedInputStream);
                TPair64[] tPair64Array = new TPair64[TabixReader.readInt(blockCompressedInputStream)];
                for (n3 = 0; n3 < tPair64Array.length; ++n3) {
                    long l = TabixReader.readLong(blockCompressedInputStream);
                    long l2 = TabixReader.readLong(blockCompressedInputStream);
                    tPair64Array[n3] = new TPair64(l, l2);
                }
                this.mIndex[n].b.put(n6, tPair64Array);
            }
            this.mIndex[n].l = new long[TabixReader.readInt(blockCompressedInputStream)];
            for (n3 = 0; n3 < this.mIndex[n].l.length; ++n3) {
                this.mIndex[n].l[n3] = TabixReader.readLong(blockCompressedInputStream);
            }
        }
        blockCompressedInputStream.close();
    }

    public void readIndex() throws IOException {
        this.readIndex(SeekableStreamFactory.getStreamFor(this.mFn + ".tbi"));
    }

    public String readLine() throws IOException {
        return TabixReader.readLine(this.mFp);
    }

    private int chr2tid(String string) {
        if (this.mChr2tid.containsKey(string)) {
            return this.mChr2tid.get(string);
        }
        return -1;
    }

    public int[] parseReg(String string) {
        String string2;
        int[] nArray = new int[3];
        int n = string.indexOf(58);
        int n2 = string.indexOf(45);
        String string3 = string2 = n >= 0 ? string.substring(0, n) : string;
        nArray[1] = n >= 0 ? Integer.parseInt(string.substring(n + 1, n2 >= 0 ? n2 : string.length())) - 1 : 0;
        nArray[2] = n2 >= 0 ? Integer.parseInt(string.substring(n2 + 1)) : Integer.MAX_VALUE;
        nArray[0] = this.chr2tid(string2);
        return nArray;
    }

    private TIntv getIntv(String string) {
        TIntv tIntv = new TIntv();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf(9, n3)) >= 0 || n2 == -1) {
            int n4;
            int n5;
            if (++n == this.mSc) {
                tIntv.tid = this.chr2tid(n2 != -1 ? string.substring(n3, n2) : string.substring(n3));
            } else if (n == this.mBc) {
                tIntv.end = Integer.parseInt(n2 != -1 ? string.substring(n3, n2) : string.substring(n3));
                tIntv.beg = tIntv.end++;
                if ((this.mPreset & 0x10000) == 0) {
                    --tIntv.beg;
                }
                if (tIntv.beg < 0) {
                    tIntv.beg = 0;
                }
                if (tIntv.end < 1) {
                    tIntv.end = 1;
                }
            } else if ((this.mPreset & 0xFFFF) == 0) {
                if (n == this.mEc) {
                    tIntv.end = Integer.parseInt(n2 != -1 ? string.substring(n3, n2) : string.substring(n3));
                }
            } else if ((this.mPreset & 0xFFFF) == 1) {
                if (n == 6) {
                    int n6 = 0;
                    String string2 = string.substring(n3, n2);
                    n5 = 0;
                    for (n4 = 0; n4 < string2.length(); ++n4) {
                        if (string2.charAt(n4) <= '9') continue;
                        char c = string2.charAt(n4);
                        if (c == 'M' || c == 'D' || c == 'N') {
                            n6 += Integer.parseInt(string2.substring(n5, n4));
                        }
                        n5 = n4 + 1;
                    }
                    tIntv.end = tIntv.beg + n6;
                }
            } else if ((this.mPreset & 0xFFFF) == 2) {
                String string3;
                String string4 = string3 = n2 >= 0 ? string.substring(n3, n2) : string.substring(n3);
                if (n == 4) {
                    if (string3.length() > 0) {
                        tIntv.end = tIntv.beg + string3.length();
                    }
                } else if (n == 8) {
                    n4 = -1;
                    n5 = string3.indexOf("END=");
                    if (n5 == 0) {
                        n4 = 4;
                    } else if (n5 > 0 && (n5 = string3.indexOf(";END=")) >= 0) {
                        n4 = n5 + 5;
                    }
                    if (n4 > 0) {
                        n5 = string3.indexOf(";", n4);
                        tIntv.end = Integer.parseInt(n5 > n4 ? string3.substring(n4, n5) : string3.substring(n4));
                    }
                }
            }
            if (n2 == -1) break;
            n3 = n2 + 1;
        }
        return tIntv;
    }

    public Iterator query(int n, int n2, int n3) {
        TPair64[] tPair64Array;
        int n4;
        TIndex tIndex = this.mIndex[n];
        int[] nArray = new int[MAX_BIN];
        int n5 = TabixReader.reg2bins(n2, n3, nArray);
        long l = tIndex.l.length > 0 ? (n2 >> TAD_LIDX_SHIFT >= tIndex.l.length ? tIndex.l[tIndex.l.length - 1] : tIndex.l[n2 >> TAD_LIDX_SHIFT]) : 0L;
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            tPair64Array = tIndex.b.get(nArray[n4]);
            if (tPair64Array == null) continue;
            n6 += tPair64Array.length;
        }
        if (n6 == 0) {
            return null;
        }
        Object[] objectArray = new TPair64[n6];
        n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            tPair64Array = tIndex.b.get(nArray[n4]);
            if (tPair64Array == null) continue;
            for (int i = 0; i < tPair64Array.length; ++i) {
                if (!TabixReader.less64(l, tPair64Array[i].v)) continue;
                objectArray[n6++] = new TPair64(tPair64Array[i]);
            }
        }
        Arrays.sort(objectArray, 0, n6);
        int n7 = 0;
        for (n4 = 1; n4 < n6; ++n4) {
            if (!TabixReader.less64(((TPair64)objectArray[n7]).v, ((TPair64)objectArray[n4]).v)) continue;
            ((TPair64)objectArray[++n7]).u = ((TPair64)objectArray[n4]).u;
            ((TPair64)objectArray[n7]).v = ((TPair64)objectArray[n4]).v;
        }
        n6 = n7 + 1;
        for (n4 = 1; n4 < n6; ++n4) {
            if (TabixReader.less64(((TPair64)objectArray[n4 - 1]).v, ((TPair64)objectArray[n4]).u)) continue;
            ((TPair64)objectArray[n4 - 1]).v = ((TPair64)objectArray[n4]).u;
        }
        n7 = 0;
        for (n4 = 1; n4 < n6; ++n4) {
            if (((TPair64)objectArray[n7]).v >> 16 == ((TPair64)objectArray[n4]).u >> 16) {
                ((TPair64)objectArray[n7]).v = ((TPair64)objectArray[n4]).v;
                continue;
            }
            ((TPair64)objectArray[++n7]).u = ((TPair64)objectArray[n4]).u;
            ((TPair64)objectArray[n7]).v = ((TPair64)objectArray[n4]).v;
        }
        n6 = n7 + 1;
        TPair64[] tPair64Array2 = new TPair64[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            if (objectArray[n4] == null) continue;
            tPair64Array2[n4] = new TPair64(((TPair64)objectArray[n4]).u, ((TPair64)objectArray[n4]).v);
        }
        if (tPair64Array2.length == 0 || tPair64Array2.length == 1 && tPair64Array2[0] == null) {
            return null;
        }
        return new Iterator(n, n2, n3, tPair64Array2);
    }

    public Iterator query(String string) {
        int[] nArray = this.parseReg(string);
        return this.query(nArray[0], nArray[1], nArray[2]);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
            System.exit(1);
        }
        try {
            TabixReader tabixReader = new TabixReader(stringArray[0]);
            if (stringArray.length == 1) {
                String string;
                while ((string = tabixReader.readLine()) != null) {
                    System.out.println(string);
                }
            } else {
                String string;
                Iterator iterator = tabixReader.query(stringArray[1]);
                while ((string = iterator.next()) != null) {
                    System.out.println(string);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.mFp != null) {
            try {
                this.mFp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class Iterator {
        private int i = -1;
        private int n_seeks = 0;
        private int tid;
        private int beg;
        private int end;
        private TPair64[] off;
        private long curr_off = 0L;
        private boolean iseof = false;

        public Iterator(int n, int n2, int n3, TPair64[] tPair64Array) {
            this.off = tPair64Array;
            this.tid = n;
            this.beg = n2;
            this.end = n3;
        }

        public String next() throws IOException {
            block5: {
                String string;
                if (this.iseof) {
                    return null;
                }
                while (true) {
                    if (this.curr_off == 0L || !TabixReader.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) break block5;
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            TabixReader.this.mFp.seek(this.off[this.i + 1].u);
                            this.curr_off = TabixReader.this.mFp.getFilePointer();
                            ++this.n_seeks;
                        }
                        ++this.i;
                    }
                    if ((string = TabixReader.readLine(TabixReader.this.mFp)) == null) break block5;
                    char[] cArray = string.toCharArray();
                    this.curr_off = TabixReader.this.mFp.getFilePointer();
                    if (cArray.length == 0 || cArray[0] == TabixReader.this.mMeta) continue;
                    TIntv tIntv = TabixReader.this.getIntv(string);
                    if (tIntv.tid != this.tid || tIntv.beg >= this.end) break block5;
                    if (tIntv.end > this.beg && tIntv.beg < this.end) break;
                }
                return string;
            }
            this.iseof = true;
            return null;
        }
    }

    private class TIntv {
        int tid;
        int beg;
        int end;

        private TIntv() {
        }
    }

    protected class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        protected TIndex() {
        }
    }

    protected class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long l, long l2) {
            this.u = l;
            this.v = l2;
        }

        public TPair64(TPair64 tPair64) {
            this.u = tPair64.u;
            this.v = tPair64.v;
        }

        @Override
        public int compareTo(TPair64 tPair64) {
            return this.u == tPair64.u ? 0 : (this.u < tPair64.u ^ this.u < 0L ^ tPair64.u < 0L ? -1 : 1);
        }
    }
}

