/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.util.Arrays;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.gelitext.DiploidGenotype;
import org.broad.tribble.gelitext.GeliTextFeature;

public class GeliTextCodec
extends AsciiFeatureCodec<GeliTextFeature> {
    private String[] parts;
    private String line;

    public GeliTextCodec() {
        super(GeliTextFeature.class);
    }

    @Override
    public Feature decodeLoc(String string) {
        return this.decode(string);
    }

    @Override
    public GeliTextFeature decode(String string) {
        if (string.startsWith("#") || string.startsWith("@")) {
            return null;
        }
        this.line = string;
        this.parts = string.trim().split("\\s+");
        return this.decode(this.parts);
    }

    @Override
    public GeliTextFeature decode(String[] stringArray) {
        try {
            if (stringArray.length != 18) {
                throw new CodecLineParsingException("Invalid GeliTextFeature row found -- incorrect element count.  Expected 18, got " + stringArray.length + " line = " + this.line);
            }
            char[] cArray = stringArray[5].toUpperCase().toCharArray();
            Arrays.sort(cArray);
            String string = new String(cArray);
            double[] dArray = new double[10];
            int n = 8;
            int n2 = 0;
            while (n < 18) {
                dArray[n2] = Double.valueOf(stringArray[n]);
                ++n;
                ++n2;
            }
            return new GeliTextFeature(stringArray[0], Long.valueOf(stringArray[1]), Character.toUpperCase(stringArray[2].charAt(0)), Integer.valueOf(stringArray[3]), Integer.valueOf(stringArray[4]), DiploidGenotype.toDiploidGenotype(string), Double.valueOf(stringArray[6]), Double.valueOf(stringArray[7]), dArray);
        }
        catch (CodecLineParsingException codecLineParsingException) {
            codecLineParsingException.printStackTrace();
            throw new RuntimeException("Unable to parse line " + this.line, codecLineParsingException);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new RuntimeException("Unable to parse line " + this.line, numberFormatException);
        }
    }
}

