/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.example;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.BasicFeature;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.PositionalBufferedStream;

public class ExampleBinaryCodec
implements FeatureCodec<Feature> {
    public static final String HEADER_LINE = "# BinaryTestFeature";

    @Override
    public Feature decodeLoc(PositionalBufferedStream positionalBufferedStream) throws IOException {
        return this.decode(positionalBufferedStream);
    }

    @Override
    public Feature decode(PositionalBufferedStream positionalBufferedStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(positionalBufferedStream);
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        return new BasicFeature(string, n, n2);
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream positionalBufferedStream) throws IOException {
        String string;
        AsciiLineReader asciiLineReader = new AsciiLineReader(positionalBufferedStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = 0L;
        while ((string = asciiLineReader.readLine()) != null && string.startsWith("#")) {
            arrayList.add(string);
            l = positionalBufferedStream.getPosition();
        }
        return new FeatureCodecHeader(arrayList, l);
    }

    @Override
    public Class<Feature> getFeatureType() {
        return Feature.class;
    }

    @Override
    public boolean canDecode(String string) {
        return false;
    }

    public static void convertToBinaryTest(File file, File file2, FeatureCodec<Feature> featureCodec) throws IOException {
        AbstractFeatureReader abstractFeatureReader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), featureCodec, false);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ExampleBinaryCodec.convertToBinaryTest(abstractFeatureReader, fileOutputStream);
    }

    public static void convertToBinaryTest(FeatureReader<Feature> featureReader, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeBytes("# BinaryTestFeature\n");
        CloseableTribbleIterator<Feature> closeableTribbleIterator = featureReader.iterator();
        while (closeableTribbleIterator.hasNext()) {
            Feature feature = (Feature)closeableTribbleIterator.next();
            dataOutputStream.writeUTF(feature.getChr());
            dataOutputStream.writeInt(feature.getStart());
            dataOutputStream.writeInt(feature.getEnd());
        }
        dataOutputStream.close();
        featureReader.close();
    }
}

