/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static <T> List<T> makeList(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> Set<T> makeSet(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : TArray) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static String join(Collection<?> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(obj);
        }
        return stringBuilder.toString();
    }

    public static class MultiMap<K, V>
    extends HashMap<K, Collection<V>> {
        public void append(K k, V v) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).add(v);
        }

        public void appendAll(K k, Collection<? extends V> collection) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).addAll(collection);
        }

        private void initializeKeyIfUninitialized(K k) {
            if (!this.containsKey(k)) {
                this.put(k, new LinkedList());
            }
        }
    }
}

