/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.picard.fastq.FastqWriterFactory;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class SamToFastq
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Extracts read sequences and qualities from the input SAM/BAM file and writes them into " + "the output file in Sanger fastq format. In the RC mode (default is True), if the read is aligned and the alignment is to the reverse strand on the genome, " + "the read's sequence from input SAM file will be reverse-complemented prior to writing it to fastq in order restore correctly " + "the original read sequence as it was generated by the sequencer.";
    @Option(doc="Input SAM/BAM file to extract reads from", shortName="I")
    public File INPUT;
    @Option(shortName="F", doc="Output fastq file (single-end fastq or, if paired, first end of the pair fastq).", mutex={"OUTPUT_PER_RG"})
    public File FASTQ;
    @Option(shortName="F2", doc="Output fastq file (if paired, second end of the pair fastq).", optional=true, mutex={"OUTPUT_PER_RG"})
    public File SECOND_END_FASTQ;
    @Option(shortName="OPRG", doc="Output a fastq file per read group (two fastq files per read group if the group is paired).", optional=true, mutex={"FASTQ", "SECOND_END_FASTQ"})
    public boolean OUTPUT_PER_RG;
    @Option(shortName="ODIR", doc="Directory in which to output the fastq file(s).  Used only when OUTPUT_PER_RG is true.", optional=true)
    public File OUTPUT_DIR;
    @Option(shortName="RC", doc="Re-reverse bases and qualities of reads with negative strand flag set before writing them to fastq", optional=true)
    public boolean RE_REVERSE = true;
    @Option(shortName="NON_PF", doc="Include non-PF reads from the SAM file into the output FASTQ files.")
    public boolean INCLUDE_NON_PF_READS = false;
    @Option(shortName="CLIP_ATTR", doc="The attribute that stores the position at which the SAM record should be clipped", optional=true)
    public String CLIPPING_ATTRIBUTE;
    @Option(shortName="CLIP_ACT", doc="The action that should be taken with clipped reads: 'X' means the reads and qualities should be trimmed at the clipped position; 'N' means the bases should be changed to Ns in the clipped region; and any integer means that the base qualities should be set to that value in the clipped region.", optional=true)
    public String CLIPPING_ACTION;
    @Option(shortName="R1_TRIM", doc="The number of bases to trim from the beginning of read 1.")
    public int READ1_TRIM = 0;
    @Option(shortName="R1_MAX_BASES", doc="The maximum number of bases to write from read 1 after trimming. If there are fewer than this many bases left after trimming, all will be written.  If this value is null then all bases left after trimming will be written.", optional=true)
    public Integer READ1_MAX_BASES_TO_WRITE;
    @Option(shortName="R2_TRIM", doc="The number of bases to trim from the beginning of read 2.")
    public int READ2_TRIM = 0;
    @Option(shortName="R2_MAX_BASES", doc="The maximum number of bases to write from read 2 after trimming. If there are fewer than this many bases left after trimming, all will be written.  If this value is null then all bases left after trimming will be written.", optional=true)
    public Integer READ2_MAX_BASES_TO_WRITE;
    @Option(doc="If true, include non-primary alignments in the output.  Support of non-primary alignments in SamToFastq is not comprehensive, so there may be exceptions if this is set to true and there are paired reads with non-primary alignments.")
    public boolean INCLUDE_NON_PRIMARY_ALIGNMENTS = false;
    private final Log log = Log.getInstance(SamToFastq.class);

    public static void main(String[] stringArray) {
        System.exit(new SamToFastq().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        SAMFileReader sAMFileReader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        FastqWriterFactory fastqWriterFactory = new FastqWriterFactory();
        Map<SAMReadGroupRecord, List<FastqWriter>> map = this.getWriters(sAMFileReader.getFileHeader().getReadGroups(), fastqWriterFactory);
        ProgressLogger progressLogger = new ProgressLogger(this.log);
        for (Object object : sAMFileReader) {
            if (((SAMRecord)object).getNotPrimaryAlignmentFlag() && !this.INCLUDE_NON_PRIMARY_ALIGNMENTS || ((SAMRecord)object).getReadFailsVendorQualityCheckFlag() && !this.INCLUDE_NON_PF_READS) continue;
            List<FastqWriter> list = map.get(((SAMRecord)object).getReadGroup());
            if (((SAMRecord)object).getReadPairedFlag()) {
                String string = ((SAMRecord)object).getReadName();
                Object object2 = (SAMRecord)hashMap.remove(string);
                if (object2 == null) {
                    hashMap.put(string, object);
                } else {
                    this.assertPairedMates((SAMRecord)object2, (SAMRecord)object);
                    if (list.size() == 1) {
                        if (this.OUTPUT_PER_RG) {
                            list.add(fastqWriterFactory.newWriter(this.makeReadGroupFile(((SAMRecord)object).getReadGroup(), "_2")));
                        } else {
                            throw new PicardException("Input contains paired reads but no SECOND_END_FASTQ specified.");
                        }
                    }
                    Object object3 = ((SAMRecord)object).getFirstOfPairFlag() ? object : object2;
                    Object object4 = ((SAMRecord)object).getFirstOfPairFlag() ? object2 : object;
                    this.writeRecord((SAMRecord)object3, 1, list.get(0), this.READ1_TRIM, this.READ1_MAX_BASES_TO_WRITE);
                    this.writeRecord((SAMRecord)object4, 2, list.get(1), this.READ2_TRIM, this.READ2_MAX_BASES_TO_WRITE);
                }
            } else {
                this.writeRecord((SAMRecord)object, null, list.get(0), this.READ1_TRIM, this.READ1_MAX_BASES_TO_WRITE);
            }
            progressLogger.record((SAMRecord)object);
        }
        sAMFileReader.close();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        for (List list : map.values()) {
            for (Object object2 : list) {
                if (identityHashMap.containsKey(object2)) continue;
                object2.close();
                identityHashMap.put(object2, object2);
            }
        }
        if (hashMap.size() > 0) {
            throw new PicardException("Found " + hashMap.size() + " unpaired mates");
        }
        return 0;
    }

    private Map<SAMReadGroupRecord, List<FastqWriter>> getWriters(List<SAMReadGroupRecord> list, FastqWriterFactory fastqWriterFactory) {
        HashMap<SAMReadGroupRecord, List<FastqWriter>> hashMap = new HashMap<SAMReadGroupRecord, List<FastqWriter>>();
        if (!this.OUTPUT_PER_RG) {
            ArrayList<FastqWriter> arrayList = new ArrayList<FastqWriter>();
            IoUtil.assertFileIsWritable(this.FASTQ);
            IoUtil.openFileForWriting(this.FASTQ);
            arrayList.add(fastqWriterFactory.newWriter(this.FASTQ));
            if (this.SECOND_END_FASTQ != null) {
                IoUtil.assertFileIsWritable(this.SECOND_END_FASTQ);
                IoUtil.openFileForWriting(this.SECOND_END_FASTQ);
                arrayList.add(fastqWriterFactory.newWriter(this.SECOND_END_FASTQ));
            }
            hashMap.put(null, arrayList);
            for (SAMReadGroupRecord sAMReadGroupRecord : list) {
                hashMap.put(sAMReadGroupRecord, arrayList);
            }
        } else {
            for (SAMReadGroupRecord sAMReadGroupRecord : list) {
                ArrayList<FastqWriter> arrayList = new ArrayList<FastqWriter>();
                arrayList.add(fastqWriterFactory.newWriter(this.makeReadGroupFile(sAMReadGroupRecord, "_1")));
                hashMap.put(sAMReadGroupRecord, arrayList);
            }
        }
        return hashMap;
    }

    private File makeReadGroupFile(SAMReadGroupRecord sAMReadGroupRecord, String string) {
        String string2 = sAMReadGroupRecord.getPlatformUnit();
        if (string2 == null) {
            string2 = sAMReadGroupRecord.getReadGroupId();
        }
        string2 = IoUtil.makeFileNameSafe(string2);
        if (string != null) {
            string2 = string2 + string;
        }
        string2 = string2 + ".fastq";
        File file = this.OUTPUT_DIR != null ? new File(this.OUTPUT_DIR, string2) : new File(string2);
        IoUtil.assertFileIsWritable(file);
        return file;
    }

    void writeRecord(SAMRecord sAMRecord, Integer n, FastqWriter fastqWriter, int n2, Integer n3) {
        Integer n4;
        String string = n == null ? sAMRecord.getReadName() : sAMRecord.getReadName() + "/" + n;
        String string2 = sAMRecord.getReadString();
        String string3 = sAMRecord.getBaseQualityString();
        if (this.CLIPPING_ATTRIBUTE != null && (n4 = (Integer)sAMRecord.getAttribute(this.CLIPPING_ATTRIBUTE)) != null) {
            if (this.CLIPPING_ACTION.equalsIgnoreCase("X")) {
                string2 = this.clip(string2, n4, null, !sAMRecord.getReadNegativeStrandFlag());
                string3 = this.clip(string3, n4, null, !sAMRecord.getReadNegativeStrandFlag());
            } else if (this.CLIPPING_ACTION.equalsIgnoreCase("N")) {
                string2 = this.clip(string2, n4, Character.valueOf('N'), !sAMRecord.getReadNegativeStrandFlag());
            } else {
                char c = SAMUtils.phredToFastq(new byte[]{(byte)Integer.parseInt(this.CLIPPING_ACTION)}).charAt(0);
                string3 = this.clip(string3, n4, Character.valueOf(c), !sAMRecord.getReadNegativeStrandFlag());
            }
        }
        if (this.RE_REVERSE && sAMRecord.getReadNegativeStrandFlag()) {
            string2 = SequenceUtil.reverseComplement(string2);
            string3 = StringUtil.reverseString(string3);
        }
        if (n2 > 0) {
            string2 = string2.substring(n2);
            string3 = string3.substring(n2);
        }
        if (n3 != null && n3 < string2.length()) {
            string2 = string2.substring(0, n3);
            string3 = string3.substring(0, n3);
        }
        fastqWriter.write(new FastqRecord(string, string2, "", string3));
    }

    private String clip(String string, int n, Character c, boolean bl) {
        String string2;
        block4: {
            int n2 = string.length();
            String string3 = string2 = bl ? string.substring(0, n - 1) : string.substring(n2 - n + 1);
            if (c == null) break block4;
            if (bl) {
                for (int i = n; i <= n2; ++i) {
                    string2 = string2 + c;
                }
            } else {
                for (int i = 0; i <= n2 - n; ++i) {
                    string2 = c + string2;
                }
            }
        }
        return string2;
    }

    private void assertPairedMates(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (!(sAMRecord.getFirstOfPairFlag() && sAMRecord2.getSecondOfPairFlag() || sAMRecord2.getFirstOfPairFlag() && sAMRecord.getSecondOfPairFlag())) {
            throw new PicardException("Illegal mate state: " + sAMRecord.getReadName());
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CLIPPING_ATTRIBUTE != null && this.CLIPPING_ACTION == null || this.CLIPPING_ATTRIBUTE == null && this.CLIPPING_ACTION != null) {
            return new String[]{"Both or neither of CLIPPING_ATTRIBUTE and CLIPPING_ACTION should be set."};
        }
        if (this.CLIPPING_ACTION != null && !this.CLIPPING_ACTION.equals("N") && !this.CLIPPING_ACTION.equals("X")) {
            try {
                Integer.parseInt(this.CLIPPING_ACTION);
            }
            catch (NumberFormatException numberFormatException) {
                return new String[]{"CLIPPING ACTION must be one of: N, X, or an integer"};
            }
        }
        if (this.OUTPUT_PER_RG && this.OUTPUT_DIR == null || !this.OUTPUT_PER_RG && this.OUTPUT_DIR != null) {
            return new String[]{"If OUTPUT_PER_RG is true, then OUTPUT_DIR should be set. If "};
        }
        return null;
    }
}

