/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.trityper.reader;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.molgenis.util.trityper.reader.BaseAnnot;
import org.molgenis.util.trityper.reader.SNP;
import org.molgenis.util.trityper.reader.SNPLoader;
import org.molgenis.util.trityper.reader.TriTyperGenotypeData;

public class TriTyperReader {
    private static final Logger logger = Logger.getLogger(TriTyperReader.class);

    public static void main(String[] args) {
        TriTyperGenotypeData data = new TriTyperGenotypeData();
        try {
            data.load("/Users/joeri/Desktop/BrainsetTriTyper");
            String[] snps = data.getSNPs();
            SNPLoader loader = data.createSNPLoader();
            String[] individuals = data.getIndividuals();
            for (int i = 0; i < snps.length; ++i) {
                SNP snpObject = data.getSNPObject(i);
                loader.loadGenotypes(snpObject);
                double[] dosage = null;
                if (loader.hasDosageInformation()) {
                    loader.loadDosage(snpObject);
                    dosage = snpObject.getDosageValues();
                }
                if (!snpObject.passesQC()) continue;
                System.out.println("SNP Passes QC!");
                short[] genotypes = snpObject.getGenotypes();
                byte[] alleles1 = snpObject.getAllele1();
                byte[] alleles2 = snpObject.getAllele2();
                for (int g = 0; g < genotypes.length; ++g) {
                    String allele1Str = BaseAnnot.toString(alleles1[g]);
                    String allele2Str = BaseAnnot.toString(alleles2[g]);
                    System.out.println("al1: " + allele1Str + ", al2: " + allele2Str);
                    if (loader.hasDosageInformation()) {
                        System.out.println(individuals[g] + "\t" + genotypes[g] + "\t" + dosage[g]);
                        continue;
                    }
                    System.out.println(individuals[g] + "\t" + genotypes[g]);
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }
}

