/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io.excel;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.molgenis.io.TableReader;
import org.molgenis.io.TupleReader;
import org.molgenis.io.excel.ExcelSheetReader;
import org.molgenis.io.processor.CellProcessor;

public class ExcelReader
implements TableReader,
Closeable {
    private final Workbook workbook;
    private final InputStream is;
    private final boolean hasHeader;
    private List<CellProcessor> cellProcessors;

    public ExcelReader(InputStream is) throws IOException {
        this(is, true);
    }

    public ExcelReader(InputStream is, boolean hasHeader) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        this.is = is;
        this.hasHeader = hasHeader;
        try {
            this.workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    public ExcelReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public ExcelReader(File file, boolean hasHeader) throws IOException {
        this(new FileInputStream(file), hasHeader);
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public String getSheetName(int i) {
        return this.workbook.getSheetName(i);
    }

    public ExcelSheetReader getSheet(int i) {
        Sheet poiSheet = this.workbook.getSheetAt(i);
        return poiSheet != null ? new ExcelSheetReader(poiSheet, this.hasHeader, this.cellProcessors) : null;
    }

    public ExcelSheetReader getSheet(String sheetName) {
        Sheet poiSheet = this.workbook.getSheet(sheetName);
        return poiSheet != null ? new ExcelSheetReader(poiSheet, this.hasHeader, this.cellProcessors) : null;
    }

    @Override
    public Iterator<TupleReader> iterator() {
        return new Iterator<TupleReader>(){
            private int i = 0;
            private int nrSheets = ExcelReader.this.getNumberOfSheets();

            @Override
            public boolean hasNext() {
                return this.i < this.nrSheets;
            }

            @Override
            public TupleReader next() {
                return ExcelReader.this.getSheet(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    @Override
    public TupleReader getTupleReader(String tableName) throws IOException {
        Sheet poiSheet = this.workbook.getSheet(tableName);
        return poiSheet != null ? new ExcelSheetReader(poiSheet, this.hasHeader, this.cellProcessors) : null;
    }

    @Override
    public Iterable<String> getTableNames() throws IOException {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private final int nrSheets;
                    private int i;
                    {
                        this.nrSheets = ExcelReader.this.getNumberOfSheets();
                        this.i = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.nrSheets;
                    }

                    @Override
                    public String next() {
                        return ExcelReader.this.getSheetName(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

