/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.python;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.ForEachEntityGenerator;
import org.molgenis.generators.Generator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class PythonDataTypeGen
extends ForEachEntityGenerator {
    private final boolean includeAbstract = false;
    private final boolean handwritten = false;

    public PythonDataTypeGen() {
        super(true);
    }

    @Override
    public String getDescription() {
        return "Generates Python classes for each entity.";
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate(this.getClass().getSimpleName() + this.getExtension() + ".ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            for (Entity entity : model.getEntities()) {
                String packageName = entity.getNamespace().toLowerCase() + this.getClass().getPackage().toString().substring(Generator.class.getPackage().toString().length());
                File targetDir = new File(this.getPythonSourcePath(options) + packageName.replace(".", "/").replace("/python", ""));
                boolean created = targetDir.mkdirs();
                if (!created && !targetDir.exists()) {
                    throw new IOException("could not create " + targetDir);
                }
                try {
                    if (entity.isAbstract()) {
                        this.getClass();
                        continue;
                    }
                    if (this.skipSystem().booleanValue() && entity.isSystem()) continue;
                    File targetFile = new File(targetDir + "/" + GeneratorHelper.firstToUpper(entity.getName()) + this.getType() + this.getExtension());
                    templateArgs.put("entity", entity);
                    templateArgs.put("model", model);
                    templateArgs.put("db_driver", options.db_driver);
                    templateArgs.put("template", template.getName());
                    templateArgs.put("file", targetDir + "/" + GeneratorHelper.firstToUpper(entity.getName()) + this.getType() + this.getExtension());
                    templateArgs.put("package", packageName);
                    FileOutputStream targetOut = new FileOutputStream(targetFile);
                    template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
                    ((OutputStream)targetOut).close();
                    this.logger.info((Object)("generated " + targetFile));
                }
                catch (Exception e) {
                    this.logger.error((Object)("problem generating for " + entity.getName()));
                    throw e;
                }
            }
        }
    }

    @Override
    public String getExtension() {
        return ".py";
    }
}

