/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.molgenis.MolgenisOptions;
import org.molgenis.Version;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Model;

public abstract class Generator {
    protected final String APP_DIR = "org/molgenis";

    public abstract void generate(Model var1, MolgenisOptions var2) throws Exception;

    public void generate(Model model, MolgenisOptions options, String generatedPath) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Template createTemplate(String path) throws Exception {
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        ClassTemplateLoader loader1 = new ClassTemplateLoader(this.getClass(), "");
        ClassTemplateLoader loader2 = new ClassTemplateLoader(GeneratorHelper.class, "");
        TemplateLoader[] loaders = new TemplateLoader[]{loader1, loader2};
        MultiTemplateLoader mLoader = new MultiTemplateLoader(loaders);
        cfg.setTemplateLoader((TemplateLoader)mLoader);
        return cfg.getTemplate(path);
    }

    public Map<String, Object> createTemplateArguments(MolgenisOptions options) {
        TreeMap<String, Object> args = new TreeMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        args.put("year", calendar.get(1));
        SimpleDateFormat formatter = new SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", Locale.US);
        args.put("datetime", formatter.format(new Date()));
        formatter = new SimpleDateFormat("MMMM d, yyyy", Locale.US);
        args.put("date", formatter.format(new Date()));
        args.put("generator", this.getClass().getName());
        args.put("version", Version.convertToString());
        args.put("helper", new GeneratorHelper(options));
        return args;
    }

    public String getProjectPath(MolgenisOptions options) {
        return options.output_src;
    }

    public String getWebserverPath(MolgenisOptions options) {
        return options.output_web;
    }

    public String getSourcePath(MolgenisOptions options) {
        return options.output_src;
    }

    public String getPythonSourcePath(MolgenisOptions options) {
        return options.output_python;
    }

    public String getCPPSourcePath(MolgenisOptions options) {
        return options.output_cpp;
    }

    public String getHandWrittenPath(MolgenisOptions options) {
        return options.output_hand;
    }

    public String getDocumentationPath(MolgenisOptions options) {
        return options.output_doc;
    }

    public String getSqlPath(MolgenisOptions options) {
        return options.output_sql;
    }

    public String getExtension() {
        return ".java";
    }

    public abstract String getDescription();
}

