/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.List;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.util.tuple.Tuple;

public class TupleTable
extends HtmlWidget {
    List<Tuple> tuples;

    public TupleTable(String name, List<Tuple> tuples) {
        super(name);
        assert (tuples != null);
        this.tuples = tuples;
    }

    @Override
    public String toHtml() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<div><table id=\"").append(this.getName()).append("\"><thead><tr>");
        if (!this.tuples.isEmpty()) {
            for (String name : this.tuples.get(0).getColNames()) {
                strBuilder.append("<th>").append(name).append("</th>");
            }
        }
        strBuilder.append("</tr></thead><tbody>");
        for (Tuple t : this.tuples) {
            strBuilder.append("<tr>");
            for (String name : t.getColNames()) {
                strBuilder.append("<td>").append(t.isNull(name) ? "" : t.getString(name)).append("</td>");
            }
            strBuilder.append("</tr>");
        }
        strBuilder.append("</tbody></table><script>$('#");
        strBuilder.append(this.getName());
        strBuilder.append("').dataTable({'sDom': 'T<\"clear\">lfrtip','bJQueryUI': true,'sPaginationType': 'full_numbers','sScrollX': '100%','bScrollCollapse': true, 'oTableTools': {'sSwfPath': 'js/copy_csv_xls_pdf.swf'}});</script></div>");
        return strBuilder.toString();
    }
}

