/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.util.tuple.Tuple;

public class TextLineInput<E>
extends HtmlInput<E> {
    private boolean disabled = false;

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public TextLineInput(String name) {
        super(name, null);
    }

    @Deprecated
    public TextLineInput(String name, String label, E value, boolean nillable, boolean readonly) {
        this(name, label, value, nillable, readonly, null);
    }

    public TextLineInput(String name, String label, E value, boolean nillable, boolean readonly, String description) {
        super(name, label, value, nillable, readonly, description);
    }

    public TextLineInput(String name, E value) {
        super(name, value);
    }

    public TextLineInput(Tuple t) throws HtmlInputException {
        super(t);
    }

    protected TextLineInput() {
    }

    @Override
    public String toHtml() {
        String disabledProperty;
        String classAtt = this.getClazz() != null ? this.getClazz() : "";
        classAtt = classAtt + (this.isReadonly() ? " readonly " : "");
        String string = disabledProperty = this.disabled ? " disabled=\"disabled\"" : "";
        if (this.isHidden()) {
            return "<input type=\"hidden\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" value=\"" + this.getValue() + disabledProperty + "\">";
        }
        String attributes = "";
        return "<input type=\"text\" id=\"" + this.getId() + "\" class=\"" + classAtt + "\" name=\"" + this.getName() + "\" value=\"" + this.getValue() + "\" " + attributes + this.tabIndex + disabledProperty + " />";
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        return new TextLineInput<E>(params).render();
    }
}

