/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.framework.ui.html.RepeatingPanel;
import org.molgenis.util.tuple.Tuple;

public class TablePanel
extends HtmlWidget {
    LinkedHashMap<String, HtmlInput<?>> inputs = new LinkedHashMap();

    public TablePanel() {
        this("", "");
    }

    public TablePanel(String name, String label) {
        super(name, label);
        this.setLabel(label);
    }

    public void add(HtmlInput<?> ... inputs) {
        for (HtmlInput<?> input : inputs) {
            this.inputs.put(input.getName(), input);
        }
    }

    public void remove(HtmlInput<?> ... inputs) {
        for (HtmlInput<?> input : inputs) {
            this.inputs.remove(input.getName());
        }
    }

    public HtmlInput get(String name) {
        return this.inputs.get(name);
    }

    @Override
    public String toHtml() {
        StringBuilder strBuilder = new StringBuilder();
        for (HtmlInput<?> i : this.inputs.values()) {
            strBuilder.append("<div style=\"clear:both; ");
            if (i.isHidden()) {
                strBuilder.append("display:none\"");
            } else {
                strBuilder.append("display:block\"");
            }
            if (i.getId() != null) {
                strBuilder.append(" id=\"div").append(i.getId()).append("\"");
            }
            strBuilder.append("><label style=\"width:16em;float:left;\" for=\"").append(i.getName()).append("\">");
            strBuilder.append(i.getLabel()).append("</label>").append(i.toHtml());
            strBuilder.append(!i.isNillable() ? " *" : "").append("</div>");
        }
        return strBuilder.toString();
    }

    public void setValuesFromRequest(Tuple request) {
        ArrayList inputList = new ArrayList();
        this.fillList(inputList, this);
        for (HtmlInput htmlInput : inputList) {
            Object object = request.get(htmlInput.getName());
            if (object == null) continue;
            htmlInput.setValue(object);
        }
    }

    private void fillList(List<HtmlInput<?>> inputList, TablePanel startInput) {
        for (HtmlInput<?> input : startInput.inputs.values()) {
            if (input instanceof TablePanel || input instanceof RepeatingPanel) {
                this.fillList(inputList, (TablePanel)input);
                continue;
            }
            inputList.add(input);
        }
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        throw new UnsupportedOperationException();
    }
}

