/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.List;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.OptionInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.Entity;
import org.molgenis.util.ValueLabel;
import org.molgenis.util.tuple.Tuple;

public class SelectInput
extends OptionInput<Object> {
    private String targetfield;
    private String onchange;
    private int width = 16;

    public SelectInput(Tuple t) throws HtmlInputException {
        super(t);
    }

    public SelectInput(String name) {
        super(name, null);
    }

    public SelectInput(String name, Object value) {
        super(name, value);
    }

    public SelectInput() {
    }

    @Override
    public String toHtml() {
        String onchange;
        String readonly = this.isReadonly() ? " class=\"readonly\" " : "";
        String string = onchange = this.onchange != null ? " onchange=\"" + this.onchange + "\"" : "";
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), super.getValue());
            input.setLabel(this.getLabel());
            input.setDescription(this.getDescription());
            input.setHidden(true);
            return input.toHtml();
        }
        StringBuilder optionsHtmlBuilder = new StringBuilder();
        for (ValueLabel choice : this.getOptions()) {
            if (super.getObject() != null && super.getObject().toString().equals(choice.getValue().toString())) {
                optionsHtmlBuilder.append("\t<option selected value=\"").append(choice.getValue()).append("\">");
                optionsHtmlBuilder.append(choice.getLabel()).append("</option>\n");
                continue;
            }
            if (this.isReadonly()) continue;
            optionsHtmlBuilder.append("\t<option value=\"").append(choice.getValue()).append("\">");
            optionsHtmlBuilder.append(choice.getLabel()).append("</option>\n");
        }
        if (!this.isReadonly() && this.isNillable() || "".equals(super.getObject()) && this.isNillable()) {
            if (super.getObject() != null && super.getObject().toString().equals("")) {
                optionsHtmlBuilder.insert(0, "\t<option value=\"\">&nbsp;</option>\n");
            } else {
                optionsHtmlBuilder.append("\t<option value=\"\">&nbsp;</option>\n");
            }
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL) {
            return "<select class=\"" + this.getClazz() + "\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" " + readonly + onchange + ">\n" + optionsHtmlBuilder.toString() + "</select>\n";
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            String description = " title=\"" + this.getDescription() + "\"";
            readonly = this.isReadonly() ? "readonly " : "";
            return "<select class=\"" + readonly + " ui-widget-content ui-corner-all\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" " + onchange + (this.getWidth() != -1 ? " style=\"width:" + this.getWidth() + "em;\" " : "") + description + ">\n" + optionsHtmlBuilder.toString() + "</select><script>$(\"#" + this.getId() + "\").chosen();</script>\n";
        }
        return "STYLE NOT AVAILABLE";
    }

    public String getTargetfield() {
        return this.targetfield;
    }

    public void setTargetfield(String targetfield) {
        this.targetfield = targetfield;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public void addOption(Object value, Object label) {
        this.getOptions().add(new ValueLabel(value.toString(), label.toString()));
    }

    public void setOptions(List<? extends Entity> entities, String valueField, String labelField) {
        this.getOptions().clear();
        for (Entity entity : entities) {
            this.addOption(entity.get(valueField), entity.get(labelField));
        }
    }

    public void addEntityOptions(List<? extends Entity> entities) {
        for (Entity entity : entities) {
            this.addOption(entity.getIdValue(), entity.getLabelValue());
        }
    }

    public void setEntityOptions(List<? extends Entity> entities) {
        this.getOptions().clear();
        this.addEntityOptions(entities);
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        return new SelectInput(params).render();
    }

    @Override
    public String getCustomHtmlHeaders() {
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            // empty if block
        }
        return "";
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

