/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class OnoffInput
extends HtmlInput<Boolean> {
    private String onValue = "on";

    public OnoffInput(String name, Boolean value) {
        super(name, value);
        this.setReadonly(false);
    }

    public OnoffInput(String name, String label, Boolean value) {
        super(name, value);
        this.setLabel(label);
        this.setReadonly(false);
    }

    public OnoffInput(String name, String label, Boolean value, boolean nillable, boolean readonly) {
        super(name, value);
        this.setLabel(label);
        this.setNillable(nillable);
        this.setReadonly(readonly);
    }

    public OnoffInput(Tuple t) {
        this(t.getString("name"), t.getString("label"), t.getBoolean("value"), t.getBoolean("nillable"), t.getBoolean("readonly"));
    }

    @Override
    public String toHtml() {
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), this.getValue());
            input.setHidden(true);
            return input.toHtml();
        }
        String readonly = this.isReadonly() ? "readonly " : "";
        String checked = this.getObject() != null && Boolean.valueOf(((Boolean)this.getObject()).toString()) != false ? "checked" : "";
        String html = "<input id=\"" + this.getId() + "\" type=\"checkbox\" " + readonly + checked + " name=\"" + this.getName() + " \" value=\"" + this.onValue + "\"/>";
        return html;
    }

    @Override
    public String getHtmlValue() {
        String value = this.getObject() != null && ((Boolean)this.getObject()).equals(true) ? "yes" : "no";
        return value;
    }

    public void setOnValue(String value) {
        this.onValue = value;
    }

    @Override
    public String toHtml(Tuple params) throws ParseException {
        return new OnoffInput(params).render();
    }
}

