/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class BoolInput
extends HtmlInput<Boolean> {
    public BoolInput(String name) {
        super(name, null);
    }

    public BoolInput(String name, String label) {
        super(name, label, null);
    }

    public BoolInput(String name, Boolean value) {
        super(name, value);
    }

    public BoolInput(String name, String label, Boolean value) {
        super(name, label, value);
    }

    public BoolInput(String name, String label, Boolean value, boolean nillable, boolean readonly) {
        this(name, label, value);
        this.setValue(value);
        this.setNillable(nillable);
        this.setReadonly(readonly);
    }

    public BoolInput(Tuple properties) throws HtmlInputException {
        super(properties);
    }

    protected BoolInput() {
    }

    @Override
    public String getValue() {
        if (super.getValue().equals("true")) {
            return "yes";
        }
        if (super.getValue().equals("false")) {
            return "no";
        }
        return "";
    }

    @Override
    public String toHtml() {
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), this.getValue());
            input.setLabel(this.getLabel());
            input.setDescription(this.getDescription());
            input.setHidden(true);
            return input.toHtml();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            return this.toJquery();
        }
        return this.toDefault();
    }

    private String toDefault() {
        if (this.isReadonly()) {
            return "<select class=\"readonly\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" readonly=\"readonly\">" + "<option value=\"" + this.getValue() + "\" selected>" + this.getValue() + "</option></select>\n";
        }
        return "<select id=\"" + this.getId() + "\" name=\"" + this.getName() + "\">" + "<option value=\"true\"" + (this.getValue().equals("yes") ? "selected" : "") + ">yes</option>" + "<option value=\"false\"" + (this.getValue().equals("no") ? "selected" : "") + ">no</option>" + "<option value=\"\"" + (this.getValue().equals("") ? "selected" : "") + "></option>" + "</select>\n";
    }

    private String toJquery() {
        String description = " title=\"" + this.getDescription() + "\"";
        if (this.isReadonly()) {
            return "<select data-placeholder=\"?\" style=\"width: 100px;\" class=\"readonly chzn-no-search ui-widget-content ui-corner-all\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" readonly=\"readonly\" " + description + ">" + "<option value=\"" + this.getValue() + "\" selected>" + this.getValue() + "</option></select>\n</select><script>$(\"#" + this.getId() + "\").chosen({placeholder: ''});</script>\n";
        }
        return "<select  data-placeholder=\"?\" style=\"width: 100px;\" class=\"chzn-no-search ui-widget-content ui-corner-all\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" " + description + ">" + "<option value=\"true\"" + (this.getValue().equals("yes") ? "selected" : "") + ">yes</option>" + "<option value=\"false\"" + (this.getValue().equals("no") ? "selected" : "") + ">no</option>" + (this.isNillable() ? "<option value=\"\"" + (this.getValue().equals("") ? "selected" : "") + ">?</option>" : "") + "</select>\n</select><script>$(\"#" + this.getId() + "\").chosen({placeholder: ''});</script>\n";
    }

    @Override
    public String toHtml(Tuple p) throws HtmlInputException {
        return new BoolInput(p).render();
    }
}

