/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.util.Entity;

public class ViewListViewCommand<E extends Entity>
extends SimpleCommand {
    private static final long serialVersionUID = -5921987163907171740L;
    private static final Logger logger = Logger.getLogger(ViewListViewCommand.class);

    public ViewListViewCommand(String name, ScreenController<?> parentScreen) {
        super(name, parentScreen);
        this.setLabel("View List of Records");
        this.setIcon("img/listview.png");
        this.setMenu("View");
        this.setToolbar(true);
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream downloadStream) throws Exception {
        logger.debug((Object)this.getName());
        this.getFormScreen().setMode(FormModel.Mode.LIST_VIEW);
        Integer offset = request.getInt("__offset");
        if (offset != null) {
            this.getFormScreen().getPager().setOffset(offset - 1);
        } else {
            this.getFormScreen().getPager().setOffset(this.getFormScreen().getOffset());
        }
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Override
    public boolean isVisible() {
        return !this.getFormScreen().getMode().equals((Object)FormModel.Mode.LIST_VIEW);
    }

    @Override
    public List<ActionInput> getActions() {
        return null;
    }

    @Override
    public List<HtmlInput<?>> getInputs() throws DatabaseException {
        return null;
    }
}

