/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.util.List;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.util.Entity;

public class ChangeListLimitCommand<E extends Entity>
extends SimpleCommand {
    private static final long serialVersionUID = -8328256342346578115L;
    private int limit = 5;

    public ChangeListLimitCommand(String name, ScreenController<?> parentScreen) {
        super(name, parentScreen);
        this.setLabel("Show %s items");
        this.setIcon("img/limit.png");
        this.setMenu("View");
    }

    @Override
    public boolean isVisible() {
        return this.getFormScreen().getMode().equals((Object)FormModel.Mode.LIST_VIEW);
    }

    @Override
    public String getLabel() {
        return String.format(super.getLabel(), this.getLimit());
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream downloadStream) {
        this.getFormScreen().setLimit(this.getLimit());
        return ScreenModel.Show.SHOW_MAIN;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public List<ActionInput> getActions() {
        return null;
    }

    @Override
    public List<HtmlInput<?>> getInputs() throws DatabaseException {
        return null;
    }
}

