/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.util.Entity;

public class AddCommand<E extends Entity>
extends SimpleCommand {
    private static final long serialVersionUID = 1512493344265778285L;

    public AddCommand(String name, ScreenController<?> parent) {
        super(name, parent);
        this.setLabel("Add new record");
        this.setIcon("img/new.png");
        this.setDialog(true);
        this.setMenu("Edit");
        this.setToolbar(true);
    }

    @Override
    public List<HtmlInput<?>> getInputs() throws DatabaseException {
        return this.getFormScreen().getNewRecordForm().getInputs();
    }

    @Override
    public List<ActionInput> getActions() {
        ArrayList<ActionInput> inputs = new ArrayList<ActionInput>();
        ActionInput submit = new ActionInput("Add", ActionInput.Type.SAVE);
        submit.setValue("edit_new");
        submit.setIcon("img/save.png");
        inputs.add(submit);
        ActionInput cancel = new ActionInput("cancel", ActionInput.Type.CLOSE);
        cancel.setIcon("img/cancel.png");
        inputs.add(cancel);
        return inputs;
    }

    @Override
    public boolean isVisible() {
        return !this.getFormScreen().isReadonly();
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream downloadStream) throws Exception {
        if (request.getString("__show") == null) {
            ((FormController)this.getController()).doAdd(db, request);
        }
        return ScreenModel.Show.SHOW_MAIN;
    }
}

