/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FreemarkerView;
import org.molgenis.framework.ui.MenuModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.ScreenView;
import org.molgenis.framework.ui.SimpleScreenController;
import org.molgenis.util.tuple.Tuple;

public class MenuController
extends SimpleScreenController<MenuModel> {
    private static final Logger logger = Logger.getLogger(MenuController.class);
    private static final long serialVersionUID = -7579424157884595183L;

    public MenuController(String name, ScreenController<?> parent) {
        super(name, null, parent);
        this.setModel(new MenuModel(this));
        this.getModel().setLabel(name);
    }

    @Override
    public ScreenView getView() {
        return new FreemarkerView("MenuView.ftl", this.getModel());
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream out) {
        this.doSelect(request);
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Override
    public void reload(Database db) {
        logger.debug((Object)("reloading Menu(" + this.getModel().getName() + ")"));
        ScreenModel selected = this.getModel().getSelected();
        if (selected == null) {
            logger.error((Object)(this.getModel().getName() + " has no children"));
            return;
        }
        try {
            selected.getController().reload(db);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean doSelect(Tuple request) {
        if (request.getString("select") != null) {
            this.setSelected(request.getString("select"));
            return true;
        }
        return false;
    }

    @Override
    public MenuModel getModel() {
        return (MenuModel)super.getModel();
    }

    @Override
    public ScreenModel getSelected() {
        if (this.getChild(this.selectedId) != null) {
            return ((ScreenController)this.getChild(this.selectedId)).getModel();
        }
        if (this.getChildren().size() > 0 && this.getChildren().firstElement() instanceof ScreenModel) {
            return ((ScreenController)this.getChildren().firstElement()).getModel();
        }
        return null;
    }

    @Override
    public String getCustomHtmlHeaders() {
        StringBuilder strBuilder = new StringBuilder("<!--custom html headers: ").append(this.getName()).append("-->");
        if (this.getModel() != null && this.getModel().getSelected() != null) {
            strBuilder.append(this.getModel().getSelected().getController().getCustomHtmlHeaders());
        } else {
            for (ScreenController c : this.getChildren()) {
                strBuilder.append(c.getCustomHtmlHeaders());
            }
        }
        return strBuilder.toString();
    }
}

