/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Vector;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormController;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.ScreenView;
import org.molgenis.framework.ui.SimpleScreenController;
import org.molgenis.util.Entity;
import org.molgenis.util.HandleRequestDelegationException;

public abstract class EasyPluginController<M extends ScreenModel>
extends SimpleScreenController<M>
implements ScreenModel,
ScreenView {
    private static final long serialVersionUID = 1L;
    public static Boolean HTML_WAS_ALREADY_SERVED;
    private Vector<ScreenMessage> messages = new Vector();
    private String label = null;

    public EasyPluginController(String name, ScreenController<?> parent) {
        super(name, null, parent);
        this.setModel(this);
    }

    public void handleRequest(Database db, MolgenisRequest request) throws HandleRequestDelegationException {
        this.delegate(request.getAction(), db, request, null);
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream out) throws HandleRequestDelegationException {
        this.delegate(request.getAction(), db, request, out);
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Deprecated
    public void delegate(String action, Database db, MolgenisRequest request) throws HandleRequestDelegationException {
        this.delegate(action, db, request, null);
    }

    public void delegate(String action, Database db, MolgenisRequest request, OutputStream out) throws HandleRequestDelegationException {
        block10: {
            try {
                try {
                    db.beginTx();
                    this.logger.debug((Object)("trying to use reflection to call " + this.getClass().getName() + "." + action));
                    Method m = this.getClass().getMethod(action, Database.class, MolgenisRequest.class);
                    m.invoke((Object)this, db, request);
                    this.logger.debug((Object)("call of " + this.getClass().getName() + "(name=" + this.getName() + ")." + action + " completed"));
                    if (db.inTx()) {
                        db.commitTx();
                    }
                }
                catch (NoSuchMethodException e1) {
                    if (out != null) {
                        try {
                            this.logger.debug((Object)("trying to use reflection to call " + this.getClass().getName() + "." + action));
                            Method m = this.getClass().getMethod(action, Database.class, MolgenisRequest.class, OutputStream.class);
                            m.invoke((Object)this, db, request, out);
                            this.logger.debug((Object)("call of " + this.getClass().getName() + "(name=" + this.getName() + ")." + action + " completed"));
                            if (db.inTx()) {
                                db.commitTx();
                            }
                            break block10;
                        }
                        catch (Exception e) {
                            this.getModel().setMessages(new ScreenMessage("Unknown action: " + action, false));
                            this.logger.error((Object)("call of " + this.getClass().getName() + "(name=" + this.getName() + ")." + action + "(db,tuple) failed: " + e1.getMessage()));
                            e.printStackTrace();
                            db.rollbackTx();
                        }
                        break block10;
                    }
                    this.logger.error((Object)e1);
                }
                catch (Exception e) {
                    this.logger.error((Object)("call of " + this.getClass().getName() + "(name=" + this.getName() + ")." + action + " failed: " + e.getMessage()));
                    e.printStackTrace();
                    this.getModel().setMessages(new ScreenMessage(e.getCause().getMessage(), false));
                    db.rollbackTx();
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    public <E extends Entity> FormModel<E> getParentForm(Class<E> entityClass) {
        for (ScreenController parent = (ScreenController)this.getParent(); parent != null; parent = (ScreenController)parent.getParent()) {
            if (!(parent instanceof FormController) || !((FormController)parent).getEntityClass().equals(entityClass)) continue;
            return (FormModel)parent.getModel();
        }
        throw new RuntimeException("Parent form of class " + entityClass.getName() + " is unknown in plugin name=" + this.getName());
    }

    @Override
    public void reset() {
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public ScreenController<?> getController() {
        return this;
    }

    @Override
    public Vector<ScreenMessage> getMessages() {
        return this.messages;
    }

    @Override
    public void setMessages(Vector<ScreenMessage> messages) {
        assert (messages != null);
        this.messages = messages;
    }

    @Override
    public void setMessages(ScreenMessage ... messages) {
        this.messages.clear();
        for (ScreenMessage m : messages) {
            this.messages.add(m);
        }
    }

    @Override
    public void setSuccess(String message) {
        this.setMessages(new ScreenMessage(message, true));
    }

    @Override
    public void setError(String message) {
        this.setMessages(new ScreenMessage(message, false));
    }

    @Override
    public void setController(ScreenController<? extends ScreenModel> controller) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVisible() {
        if (this.getApplicationController().getLogin().isAuthenticated()) {
            try {
                if (this.getApplicationController().getLogin().canRead(this)) {
                    return true;
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public abstract ScreenView getView();
}

