/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.tupletable.AbstractTupleTable;
import org.molgenis.framework.tupletable.FilterableTupleTable;
import org.molgenis.framework.tupletable.TableException;

public abstract class AbstractFilterableTupleTable
extends AbstractTupleTable
implements FilterableTupleTable {
    private List<QueryRule> filters = new ArrayList<QueryRule>();

    protected AbstractFilterableTupleTable() {
    }

    protected AbstractFilterableTupleTable(List<QueryRule> rules) {
        if (rules != null) {
            this.filters = rules;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.filters = new ArrayList<QueryRule>();
    }

    @Override
    public void setFilters(List<QueryRule> rules) throws TableException {
        if (rules == null) {
            throw new NullPointerException("rules cannot be null");
        }
        for (QueryRule r : rules) {
            this.verifyRulesRecursive(r);
        }
        this.filters = rules;
    }

    private void verifyRulesRecursive(QueryRule rule) throws TableException {
        if (QueryRule.Operator.LIMIT.equals((Object)rule.getOperator()) || QueryRule.Operator.LIMIT.equals((Object)rule.getOperator())) {
            throw new TableException("TupleTable doesn't support LIMIT or OFFSET QueryRules; use setLimit and setOffset instead");
        }
        if (rule.getNestedRules() != null) {
            for (QueryRule r : rule.getNestedRules()) {
                this.verifyRulesRecursive(r);
            }
        }
    }

    @Override
    public List<QueryRule> getFilters() {
        return this.filters;
    }

    @Override
    public QueryRule getSortRule() {
        QueryRule sortAsc = this.getRule(QueryRule.Operator.SORTASC);
        if (sortAsc != null) {
            return sortAsc;
        }
        return this.getRule(QueryRule.Operator.SORTDESC);
    }

    private QueryRule getRule(final QueryRule.Operator operator) {
        return (QueryRule)Iterables.find(this.filters, (Predicate)new Predicate<QueryRule>(){

            public boolean apply(@Nullable QueryRule arg0) {
                return arg0 != null ? arg0.getOperator() == operator : false;
            }
        });
    }
}

