/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.AuthStatus;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.framework.server.MolgenisServiceAuthenticationHelper;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.model.elements.Entity;

public class MolgenisDownloadService
implements MolgenisService {
    Logger logger = Logger.getLogger(MolgenisDownloadService.class);
    private final MolgenisContext mc;

    public MolgenisDownloadService(MolgenisContext mc) {
        this.mc = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(MolgenisRequest req, MolgenisResponse res) throws ParseException, DatabaseException, IOException {
        this.logger.info((Object)("starting download " + req.getRequest().getPathInfo()));
        long start_time = System.currentTimeMillis();
        res.getResponse().setBufferSize(10000);
        res.getResponse().setContentType("text/html; charset=UTF-8");
        PrintWriter out = res.getResponse().getWriter();
        Database db = req.getDatabase();
        try {
            AuthStatus authStatus = MolgenisServiceAuthenticationHelper.handleAuthentication(req, out);
            if (!authStatus.isShowApi()) {
                out.println("<html><body>");
                out.println(authStatus.getPrintMe());
                out.println("</body></html>");
            } else {
                String entityName = req.getRequest().getPathInfo().substring(req.getServicePath().length());
                if (entityName.startsWith("/")) {
                    entityName = entityName.substring(1);
                }
                if (entityName.equals("")) {
                    out.println("<html><body>");
                    out.println(authStatus.getPrintMe());
                    if (req.getDatabase().getLogin().isAuthenticated()) {
                        out.println(MolgenisServiceAuthenticationHelper.displayLogoutForm());
                    }
                    this.showAvailableDownloads(out, db, req);
                    out.println("</body></html>");
                } else {
                    List<Entity> downloadableEntities = this.getDownloadableEntities(db);
                    boolean found = false;
                    for (int i = 0; i < downloadableEntities.size() && !found; ++i) {
                        String name = downloadableEntities.get(i).getName();
                        if (name == null || !name.equals(entityName)) continue;
                        found = true;
                    }
                    if (!found) {
                        res.getResponse().sendError(404);
                        return;
                    }
                    if (req.getRequest().getQueryString() != null && req.getRequest().getQueryString().equals("__showQueryDialogue=true")) {
                        out.println("<html><body>");
                        out.println(authStatus.getPrintMe());
                        if (req.getDatabase().getLogin().isAuthenticated()) {
                            out.println(MolgenisServiceAuthenticationHelper.displayLogoutForm());
                        }
                        this.showFilterableDownload(out, entityName, db);
                        out.println("</body></html>");
                    } else {
                        this.executeQuery(out, req, db, entityName);
                    }
                }
            }
        }
        catch (Exception e) {
            out.println(e.getMessage());
            e.printStackTrace();
            this.logger.error((Object)e.getMessage());
        }
        finally {
            out.flush();
            out.close();
        }
        this.logger.info((Object)("servlet took: " + (System.currentTimeMillis() - start_time)));
        this.logger.info((Object)"------------");
    }

    private void showFilterableDownload(PrintWriter out, String entityName, Database db) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        out.println("<form>");
        out.println("You choose to download '" + entityName + "' data. (<a href=\"../find\">back</a>)<br><br> Here you can set filters before downloading:<br>");
        out.println("<table>");
        String simpleEntityName = entityName.substring(entityName.lastIndexOf(46) + 1);
        Class<? extends org.molgenis.util.Entity> klazz = db.getClassForName(simpleEntityName);
        for (String field : klazz.newInstance().getFields()) {
            out.println("<tr><td>" + field + "</td><td>=</td><td><input name=\"" + field + "\" type=\"text\"></td><tr/>");
        }
        out.println("</table>");
        out.println("<SCRIPT>function createFilterURL(fields){\t\tvar query = '';\tvar count = 0;\tfor (i = 0; i < fields.length; i++) \t{\t\tif (fields[i].value != '' && fields[i].name != '__submitbutton')\t\t{\t\t\tif(count > 0)\t\t\t\tquery +='&';\t\t\tquery += fields[i].name + '=' + fields[i].value;\t\t\tcount++;\t\t}\t}\treturn query}</SCRIPT>");
        out.println("<input name=\"__submitbutton\" type=\"submit\" value=\"Download tab delimited file\" onclick=\"window.location.href = 'http://' + window.location.host + window.location.pathname + '?'+createFilterURL(this.form.elements);\"><br><br>");
        out.println("TIP: notice how the url is bookmarkeable for future downloads!<br>");
        out.println("TIP: click 'save as...' and name it as '.txt' file.");
        out.println("</form>");
    }

    private void showAvailableDownloads(PrintWriter out, Database db, MolgenisRequest req) throws DatabaseException {
        if (!db.getLogin().isAuthenticated()) {
            out.println("You are currently browsing as anonymous.<br>");
        }
        out.println("You can download these data:<br>");
        out.println("<table>");
        for (Entity eClass : this.getDownloadableEntities(db)) {
            String name = eClass.getName();
            Class<? extends org.molgenis.util.Entity> klazz = db.getClassForName(name);
            if (!db.getLogin().canRead(klazz)) continue;
            out.println("<tr>");
            out.println("<td><a href=\"" + (req.getRequest().getPathInfo().endsWith("/") ? "" : "/" + this.mc.getVariant() + req.getServicePath() + "/") + name + "\">" + name + "</a></td>");
            out.println("<td><a href=\"" + (req.getRequest().getPathInfo().endsWith("/") ? "" : "/" + this.mc.getVariant() + req.getServicePath() + "/") + name + "?__showQueryDialogue=true\">" + "filter" + "</a></td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }

    private List<Entity> getDownloadableEntities(Database db) throws DatabaseException {
        return db.getMetaData().getEntities(false, false);
    }

    private List<QueryRule> createQueryRules(MolgenisRequest req, Class<? extends org.molgenis.util.Entity> klazz) throws Exception {
        ArrayList<QueryRule> rulesList = new ArrayList<QueryRule>();
        if (req.getRequest().getQueryString() != null) {
            String[] ruleStrings;
            for (String rule : ruleStrings = req.getRequest().getQueryString().split("&")) {
                String[] ruleElements = rule.split("=");
                if (ruleElements.length != 2) continue;
                if (ruleElements[1].startsWith("[")) {
                    ruleElements[1] = ruleElements[1].replace("%20", " ");
                    String[] values = ruleElements[1].substring(1, ruleElements[1].indexOf("]")).split(",");
                    rulesList.add(new QueryRule(ruleElements[0], QueryRule.Operator.IN, values));
                    continue;
                }
                if (ruleElements[1] == "" || "__submitbutton".equals(ruleElements[0])) continue;
                rulesList.add(new QueryRule(ruleElements[0], QueryRule.Operator.EQUALS, ruleElements[1]));
            }
        } else {
            for (String name : req.getColNames()) {
                if (!klazz.newInstance().getFields().contains(name)) continue;
                if (req.getString(name).startsWith("[")) {
                    String[] values = req.getString(name).substring(1, req.getString(name).indexOf("]")).split(",");
                    rulesList.add(new QueryRule(name, QueryRule.Operator.IN, values));
                    continue;
                }
                rulesList.add(new QueryRule(name, QueryRule.Operator.EQUALS, req.getString(name)));
            }
        }
        return rulesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(PrintWriter out, MolgenisRequest req, Database db, String entityName) throws Exception {
        String simpleEntityName = entityName.substring(entityName.lastIndexOf(46) + 1);
        Class<? extends org.molgenis.util.Entity> klazz = db.getClassForName(simpleEntityName);
        List<QueryRule> rulesList = this.createQueryRules(req, klazz);
        CsvWriter csvWriter = new CsvWriter(out);
        try {
            db.find(klazz, (TupleWriter)csvWriter, rulesList.toArray(new QueryRule[rulesList.size()]));
        }
        finally {
            csvWriter.close();
        }
    }
}

