/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import org.molgenis.framework.db.Database;
import org.molgenis.framework.server.MolgenisRequest;

public class FrontControllerAuthenticator {
    public static LoginStatus login(MolgenisRequest request, String username, String password) {
        try {
            Database db = request.getDatabase();
            if (db.getLogin().isAuthenticated()) {
                return LoginStatus.ALREADY_LOGGED_IN;
            }
            boolean loggedIn = db.getLogin().login(db, username, password);
            if (loggedIn) {
                request.getRequest().getSession().setAttribute("login", (Object)db.getLogin());
                return LoginStatus.SUCCESSFULLY_LOGGED_IN;
            }
            return LoginStatus.AUTHENTICATION_FAILURE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return LoginStatus.EXCEPTION_THROWN;
        }
    }

    public static LogoutStatus logout(MolgenisRequest request) {
        try {
            Database db = request.getDatabase();
            if (!db.getLogin().isAuthenticated()) {
                return LogoutStatus.ALREADY_LOGGED_OUT;
            }
            request.getDatabase().getLogin().logout(request.getDatabase());
            request.getRequest().getSession().setAttribute("login", null);
            return LogoutStatus.SUCCESSFULLY_LOGGED_OUT;
        }
        catch (Exception e) {
            e.printStackTrace();
            return LogoutStatus.EXCEPTION_THROWN;
        }
    }

    public static enum LogoutStatus {
        SUCCESSFULLY_LOGGED_OUT,
        ALREADY_LOGGED_OUT,
        EXCEPTION_THROWN;

    }

    public static enum LoginStatus {
        SUCCESSFULLY_LOGGED_IN,
        ALREADY_LOGGED_IN,
        AUTHENTICATION_FAILURE,
        EXCEPTION_THROWN;

    }
}

