/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;

class Dallocate {
    private Dallocate() {
    }

    protected static int plasma_alloc_aux_work_tau() {
        int size_elems = Dcommon.plasma_cntrl.NB_max * Dcommon.plasma_cntrl.NB_max;
        int cores_max = Dcommon.plasma_cntrl.cores_max;
        double[][] WORK = Dcommon.plasma_aux.WORK;
        int core = 0;
        while (core < cores_max) {
            WORK[core] = new double[size_elems];
            ++core;
        }
        size_elems = Dcommon.plasma_cntrl.NB_max;
        double[][] TAU = Dcommon.plasma_aux.TAU;
        core = 0;
        while (core < cores_max) {
            TAU[core] = new double[size_elems];
            ++core;
        }
        return 0;
    }

    protected static int plasma_free_aux_work_tau() {
        Dcommon.plasma_aux.WORK = null;
        Dcommon.plasma_aux.TAU = null;
        return 0;
    }

    protected static int plasma_alloc_aux_progress(int size_elems) {
        int[] mem_block = new int[size_elems];
        Dcommon.plasma_aux.progress = mem_block;
        Dcommon.plasma_cntrl.progress_size_elems = size_elems;
        return 0;
    }

    protected static int plasma_free_aux_progress() {
        Dcommon.plasma_aux.progress = null;
        Dcommon.plasma_cntrl.progress_size_elems = 0;
        return 0;
    }

    protected static int plasma_alloc_aux_bdl(int size_elems) {
        double[] mem_block = new double[size_elems];
        Dcommon.plasma_aux.bdl_mem = mem_block;
        Dcommon.plasma_cntrl.bdl_size_elems = size_elems;
        return 0;
    }

    protected static int plasma_free_aux_bdl() {
        Dcommon.plasma_aux.bdl_mem = null;
        Dcommon.plasma_cntrl.bdl_size_elems = 0;
        return 0;
    }

    protected static double[] plasma_Allocate_T(int M, int N) {
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_allocate_T", "PLASMA not initialized");
            return null;
        }
        int status = Dauxiliary.plasma_tune(3, M, N, 0);
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_allocate_T", "plasma_tune() failed");
            return null;
        }
        int NB = Dcommon.plasma_cntrl.NB;
        int NT = N % NB == 0 ? N / NB : N / NB + 1;
        int MT = M % NB == 0 ? M / NB : M / NB + 1;
        double[] T = new double[MT * NT * Dcommon.plasma_cntrl.IBNBSIZE];
        return T;
    }

    protected static double[] plasma_Allocate_L(int M, int N) {
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_allocate_L", "PLASMA not initialized");
            return null;
        }
        int status = Dauxiliary.plasma_tune(3, M, N, 0);
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_allocate_L", "plasma_tune() failed");
            return null;
        }
        int NB = Dcommon.plasma_cntrl.NB;
        int NT = N % NB == 0 ? N / NB : N / NB + 1;
        int MT = M % NB == 0 ? M / NB : M / NB + 1;
        double[] L = new double[MT * NT * Dcommon.plasma_cntrl.IBNBSIZE];
        return L;
    }

    protected static int[] plasma_Allocate_IPIV(int M, int N) {
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_allocate_IPIV", "PLASMA not initialized");
            return null;
        }
        int status = Dauxiliary.plasma_tune(3, M, N, 0);
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_allocate_IPIV", "plasma_tune() failed");
            return null;
        }
        int NB = Dcommon.plasma_cntrl.NB;
        int NT = N % NB == 0 ? N / NB : N / NB + 1;
        int MT = M % NB == 0 ? M / NB : M / NB + 1;
        int[] IPIV = new int[MT * NB * NT];
        return IPIV;
    }
}

