/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;

public class VariantCombinedFilter
implements VariantFilter {
    private final List<VariantFilter> variantFilters;

    public VariantCombinedFilter(VariantFilter ... variantFilters) {
        this.variantFilters = Arrays.asList(variantFilters);
    }

    public VariantCombinedFilter() {
        this.variantFilters = new ArrayList<VariantFilter>();
    }

    public VariantCombinedFilter(List<VariantFilter> variantFilters) {
        this.variantFilters = variantFilters == null ? new ArrayList() : variantFilters;
    }

    @Override
    public boolean doesVariantPassFilter(GeneticVariant variant) {
        for (VariantFilter filter : this.variantFilters) {
            if (filter.doesVariantPassFilter(variant)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doesIdPassFilter(String id) {
        for (VariantFilter filter : this.variantFilters) {
            if (filter.doesIdPassFilter(id)) continue;
            return false;
        }
        return true;
    }

    public void add(VariantFilter v) {
        this.variantFilters.add(v);
    }
}

