/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.util.MafResult;

public class MafCalculator {
    public static MafResult calculateMaf(Alleles alleles, Allele reference, List<Alleles> samplesAlleles) {
        HashMap<Allele, AtomicInteger> alleleCounts = new HashMap<Allele, AtomicInteger>(alleles.getAlleles().size());
        for (Allele allele : alleles.getAlleles()) {
            alleleCounts.put(allele, new AtomicInteger());
        }
        for (Alleles sampleAlleles : samplesAlleles) {
            if (sampleAlleles == null) continue;
            for (Allele sampleAllele : sampleAlleles.getAlleles()) {
                if (sampleAllele == null || sampleAllele == Allele.ZERO) continue;
                if (!alleleCounts.containsKey(sampleAllele)) {
                    throw new NullPointerException("No counter for allele: " + sampleAllele + " expected one of the following alleles: " + alleles);
                }
                ((AtomicInteger)alleleCounts.get(sampleAllele)).incrementAndGet();
            }
        }
        Allele provisionalMinorAllele = reference != null ? reference : alleles.getAlleles().get(0);
        int provisionalMinorAlleleCount = ((AtomicInteger)alleleCounts.get(provisionalMinorAllele)).get();
        int totalAlleleCount = 0;
        for (Allele allele : alleles.getAlleles()) {
            int alleleCount = ((AtomicInteger)alleleCounts.get(allele)).get();
            totalAlleleCount += alleleCount;
            if (alleleCount >= provisionalMinorAlleleCount) continue;
            provisionalMinorAlleleCount = alleleCount;
            provisionalMinorAllele = allele;
        }
        return new MafResult(provisionalMinorAllele, (float)provisionalMinorAlleleCount / (float)totalAlleleCount);
    }
}

