/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.trityper;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.CaseControlAnnotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.sampleFilter.SampleIncludedFilter;
import org.molgenis.genotype.trityper.TriTyperAlleleAnnotation;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariantTriTyper;
import org.molgenis.genotype.variant.range.GeneticVariantRange;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.genotype.variantFilter.VariantFilter;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;

public class TriTyperGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private final List<Boolean> samplePhasing;
    private final GeneticVariantRange snps;
    private final SampleVariantsProvider variantProvider;
    private final File genotypeDataFile;
    private final File imputedDosageDataFile;
    private final File snpFile;
    private final File snpMapFile;
    private final File individualFile;
    private final File phenotypeAnnotationFile;
    private static final Logger LOG = Logger.getLogger(TriTyperGenotypeData.class);
    private final int cacheSize;
    private final RandomAccessFile dosageHandle;
    private final RandomAccessFile genotypeHandle;
    private final FileChannel dosageChannel;
    private final int sampleVariantProviderUniqueId;
    private HashMap<String, SampleAnnotation> sampleAnnotationMap;
    private HashMap<String, Sequence> sequences;
    private final VariantFilter variantFilter;
    private final SampleFilter sampleFilter;
    private int unfilteredSnpCount;
    private ArrayList<Sample> includedSamples;
    private ArrayList<Sample> samples;

    public TriTyperGenotypeData(String location) throws IOException {
        this(new File(location), 1024, null, null);
    }

    public TriTyperGenotypeData(String location, int cacheSize) throws IOException {
        this(new File(location), cacheSize, null, null);
    }

    public TriTyperGenotypeData(String location, int cacheSize, VariantFilter variantFilter) throws IOException {
        this(new File(location), cacheSize, variantFilter, null);
    }

    public TriTyperGenotypeData(String location, int cacheSize, VariantFilter variantFilter, boolean readOnlyIncludedIndividuals) throws IOException {
        this(new File(location), cacheSize, variantFilter, readOnlyIncludedIndividuals ? new SampleIncludedFilter() : null);
    }

    public TriTyperGenotypeData(File location) throws IOException {
        this(location, 1024, null, null);
    }

    public TriTyperGenotypeData(File location, int cacheSize, VariantFilter variantFilter, boolean readOnlyIncludedIndividuals) throws IOException {
        this(location, cacheSize, variantFilter, readOnlyIncludedIndividuals ? new SampleIncludedFilter() : null);
    }

    public TriTyperGenotypeData(File location, int cacheSize, VariantFilter variantFilter, SampleFilter sampleFilter) throws IOException {
        this(new File(location, "GenotypeMatrix.dat"), new File(location, "ImputedDosageMatrix.dat").exists() ? new File(location, "ImputedDosageMatrix.dat") : null, new File(location, "SNPs.txt.gz").exists() ? new File(location, "SNPs.txt.gz") : new File(location, "SNPs.txt"), new File(location, "SNPMappings.txt.gz").exists() ? new File(location, "SNPMappings.txt.gz") : new File(location, "SNPMappings.txt"), new File(location, "Individuals.txt.gz").exists() ? new File(location, "Individuals.txt.gz") : new File(location, "Individuals.txt"), new File(location, "PhenotypeInformation.txt.gz").exists() ? new File(location, "PhenotypeInformation.txt.gz") : new File(location, "PhenotypeInformation.txt"), cacheSize, variantFilter, sampleFilter);
    }

    public TriTyperGenotypeData(File genotypeDataFile, File imputedDosageDataFile, File snpFile, File snpMapFile, File individualFile, File phenotypeAnnotationFile, int cacheSize, VariantFilter variantFilter, SampleFilter sampleFilter) throws IOException {
        this.variantFilter = variantFilter;
        this.sampleFilter = sampleFilter;
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.variantProvider = cacheSize <= 0 ? this : new CachedSampleVariantProvider(this, cacheSize);
        this.cacheSize = cacheSize;
        this.genotypeDataFile = genotypeDataFile;
        if (!genotypeDataFile.exists()) {
            throw new GenotypeDataException("GenotypeMatrix.dat not found at: " + genotypeDataFile.getAbsolutePath());
        }
        this.imputedDosageDataFile = imputedDosageDataFile;
        if (this.imputedDosageDataFile != null && !this.imputedDosageDataFile.exists()) {
            throw new GenotypeDataException("ImputedDosageMatrix.dat not found at:" + this.imputedDosageDataFile.getAbsolutePath());
        }
        this.snpFile = snpFile;
        if (!this.snpFile.exists()) {
            throw new GenotypeDataException("SNPs.txt or SNPs.txt.gz at:" + this.snpFile.getAbsolutePath());
        }
        this.snpMapFile = snpMapFile;
        if (!this.snpMapFile.exists()) {
            throw new GenotypeDataException("SNPMappings.txt or SNPMappings.txt.gz at:" + this.snpMapFile.getAbsolutePath());
        }
        this.individualFile = individualFile;
        if (!this.individualFile.exists()) {
            throw new GenotypeDataException("Individuals.txt or Individuals.txt.gz at:" + this.individualFile.getAbsolutePath());
        }
        this.phenotypeAnnotationFile = phenotypeAnnotationFile;
        if (!this.phenotypeAnnotationFile.exists()) {
            throw new GenotypeDataException("PhenotypeInformation.txt or PhenotypeInformation.txt.gz at:" + this.phenotypeAnnotationFile.getAbsolutePath());
        }
        if (imputedDosageDataFile != null) {
            this.dosageHandle = new RandomAccessFile(imputedDosageDataFile, "r");
            this.dosageChannel = this.dosageHandle.getChannel();
        } else {
            this.dosageHandle = null;
            this.dosageChannel = null;
        }
        this.genotypeHandle = new RandomAccessFile(genotypeDataFile, "r");
        this.loadSamples();
        this.samplePhasing = Collections.nCopies(this.includedSamples.size(), false);
        GeneticVariantRange.ClassGeneticVariantRangeCreate snpsFactory = GeneticVariantRange.createRangeFactory();
        this.loadSNPAnnotation(snpsFactory);
        this.snps = snpsFactory.createRange();
        this.checkFileSize();
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        Iterable<GeneticVariant> variants = this.getVariantsByPos(seqName, startPos);
        Iterator<GeneticVariant> i$ = variants.iterator();
        if (i$.hasNext()) {
            GeneticVariant variant = i$.next();
            return variant;
        }
        return null;
    }

    private void loadSamples() throws IOException {
        int i = 0;
        TextFile t = new TextFile(this.individualFile, false);
        String[] lineElems = t.readLineElemsReturnReference(TextFile.tab);
        this.samples = new ArrayList();
        HashMap<String, Sample> sampleNameToSampleObj = new HashMap<String, Sample>();
        while (lineElems != null) {
            String individual = new String(lineElems[0].getBytes("UTF-8"));
            Sample sample = new Sample(individual, null, null);
            sampleNameToSampleObj.put(individual, sample);
            this.samples.add(sample);
            ++i;
            lineElems = t.readLineElemsReturnReference(TextFile.tab);
        }
        t.close();
        t = new TextFile(this.phenotypeAnnotationFile, false);
        int numIncluded = 0;
        int numFemale = 0;
        int numMale = 0;
        int numUnknownSex = 0;
        int numCase = 0;
        int numControl = 0;
        int numUnknown = 0;
        boolean numAnnotated = false;
        lineElems = t.readLineElemsReturnReference(TextFile.tab);
        HashSet<Sample> visitedSamples = new HashSet<Sample>();
        while (lineElems != null) {
            String individual = lineElems[0];
            Sample sampleObj = (Sample)sampleNameToSampleObj.get(individual);
            if (sampleObj != null) {
                if (visitedSamples.contains(sampleObj)) {
                    LOG.warn((Object)("Sample " + sampleObj.getId() + " may have duplicate annotation in PhenotypeInformation.txt."));
                } else {
                    CaseControlAnnotation caseControlStatus;
                    Boolean includeSample = this.parseIncludeExcludeStatus(lineElems[2]);
                    if (!includeSample.booleanValue()) {
                        ++numIncluded;
                    }
                    if ((caseControlStatus = CaseControlAnnotation.getCaseAnnotationForTriTyper(lineElems[1])) == CaseControlAnnotation.CASE) {
                        ++numCase;
                    } else if (caseControlStatus == CaseControlAnnotation.CONTROL) {
                        ++numControl;
                    } else {
                        ++numUnknown;
                    }
                    SexAnnotation sex = SexAnnotation.getSexAnnotationForTriTyper(lineElems[3]);
                    if (sex == SexAnnotation.FEMALE) {
                        ++numFemale;
                    } else if (sex == SexAnnotation.MALE) {
                        ++numMale;
                    } else {
                        ++numUnknownSex;
                    }
                    sampleObj.putAnnotationValues("sampleInclude", includeSample);
                    sampleObj.putAnnotationValues("caseControl", (Object)caseControlStatus);
                    sampleObj.putAnnotationValues("sex_generic", (Object)sex);
                    visitedSamples.add(sampleObj);
                }
            }
            lineElems = t.readLineElemsReturnReference(TextFile.tab);
        }
        t.close();
        if (this.sampleFilter != null) {
            this.includedSamples = new ArrayList(numIncluded);
            for (Sample sample : this.samples) {
                if (!this.sampleFilter.doesSamplePassFilter(sample)) continue;
                this.includedSamples.add(sample);
            }
        } else {
            this.includedSamples = this.samples;
        }
        LOG.info((Object)("Loaded " + this.includedSamples.size() + " out of " + this.samples.size() + " samples."));
        this.sampleAnnotationMap = new HashMap(3);
        this.sampleAnnotationMap.put("sampleInclude", new SampleAnnotation("sampleInclude", "sampleInclude", null, Annotation.Type.BOOLEAN, SampleAnnotation.SampleAnnotationType.OTHER, false));
        this.sampleAnnotationMap.put("caseControl", new SampleAnnotation("caseControl", "caseControl", null, Annotation.Type.CASECONTROL, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false));
        this.sampleAnnotationMap.put("sex_generic", new SampleAnnotation("sex_generic", "sex_generic", null, Annotation.Type.SEX, SampleAnnotation.SampleAnnotationType.COVARIATE, false));
    }

    private Boolean parseIncludeExcludeStatus(String status) {
        if (status == null) {
            return false;
        }
        if (status.toLowerCase().equals("exclude")) {
            return false;
        }
        if (status.toLowerCase().equals("include")) {
            return true;
        }
        return false;
    }

    private void loadSNPAnnotation(GeneticVariantRange.ClassGeneticVariantRangeCreate snpsFactory) throws IOException {
        TextFile tf = new TextFile(this.snpFile, false);
        HashMap<String, Integer> allSNPHash = new HashMap<String, Integer>();
        this.unfilteredSnpCount = 0;
        for (String line : tf) {
            if (this.variantFilter == null || this.variantFilter.doesIdPassFilter(line)) {
                allSNPHash.put(line, this.unfilteredSnpCount);
            }
            ++this.unfilteredSnpCount;
        }
        tf.close();
        TextFile tfSNPMap = new TextFile(this.snpMapFile, false);
        int numberOfIncludedSNPsWithAnnotation = 0;
        this.sequences = new HashMap();
        int lineCount = 0;
        for (String[] stringArray : tfSNPMap.readLineElemsIterable(TextFile.tab)) {
            ++lineCount;
            if (stringArray.length != 3) {
                throw new GenotypeDataException("Error in Trityper SNPMappings.txt. Line number " + lineCount + " does not contain 3 elements: ");
            }
            if (!allSNPHash.containsKey(stringArray[2])) continue;
            String snp = stringArray[2];
            int pos = 0;
            String chr = stringArray[0].intern();
            if (!this.sequences.containsKey(chr) && !chr.equals("0")) {
                this.sequences.put(chr, new SimpleSequence(chr, 0, this));
            }
            try {
                pos = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Position defined for " + snp + " on chromosome " + chr + " is not an integer!"));
            }
            ReadOnlyGeneticVariantTriTyper variant = new ReadOnlyGeneticVariantTriTyper(snp, pos, chr, this.variantProvider, (Integer)allSNPHash.remove(snp));
            if (this.variantFilter != null && !this.variantFilter.doesVariantPassFilter(variant)) continue;
            snpsFactory.addVariant(variant);
            ++numberOfIncludedSNPsWithAnnotation;
        }
        tfSNPMap.close();
        for (Map.Entry entry : allSNPHash.entrySet()) {
            ReadOnlyGeneticVariantTriTyper variant = new ReadOnlyGeneticVariantTriTyper((String)entry.getKey(), 0, "0", this.variantProvider, (Integer)entry.getValue());
            if (this.variantFilter != null && !this.variantFilter.doesVariantPassFilter(variant)) continue;
            snpsFactory.addVariant(variant);
        }
        LOG.info((Object)("Loaded " + snpsFactory.size() + " out of " + this.unfilteredSnpCount + " SNPs, " + numberOfIncludedSNPsWithAnnotation + " of loaded SNPs have annotation."));
    }

    private void checkFileSize() {
        long detectedsize;
        long expectedfilesize = (long)(this.unfilteredSnpCount * 2) * (long)this.samples.size();
        if (expectedfilesize != (detectedsize = this.genotypeDataFile.length())) {
            throw new GenotypeDataException("Size of GenotypeMatrix.dat does not match size defined by Indivuals.txt and SNPs.txt. Expected size: " + expectedfilesize + " (" + Gpio.humanizeFileSize((long)expectedfilesize) + ")\tDetected size: " + detectedsize + " (" + Gpio.humanizeFileSize((long)detectedsize) + ")\tDiff: " + Math.abs(expectedfilesize - detectedsize));
        }
        if (this.imputedDosageDataFile != null && (expectedfilesize = (long)this.unfilteredSnpCount * (long)this.samples.size()) != (detectedsize = this.imputedDosageDataFile.length())) {
            throw new GenotypeDataException("Size of ImputedDosageMatrix.dat does not match size defined by Indivuals.txt and SNPs.txt. Expected size: " + expectedfilesize + " (" + Gpio.humanizeFileSize((long)expectedfilesize) + ")\tDetected size: " + detectedsize + " (" + Gpio.humanizeFileSize((long)detectedsize) + ")\tDiff: " + Math.abs(expectedfilesize - detectedsize));
        }
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return this.imputedDosageDataFile == null;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertDosageToProbabilityHeuristic(variant.getSampleDosages());
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        int index = ((ReadOnlyGeneticVariantTriTyper)variant).getIndexOfVariantInTriTyperData();
        int numIndividuals = this.samples.size();
        long indexLong = (long)index * (long)(numIndividuals * 2);
        byte[] buffer = new byte[2 * numIndividuals];
        try {
            this.genotypeHandle.seek(indexLong);
            if (this.genotypeHandle.read(buffer) != buffer.length) {
                throw new GenotypeDataException("Could not read bytes from: " + indexLong + " in genotype file " + this.genotypeDataFile.getAbsolutePath() + " (size: " + this.genotypeDataFile.length() + ")");
            }
        }
        catch (IOException e) {
            throw new GenotypeDataException("Could not read bytes from: " + indexLong + " in genotype file " + this.genotypeDataFile.getAbsolutePath() + " (size: " + this.genotypeDataFile.length() + ")");
        }
        ArrayList<Alleles> alleles = new ArrayList<Alleles>(this.includedSamples.size());
        for (int i = 0; i < numIndividuals; ++i) {
            if (this.sampleFilter != null && !this.sampleFilter.doesSamplePassFilter(this.samples.get(i))) continue;
            int allele2Pos = numIndividuals + i;
            Alleles a = Alleles.createAlleles(TriTyperAlleleAnnotation.convertByteToAllele(buffer[i]), TriTyperAlleleAnnotation.convertByteToAllele(buffer[allele2Pos]));
            alleles.add(a);
        }
        return alleles;
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        float[] genotypes = CalledDosageConvertor.convertCalledAllelesToDosage(variant.getSampleVariants(), variant.getVariantAlleles(), variant.getRefAllele());
        if (this.imputedDosageDataFile != null) {
            int ind;
            byte[] dosageValues;
            int index = ((ReadOnlyGeneticVariantTriTyper)variant).getIndexOfVariantInTriTyperData();
            int numIndividuals = this.samples.size();
            long indexLong = (long)index * (long)numIndividuals;
            ByteBuffer buffer = ByteBuffer.allocate(numIndividuals);
            try {
                this.dosageChannel.read(buffer, indexLong);
            }
            catch (IOException e) {
                throw new GenotypeDataException("Could not read bytes from: " + indexLong + " in genotype file " + this.genotypeDataFile.getAbsolutePath() + " (size: " + this.genotypeDataFile.length() + ")");
            }
            byte[] dosageValuesAll = buffer.array();
            if (this.sampleFilter == null) {
                dosageValues = dosageValuesAll;
            } else {
                dosageValues = new byte[this.includedSamples.size()];
                int j = 0;
                for (int i = 0; i < dosageValuesAll.length; ++i) {
                    if (!this.sampleFilter.doesSamplePassFilter(this.samples.get(i))) continue;
                    dosageValues[j] = dosageValuesAll[i];
                    ++j;
                }
            }
            boolean takeComplement = false;
            for (ind = 0; ind < dosageValues.length; ++ind) {
                if (dosageValues[ind] == 127) continue;
                double dosagevalue = (double)(128 + dosageValues[ind]) / 100.0;
                if (genotypes[ind] == 0.0f && dosagevalue > 1.0) {
                    takeComplement = true;
                    break;
                }
                if (genotypes[ind] != 2.0f || !(dosagevalue < 1.0)) continue;
                takeComplement = true;
                break;
            }
            if (takeComplement) {
                for (ind = 0; ind < dosageValues.length; ++ind) {
                    byte dosageValue;
                    if (dosageValues[ind] == 127) continue;
                    dosageValues[ind] = dosageValue = (byte)(200 - (128 + dosageValues[ind]) + -128);
                }
            }
            float[] dosageValuesFloat = new float[this.includedSamples.size()];
            for (int i = 0; i < dosageValues.length; ++i) {
                dosageValuesFloat[i] = dosageValues[i] == 127 ? -1.0f : (float)(128 + dosageValues[i]) / 100.0f;
            }
            return dosageValuesFloat;
        }
        return genotypes;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        byte[] genotypes = CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.variantProvider.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        return genotypes;
    }

    @Override
    public List<Sample> getSamples() {
        return this.includedSamples;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        return this.samplePhasing;
    }

    @Override
    public int cacheSize() {
        return this.cacheSize;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.imputedDosageDataFile != null) {
                this.dosageChannel.close();
                this.dosageHandle.close();
            }
            this.genotypeHandle.close();
        }
        catch (IOException e) {
            throw new GenotypeDataException("Could not close file handle to TriTyper file: " + this.genotypeDataFile);
        }
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotationMap;
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequences.keySet());
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.sequences.values();
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.snps.getVariantAtPos(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.snps.getVariantsBySequence(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.snps.getVariantsByRange(seqName, rangeStart, rangeEnd);
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.snps.iterator();
    }
}

