/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.util.Utils;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.util.tuple.Tuple;

public class OxfordSampleFile {
    private static final Logger LOGGER = Logger.getLogger(OxfordSampleFile.class);
    private final File sampleFile;
    private final Map<String, SampleAnnotation> sampleAnnotations;
    private final List<Sample> samples;

    public OxfordSampleFile(File sampleFile) throws FileNotFoundException, IOException {
        if (sampleFile == null) {
            throw new IllegalArgumentException("sampleFile is null");
        }
        if (!sampleFile.isFile()) {
            throw new FileNotFoundException("sample file file not found at " + sampleFile.getAbsolutePath());
        }
        if (!sampleFile.canRead()) {
            throw new IOException("Can not read sample file " + sampleFile.getAbsolutePath());
        }
        this.sampleFile = sampleFile;
        this.sampleAnnotations = new LinkedHashMap<String, SampleAnnotation>();
        this.samples = new ArrayList<Sample>();
        this.loadAnnotations();
        this.loadSamples();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnnotations() throws IOException {
        SampleAnnotation missingAnnotation = new SampleAnnotation("sampleMissingRateFloat", "missing", "Missing data proportion of each individual", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.OTHER, false);
        this.sampleAnnotations.put(missingAnnotation.getId(), missingAnnotation);
        CsvReader reader = null;
        try {
            reader = new CsvReader(this.sampleFile, ' ');
            List colNames = Utils.iteratorToList(reader.colNamesIterator());
            Tuple dataTypes = (Tuple)reader.iterator().next();
            for (int i = 3; i < colNames.size(); ++i) {
                SampleAnnotation annotation = null;
                if (dataTypes.getString(i).equalsIgnoreCase("D")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.STRING, SampleAnnotation.SampleAnnotationType.COVARIATE, false);
                } else if (dataTypes.getString(i).equalsIgnoreCase("C")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.COVARIATE, false);
                } else if (dataTypes.getString(i).equalsIgnoreCase("P")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false);
                } else if (dataTypes.getString(i).equalsIgnoreCase("B")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.BOOLEAN, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false);
                } else {
                    LOGGER.warn((Object)("Unknown datatype [" + dataTypes.getString(i) + "]"));
                }
                if (annotation == null) continue;
                this.sampleAnnotations.put(annotation.getId(), annotation);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    private void loadSamples() {
        CsvReader reader = null;
        try {
            reader = new CsvReader(this.sampleFile, ' ');
            Iterator it = reader.iterator();
            it.next();
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                String familyId = tuple.getString(0);
                String sampleId = tuple.getString(1);
                LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
                annotationValues.put("sampleMissingRateFloat", Float.valueOf(tuple.getString(2).equals("NA") ? Float.NaN : Float.parseFloat(tuple.getString(2))));
                for (String colName : this.sampleAnnotations.keySet()) {
                    if (colName.equals("sampleMissingRateFloat")) continue;
                    SampleAnnotation annotation = this.sampleAnnotations.get(colName);
                    Object value = null;
                    switch (annotation.getType()) {
                        case STRING: {
                            value = tuple.getString(colName);
                            break;
                        }
                        case INTEGER: {
                            value = tuple.getString(colName).equals("NA") ? null : tuple.getInt(colName);
                            break;
                        }
                        case BOOLEAN: {
                            if (tuple.getString(colName).equals("-9") || tuple.getString(colName).equals("NA")) {
                                value = null;
                                break;
                            }
                            value = tuple.getBoolean(colName);
                            break;
                        }
                        case FLOAT: {
                            value = Float.valueOf(tuple.getString(colName).equals("NA") || tuple.getString(colName).equals("-9") ? Float.NaN : Float.parseFloat(tuple.getString(colName)));
                            break;
                        }
                        default: {
                            LOGGER.warn((Object)("Unsupported data type encountered for column [" + colName + "]"));
                        }
                    }
                    annotationValues.put(colName, value);
                }
                this.samples.add(new Sample(sampleId, familyId, annotationValues));
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("File [" + this.sampleFile.getAbsolutePath() + "] does not exists", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    public Map<String, SampleAnnotation> getSampleAnnotations() {
        return this.sampleAnnotations;
    }
}

