/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeFileType;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.multipart.IncompatibleMultiPartGenotypeDataException;
import org.molgenis.genotype.multipart.MultiPartGenotypeData;
import org.molgenis.genotype.oxford.GenGenotypeData;
import org.molgenis.genotype.oxford.HapsGenotypeData;
import org.molgenis.genotype.plink.BedBimFamGenotypeData;
import org.molgenis.genotype.plink.PedMapGenotypeData;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.sampleFilter.SampleFilterableGenotypeDataDecorator;
import org.molgenis.genotype.trityper.TriTyperGenotypeData;
import org.molgenis.genotype.variantFilter.VariantFilter;
import org.molgenis.genotype.variantFilter.VariantFilterableGenotypeDataDecorator;
import org.molgenis.genotype.vcf.VcfGenotypeData;

public enum RandomAccessGenotypeDataReaderFormats {
    PED_MAP("PED / MAP files", "plink PED / MAP files", EnumSet.of(GenotypeFileType.PED, GenotypeFileType.MAP)),
    VCF("VCF file", "gziped vcf with tabix index file", EnumSet.of(GenotypeFileType.VCF)),
    VCF_FOLDER("VCF folder", "Matches all gziped vcf files + tabix index in a folder. Each file must contains only a sigle chromosome. Each chromsome must be unique to a single file.", EnumSet.of(GenotypeFileType.VCF_FOLDER)),
    SHAPEIT2("Shapeit2 output", ".haps, and .samples with phased haplotypes as outputted by Shapeit2", EnumSet.of(GenotypeFileType.HAPS, GenotypeFileType.SAMPLE)),
    PLINK_BED("Plink BED / BIM / FAM files", "Plink BED / BIM / FAM files", EnumSet.of(GenotypeFileType.BED, GenotypeFileType.BIM, GenotypeFileType.FAM)),
    TRITYPER("TriTyper folder", "Folder with files in trityper format: GenotypeMatrix.dat, Individuals.txt, PhenotypeInformation.txt, SNPMappings.txt, SNPs.txt and optionally: ImputedDosageMatrix.dat", EnumSet.of(GenotypeFileType.TRITYPER_GENOTYPE, new GenotypeFileType[]{GenotypeFileType.TRITYPER_IND, GenotypeFileType.TRITYPER_MAPPINGS, GenotypeFileType.TRITYPER_MAPPINGS, GenotypeFileType.TRITYPER_PHENO, GenotypeFileType.TRITYPER_SNPS})),
    GEN("Oxford GEN / SAMPLE files", "Oxford .gen and .sample", EnumSet.of(GenotypeFileType.GEN, GenotypeFileType.SAMPLE));

    private final String name;
    private final String description;
    private final EnumSet<GenotypeFileType> requiredFiles;

    private RandomAccessGenotypeDataReaderFormats(String name, String description, EnumSet<GenotypeFileType> requiredFiles) {
        this.name = name;
        this.description = description;
        this.requiredFiles = requiredFiles;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EnumSet<GenotypeFileType> getRequiredFiles() {
        return this.requiredFiles;
    }

    public static RandomAccessGenotypeDataReaderFormats matchFormatToPath(String ... paths) {
        if (paths.length == 0) {
            throw new GenotypeDataException("Cannot find any suitable genotype data format based on path, please make sure the files exist");
        }
        if (paths.length == 1) {
            String path = paths[0];
            File pathFile = new File(path);
            if (GenotypeFileType.getTypeForPath(path) == GenotypeFileType.VCF && pathFile.exists()) {
                return VCF;
            }
            if (new File(path + ".vcf.gz").exists()) {
                return VCF;
            }
            if (new File(path + ".ped").exists() && new File(path + ".map").exists()) {
                return PED_MAP;
            }
            if (new File(path + ".bed").exists() && new File(path + ".bim").exists() && new File(path + ".fam").exists()) {
                return PLINK_BED;
            }
            if (new File(path + ".haps").exists() && new File(path + ".sample").exists()) {
                return SHAPEIT2;
            }
            if (new File(path + ".gen").exists() && new File(path + ".sample").exists()) {
                return GEN;
            }
            if (pathFile.exists() && pathFile.isFile() && new File(path + ".sample").exists()) {
                return GEN;
            }
            if (pathFile.isDirectory()) {
                for (File file : pathFile.listFiles()) {
                    if (!file.getName().endsWith(".vcg.gz")) continue;
                    return VCF_FOLDER;
                }
                if (new File(pathFile, "GenotypeMatrix.dat").exists() && (new File(pathFile, "SNPs.txt").exists() || new File(pathFile, "SNPs.txt.gz").exists()) && (new File(pathFile, "SNPMappings.txt").exists() || new File(pathFile, "SNPMappings.txt.gz").exists()) && (new File(pathFile, "Individuals.txt").exists() || new File(pathFile, "Individuals.txt.gz").exists()) && (new File(pathFile, "PhenotypeInformation.txt").exists() || new File(pathFile, "PhenotypeInformation.txt.gz").exists())) {
                    return TRITYPER;
                }
            }
        }
        throw new GenotypeDataException("Cannot find any suitable genotype data format based on path, please make sure the files exist");
    }

    public RandomAccessGenotypeData createGenotypeData(String path) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(new String[]{path}, 1000);
    }

    public RandomAccessGenotypeData createGenotypeData(String path, int cacheSize) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(new String[]{path}, cacheSize, null);
    }

    public RandomAccessGenotypeData createGenotypeData(String path, int cacheSize, String forcedSequence) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(new String[]{path}, cacheSize, forcedSequence, (double)0.34f);
    }

    public RandomAccessGenotypeData createGenotypeData(String path, int cacheSize, String forcedSequence, double minimumPosteriorProbabilityToCall) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(new String[]{path}, cacheSize, forcedSequence, minimumPosteriorProbabilityToCall);
    }

    public RandomAccessGenotypeData createGenotypeData(String[] paths) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(paths, 1000);
    }

    public RandomAccessGenotypeData createGenotypeData(String[] paths, int cacheSize) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(paths, cacheSize, null);
    }

    public RandomAccessGenotypeData createGenotypeData(String[] paths, int cacheSize, String forcedSequence) throws IOException, IncompatibleMultiPartGenotypeDataException {
        return this.createGenotypeData(paths, cacheSize, forcedSequence, (double)0.34f);
    }

    public RandomAccessGenotypeData createGenotypeData(String[] paths, int cacheSize, String forcedSequence, double minimumPosteriorProbabilityToCall) throws IOException, IncompatibleMultiPartGenotypeDataException {
        if (paths == null || paths.length == 0) {
            throw new GenotypeDataException("Error no paths specified");
        }
        switch (this) {
            case PED_MAP: {
                if (forcedSequence != null) {
                    throw new GenotypeDataException("Cannot force sequence for " + this.getName());
                }
                return new PedMapGenotypeData(new File(paths[0] + ".ped"), new File(paths[0] + ".map"));
            }
            case VCF: {
                if (forcedSequence != null) {
                    throw new GenotypeDataException("Cannot force sequence for " + this.getName());
                }
                File vcfFile = paths[0].endsWith(".vcf.gz") ? new File(paths[0]) : new File(paths[0] + ".vcf.gz");
                return new VcfGenotypeData(vcfFile, cacheSize);
            }
            case VCF_FOLDER: {
                if (forcedSequence != null) {
                    throw new GenotypeDataException("Cannot force sequence for " + this.getName());
                }
                return MultiPartGenotypeData.createFromVcfFolder(new File(paths[0]), cacheSize);
            }
            case SHAPEIT2: {
                return new HapsGenotypeData(new File(paths[0] + ".haps"), new File(paths[0] + ".sample"), cacheSize, forcedSequence);
            }
            case PLINK_BED: {
                if (forcedSequence != null) {
                    throw new GenotypeDataException("Cannot force sequence for " + this.getName());
                }
                return new BedBimFamGenotypeData(new File(paths[0] + ".bed"), new File(paths[0] + ".bim"), new File(paths[0] + ".fam"), cacheSize);
            }
            case TRITYPER: {
                if (forcedSequence != null) {
                    throw new GenotypeDataException("Cannot force sequence for " + this.getName());
                }
                return new TriTyperGenotypeData(paths[0], cacheSize);
            }
            case GEN: {
                if (paths.length == 1) {
                    if (new File(paths[0] + ".gen").exists()) {
                        return new GenGenotypeData(new File(paths[0] + ".gen"), new File(paths[0] + ".sample"), cacheSize, forcedSequence, minimumPosteriorProbabilityToCall);
                    }
                    if (new File(paths[0]).exists() && new File(paths[0] + ".sample").exists()) {
                        return new GenGenotypeData(new File(paths[0]), new File(paths[0] + ".sample"), cacheSize, forcedSequence, minimumPosteriorProbabilityToCall);
                    }
                    throw new FileNotFoundException("Unable to load gen and sample file at: " + paths[0]);
                }
                if (paths.length == 2) {
                    File genFile = null;
                    File sampleFile = null;
                    for (String path : paths) {
                        if (GenotypeFileType.getTypeForPath(path) == GenotypeFileType.SAMPLE) {
                            sampleFile = new File(path);
                            continue;
                        }
                        genFile = new File(path);
                    }
                    if (sampleFile == null) {
                        throw new GenotypeDataException("Path to .sample file not specified for oxford gen data");
                    }
                    return new GenGenotypeData(genFile, sampleFile, cacheSize, forcedSequence, minimumPosteriorProbabilityToCall);
                }
                throw new GenotypeDataException("Expected 2 files for oxford gen data but found: " + paths.length);
            }
        }
        throw new RuntimeException("This should not be reachable. Please contact the authors");
    }

    public RandomAccessGenotypeData createFilteredGenotypeData(String path, int cacheSize, VariantFilter variantFilter, SampleFilter sampleFilter) throws IOException {
        switch (this) {
            case TRITYPER: {
                return new TriTyperGenotypeData(new File(path), cacheSize, variantFilter, sampleFilter);
            }
        }
        RandomAccessGenotypeData genotypeData = this.createGenotypeData(path, cacheSize);
        if (sampleFilter != null) {
            genotypeData = new SampleFilterableGenotypeDataDecorator(genotypeData, sampleFilter);
        }
        if (variantFilter != null) {
            genotypeData = new VariantFilterableGenotypeDataDecorator(genotypeData, variantFilter);
        }
        return genotypeData;
    }

    public RandomAccessGenotypeData createFilteredGenotypeData(String path, int cacheSize, VariantFilter variantFilter, SampleFilter sampleFilter, String forcedSequence, double minimumPosteriorProbabilityToCall) throws IOException {
        switch (this) {
            case TRITYPER: {
                return new TriTyperGenotypeData(new File(path), cacheSize, variantFilter, sampleFilter);
            }
        }
        RandomAccessGenotypeData genotypeData = this.createGenotypeData(path, cacheSize, forcedSequence, minimumPosteriorProbabilityToCall);
        if (sampleFilter != null) {
            genotypeData = new SampleFilterableGenotypeDataDecorator(genotypeData, sampleFilter);
        }
        if (variantFilter != null) {
            genotypeData = new VariantFilterableGenotypeDataDecorator(genotypeData, variantFilter);
        }
        return genotypeData;
    }
}

