/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public class RungeKuttaFehlberg
extends NumericalIntegrator {
    protected static double[] a = new double[]{0.0, 0.25, 0.375, 0.9230769230769231, 1.0, 0.5};
    protected static double[][] b = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.25, 0.09375, 0.8793809740555303, 2.0324074074074074, -0.2962962962962963}, {0.0, 0.28125, -3.277196176604461, -8.0, 2.0}, {0.0, 0.0, 3.3208921256258535, 7.173489278752436, -1.3816764132553607}, {0.0, 0.0, 0.0, -0.20589668615984405, 0.4529727095516569}, {0.0, 0.0, 0.0, 0.0, -0.275}};
    protected static double[] c = new double[]{0.11851851851851852, 0.0, 0.5189863547758284, 0.5061314903420167, -0.18, 0.03636363636363636};
    protected static double[] c4 = new double[]{0.11574074074074074, 0.0, 0.5489278752436647, 0.5353313840155945, -0.2, 0.0};
    protected static int nk = 6;

    public RungeKuttaFehlberg(double timeStep, DifferentialEquationInterface equation) {
        super(timeStep, equation);
    }

    public double[] next(double x, double[] y) {
        double[][] k = new double[nk][];
        for (int i = 0; i < nk; ++i) {
            double[] ysum = (double[])y.clone();
            for (int j = 0; j < i; ++j) {
                if (b[i][j] == 0.0) continue;
                ysum = this.add(ysum, this.multiply(b[i][j], k[j]));
            }
            k[i] = this.multiply(this.timeStep, this.equation.dy(x + a[i] * this.timeStep, ysum));
        }
        double[] sum = (double[])y.clone();
        this.error = new double[y.length];
        for (int i = 0; i < nk; ++i) {
            sum = this.add(sum, this.multiply(c[i], k[i]));
            this.error = this.add(this.error, this.multiply(c[i] - c4[i], k[i]));
        }
        return sum;
    }
}

