/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistExponential
extends DistContinuous {
    private double mean;

    public DistExponential(StreamInterface stream, double mean) {
        super(stream);
        if (!(mean > 0.0)) {
            throw new IllegalArgumentException("Error Exponential - mean<=0");
        }
        this.mean = mean;
    }

    public double draw() {
        return -this.mean * Math.log(this.stream.nextDouble());
    }

    public double probDensity(double observation) {
        if (observation >= 0.0) {
            return 1.0 / this.mean * Math.exp(-observation / this.mean);
        }
        return 0.0;
    }

    public String toString() {
        return "Exponential(" + this.mean + ")";
    }
}

