/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.language.primitives.Primitive;

public class IINC
extends VoidOperation {
    public static final int OP = 132;
    private int index = -1;
    private int constant = -1;
    private boolean widened = false;

    public IINC(DataInput dataInput) throws IOException {
        this(dataInput, false);
    }

    public IINC(DataInput dataInput, boolean widened) throws IOException {
        this.widened = widened;
        if (widened) {
            this.index = dataInput.readUnsignedShort();
            this.constant = dataInput.readShort();
        } else {
            this.index = dataInput.readUnsignedByte();
            this.constant = dataInput.readByte();
        }
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        int oldValue = Primitive.toInteger((Object)localVariables[this.index].getValue());
        localVariables[this.index].setValue(new Integer(oldValue + this.constant));
    }

    public int getByteLength() {
        int result = 3;
        if (this.widened) {
            result += 2;
        }
        return result;
    }

    public int getOpcode() {
        return 132;
    }
}

