/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

import java.util.Random;

public class InplaceArrayQuickSort {
    public static final Random RND = new Random();

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static <E extends Comparable<? super E>> int partition(E[] array, int begin, int end) {
        int index = begin + RND.nextInt(end - begin + 1);
        E pivot = array[index];
        InplaceArrayQuickSort.swap(array, index, end);
        for (int i = index = begin; i < end; ++i) {
            if (array[i].compareTo(pivot) > 0) continue;
            InplaceArrayQuickSort.swap(array, index++, i);
        }
        InplaceArrayQuickSort.swap(array, index, end);
        return index;
    }

    private static <E extends Comparable<? super E>> void qsort(E[] array, int begin, int end) {
        if (end > begin) {
            int index = InplaceArrayQuickSort.partition(array, (int)begin, (int)end);
            InplaceArrayQuickSort.qsort(array, (int)begin, (int)(index - 1));
            InplaceArrayQuickSort.qsort(array, (int)(index + 1), (int)end);
        }
    }

    public static <E extends Comparable<? super E>> void sort(E[] array) {
        InplaceArrayQuickSort.qsort(array, (int)0, (int)(array.length - 1));
    }

    public static <E extends Comparable<? super E>> void sort(E[] array, int fromIndex, int toIndex) {
        InplaceArrayQuickSort.qsort(array, (int)fromIndex, (int)(toIndex - 1));
    }
}

