/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.text.parsing;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import umcg.genetica.io.text.TextFile;

public class Demographics {
    private String annotationFile;

    public Demographics(String annotationFile) {
        this.annotationFile = annotationFile;
    }

    public static void main(String[] args) throws IOException {
        new Demographics("D:\\UMCG\\Methylation_GPL8490\\GPL8490_raw_3112012\\GPL8490_family_annotation.txt").writeGenders("D:\\UMCG\\Methylation_GPL8490\\GPL8490_raw_3112012\\GPL8490FemaleSamples.txt", "D:\\UMCG\\Methylation_GPL8490\\GPL8490_raw_3112012\\GPL8490MaleSamples.txt", 27);
    }

    private void writeGenders(String femaleFileName, String maleFileName, int gseCol) throws IOException {
        Pattern femaleP = Pattern.compile("\\bfemale\\b", 2);
        Pattern femaleP2 = Pattern.compile("\\b(gender|sex)[ ]*[:=]?[ ]*f", 2);
        Pattern maleP = Pattern.compile("\\bmale\\b", 2);
        Pattern maleP2 = Pattern.compile("\\b(gender|sex)[ ]*[:=]?[ ]*m(?!atched)", 2);
        TextFile fOut = new TextFile(femaleFileName, true);
        TextFile mOut = new TextFile(maleFileName, true);
        TextFile tf = new TextFile(this.annotationFile, false);
        String line = tf.readLine();
        block0: while ((line = tf.readLine()) != null) {
            String[] split = line.split("\t");
            for (int i = 0; i < split.length; ++i) {
                Matcher femaleM = femaleP.matcher(split[i]);
                Matcher femaleM2 = femaleP2.matcher(split[i]);
                Matcher maleM = maleP.matcher(split[i]);
                Matcher maleM2 = maleP2.matcher(split[i]);
                String gse = split[gseCol].trim().replace("\t", " ");
                if (femaleM.find(0) && !maleM.find(0)) {
                    fOut.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    continue block0;
                }
                if (maleM.find(0) && !femaleM.find(0)) {
                    mOut.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    continue block0;
                }
                if (femaleM2.find()) {
                    if (split[i].toLowerCase().contains("gender: f/m")) continue;
                    fOut.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    continue block0;
                }
                if (!maleM2.find() || split[i].toLowerCase().contains("gender: m/f")) continue;
                mOut.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                continue block0;
            }
        }
        tf.close();
        fOut.close();
        mOut.close();
    }

    private void writeAges(String fileName, int gseCol) throws IOException {
        Pattern ageP = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern rangeP = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[ ]*(to|-)[ ]*[0-9]+[ ]*(?!week))", 2);
        Pattern monthP = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*[ ]*m(?!enopaus|iller))", 2);
        Pattern weekP = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*[ ]*(week|gestational week))", 2);
        Pattern dayP = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*[ ]*days(?! of symptoms))", 2);
        TextFile out = new TextFile(fileName, true);
        TextFile rangeOut = new TextFile(fileName.replace(".txt", "") + "Ranges.txt", true);
        TextFile tf = new TextFile(this.annotationFile, false);
        String line = tf.readLine();
        block0: while ((line = tf.readLine()) != null) {
            String[] split = line.split("\t");
            for (int i = 0; i < split.length; ++i) {
                Matcher m1 = ageP.matcher(split[i]);
                String gse = split[gseCol].trim().replace("\t", " ");
                if (!m1.find()) continue;
                Matcher rangeM = rangeP.matcher(split[i]);
                Matcher monthM = monthP.matcher(split[i]);
                Matcher weekM = weekP.matcher(split[i]);
                Matcher dayM = dayP.matcher(split[i]);
                if (rangeM.find()) {
                    rangeOut.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + rangeM.group(1) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    continue block0;
                }
                if (monthM.find() || weekM.find() || dayM.find()) continue;
                out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + m1.group(1) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                continue block0;
            }
        }
        tf.close();
        out.close();
        rangeOut.close();
    }

    private void writeAgesMethylation(String fileName, int gseCol, boolean specialSelection) throws IOException {
        Pattern agePatern = Pattern.compile("\\bage[ ]*\\(*(y|yrs|years|months|[0-9]{4})*\\)*[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern monthPatern1 = Pattern.compile("\\bage[ ]+\\(*(months|m)+\\)*[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern monthPatern2 = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*)[ ]*\\(*(month|m(?!enopaus|iller))+\\)*", 2);
        Pattern rangeP = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[ ]*(to|-)[ ]*[0-9]+[ ]*(?!week))", 2);
        Pattern weekPatern = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*)[ ]*\\(*week[s]*\\)*", 2);
        Pattern dayPatern = Pattern.compile("\\bage[ ]*[:=]?[ ]*([0-9]+[\\.]?[0-9]*)[ ]*\\(*day[s]*\\)*", 2);
        Pattern ageSpecial1Patern = Pattern.compile("\\bageatdraw[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern ageSpecial2Patern = Pattern.compile("\\bageatdiagnosis[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern ageSpecial3Patern = Pattern.compile("\\bdurationt1d[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern ageSpecial4Patern = Pattern.compile(".*age at collection \\(months\\): ([0-9]+[\\.]?[0-9]*).*", 2);
        Pattern ageSpecial5Patern = Pattern.compile("\\bageatrecruitment[:=]?[ ]*([0-9]+[\\.]?[0-9]*)", 2);
        Pattern maternalAgePatern = Pattern.compile("\\bmaternal age", 2);
        TextFile out = new TextFile(fileName, true);
        TextFile rangeOut = new TextFile(fileName.replace(".txt", "Ranges.txt"), true);
        int numberMatches = 0;
        TextFile tf = new TextFile(this.annotationFile, false);
        String line = tf.readLine();
        block0: while ((line = tf.readLine()) != null) {
            String[] split = line.split("\t");
            for (int i = 0; i < split.length; ++i) {
                Matcher m1 = agePatern.matcher(split[i]);
                String gse = split[gseCol].trim().replace("\t", " ");
                if (m1.find()) {
                    Matcher monthM = monthPatern1.matcher(split[i]);
                    Matcher monthM2 = monthPatern2.matcher(split[i]);
                    Matcher maternalM = maternalAgePatern.matcher(split[i]);
                    Matcher weekM = weekPatern.matcher(split[i]);
                    Matcher dayM = dayPatern.matcher(split[i]);
                    Matcher rangeM = rangeP.matcher(split[i]);
                    if (rangeM.find(0)) {
                        rangeOut.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + rangeM.group(1) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                        continue;
                    }
                    if (dayM.find(0) || weekM.find(0) || maternalM.find(0) || !monthM.find(0) && !monthM2.find(0) && Double.parseDouble(m1.group(2)) > 125.0) continue;
                    if (!monthM.find(0) && !monthM2.find(0)) {
                        out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + m1.group(2) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                        ++numberMatches;
                        continue block0;
                    }
                    if (monthM.find(0) || monthM2.find(0)) {
                        out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + Double.parseDouble(m1.group(2)) / 12.0 + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                        ++numberMatches;
                        continue block0;
                    }
                }
                if (!specialSelection) continue;
                Matcher special = ageSpecial1Patern.matcher(split[i]);
                Matcher special0 = ageSpecial4Patern.matcher(split[i]);
                Matcher special1 = ageSpecial2Patern.matcher(split[i]);
                Matcher special2 = ageSpecial3Patern.matcher(split[i]);
                Matcher special3 = ageSpecial5Patern.matcher(split[i]);
                if (special.find(0)) {
                    out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + special.group(1) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    ++numberMatches;
                    continue block0;
                }
                if (special3.find(0)) {
                    out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + special3.group(1) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    ++numberMatches;
                    continue block0;
                }
                if (special0.find(0)) {
                    out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + Double.parseDouble(special0.group(1)) / 12.0 + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                    ++numberMatches;
                    continue block0;
                }
                if (!special1.find(0) || !special2.find(0)) continue;
                out.writeln(split[12] + "\t" + gse + "\t" + split[0] + "\t" + (Double.parseDouble(special1.group(1)) + Double.parseDouble(special2.group(1))) + "\t" + split[3] + "\t" + split[13] + "\t" + split[i]);
                ++numberMatches;
                continue block0;
            }
        }
        System.out.println(numberMatches);
        tf.close();
        out.close();
        rangeOut.close();
    }

    private void writeMatchingSamples(String matchThisWord, String fileName) throws IOException {
        Pattern p1 = Pattern.compile("\\b" + matchThisWord + "\\b", 2);
        TextFile out = new TextFile(fileName, true);
        TextFile tf = new TextFile(this.annotationFile, false);
        String line = tf.readLine();
        while ((line = tf.readLine()) != null) {
            String[] split = line.split("\t");
            for (int i = 0; i < split.length; ++i) {
                Matcher m1 = p1.matcher(split[i]);
                if (!m1.find()) continue;
                out.writeln(split[0] + "\t" + split[i]);
            }
        }
        tf.close();
        out.close();
    }

    private void writeMatchingSamples(String matchThisWord, String dontMatchThisWord, int[] colsToSearch, String fileName) throws IOException {
        Pattern p1 = Pattern.compile("\\b" + matchThisWord + "\\b", 2);
        Pattern p2 = Pattern.compile("\\b" + dontMatchThisWord + "\\b", 2);
        TextFile out = new TextFile(fileName, true);
        TextFile tf = new TextFile(this.annotationFile, false);
        String line = tf.readLine();
        while ((line = tf.readLine()) != null) {
            String[] split = line.split("\t");
            boolean matches = false;
            for (int col : colsToSearch) {
                if (split.length <= col) continue;
                Matcher m1 = p1.matcher(split[col]);
                Matcher m2 = p2.matcher(split[col]);
                if (!m1.find() || m2.find()) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            out.writeln(split[0]);
        }
        tf.close();
        out.close();
    }

    private void checkColumns(String query) throws IOException {
        TextFile tf = new TextFile(this.annotationFile, false);
        String line = tf.readLine();
        int[] counts = new int[line.split("\t").length];
        while ((line = tf.readLine()) != null) {
            String[] split = line.split("\t");
            for (int col = 0; col < split.length; ++col) {
                if (col >= counts.length || !split[col].contains(query)) continue;
                int n = col;
                counts[n] = counts[n] + 1;
            }
        }
        for (int col = 0; col < counts.length; ++col) {
            if (counts[col] <= 0) continue;
            System.out.println(col + "\t" + counts[col]);
        }
    }

    private void combineAgesAndRanges(String agefile, String rangefile, String outfile) throws IOException {
        TextFile in = new TextFile(agefile, false);
        TextFile out = new TextFile(outfile, true);
        String line = null;
        while ((line = in.readLine()) != null) {
            out.writeln(line);
        }
        in.close();
        in = new TextFile(rangefile, false);
        while ((line = in.readLine()) != null) {
            int i;
            int age2;
            String[] split = line.split("\t");
            String range = split[3].trim();
            int indexOf = range.indexOf("-");
            double age = -1.0;
            if (indexOf > 0) {
                int age1 = Integer.parseInt(range.substring(0, indexOf));
                age2 = Integer.parseInt(range.substring(indexOf + 1));
                if (age2 - age1 < 19) {
                    age = (double)(age2 + age1) / 2.0;
                }
            } else {
                indexOf = range.indexOf(" to ");
                if (indexOf > 0) {
                    int age1 = Integer.parseInt(range.substring(0, indexOf));
                    age2 = Integer.parseInt(range.substring(indexOf + 4));
                    if (age2 - age1 < 19) {
                        age = (double)(age2 + age1) / 2.0;
                    }
                }
            }
            if (!(age > 0.0)) continue;
            String delim = "";
            for (i = 0; i < 3; ++i) {
                out.write(delim + split[i]);
                delim = "\t";
            }
            out.write(delim + age);
            for (i = 4; i < split.length; ++i) {
                out.write(delim + split[i]);
            }
            out.writeln();
        }
        in.close();
        out.close();
    }
}

