/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import JSci.maths.statistics.NormalDistribution;
import JSci.maths.statistics.TDistribution;
import cern.jet.random.tdouble.StudentT;
import cern.jet.stat.Probability;
import umcg.genetica.math.stats.Correlation;

public class ZScores {
    private static NormalDistribution normDist;
    private static TDistribution tDist;
    private static final double FINDROOT_ACCURACY = 1.0E-15;
    private static final int FINDROOT_MAX_ITERATIONS = 15000;

    public static double getWeightedZ(double[] zScores, int[] sampleSizes) {
        if (zScores.length != sampleSizes.length) {
            throw new IllegalArgumentException("Zscores and sample sizes should have same length!");
        }
        double weightedZ = 0.0;
        double sampleSizeSum = 0.0;
        for (int j = 0; j < zScores.length; ++j) {
            if (Double.isNaN(zScores[j])) continue;
            weightedZ += Math.sqrt(sampleSizes[j]) * zScores[j];
            sampleSizeSum += (double)sampleSizes[j];
        }
        return weightedZ /= Math.sqrt(sampleSizeSum);
    }

    public static double getWeightedZ(double[] zScores, int[] sampleSizes, double[] weights) {
        if (zScores.length != sampleSizes.length) {
            throw new IllegalArgumentException("Zscores and sample sizes should have same length!");
        }
        double weightedZ = 0.0;
        double sampleSizeSum = 0.0;
        for (int j = 0; j < zScores.length; ++j) {
            if (Double.isNaN(zScores[j])) continue;
            weightedZ += Math.sqrt(sampleSizes[j]) * weights[j] * zScores[j];
            sampleSizeSum += (double)sampleSizes[j] * weights[j];
        }
        return weightedZ /= Math.sqrt(sampleSizeSum);
    }

    public static double zToP(double z) {
        double p;
        if (normDist == null) {
            normDist = new NormalDistribution();
        }
        if ((p = z > 0.0 ? normDist.cumulative(-z) : normDist.cumulative(z)) > 0.5) {
            p = 1.0 - p;
        }
        return p *= 2.0;
    }

    public static double pToZ(double p) {
        if (p == 1.0) {
            return 0.0;
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalStateException("P-value should be between 0 and 1.");
        }
        if (p == 0.0) {
            return 40.0;
        }
        return Probability.normalInverse((double)p);
    }

    public static double correlationToZ(double correlation, int nrSamples, StudentT tDist) {
        double t = correlation / Math.sqrt((1.0 - correlation * correlation) / (double)(nrSamples - 2));
        double pValue = 0.0;
        double zScore = 0.0;
        if (t < 0.0) {
            pValue = tDist.cdf(t);
            if (pValue < 2.0E-323) {
                pValue = 2.0E-323;
            }
            zScore = Probability.normalInverse((double)pValue);
        } else {
            pValue = tDist.cdf(-t);
            if (pValue < 2.0E-323) {
                pValue = 2.0E-323;
            }
            zScore = -Probability.normalInverse((double)pValue);
        }
        return zScore;
    }

    public static double correlationToP(double correlation, int nrSamples, StudentT tDist) {
        double t = correlation / Math.sqrt((1.0 - correlation * correlation) / (double)(nrSamples - 2));
        double pValue = 0.0;
        if (t < 0.0) {
            pValue = tDist.cdf(t);
            if (pValue < 2.0E-323) {
                pValue = 2.0E-323;
            }
        } else {
            pValue = tDist.cdf(-t);
            if (pValue < 2.0E-323) {
                pValue = 2.0E-323;
            }
        }
        return pValue;
    }

    public static double zScoreToCorrelation(double obsZ, int nrSamples) {
        double obsPValue;
        if (tDist == null || tDist.getDegreesOfFreedom() != nrSamples - 2) {
            tDist = new TDistribution(nrSamples - 2);
        }
        if ((obsPValue = ZScores.zToP(obsZ)) == 0.0) {
            obsPValue = Double.MIN_VALUE;
        } else {
            if (obsPValue == 0.5) {
                return 0.0;
            }
            obsPValue /= 2.0;
        }
        double obsT = ZScores.inverseT(obsPValue);
        if (obsZ < 0.0) {
            obsT *= -1.0;
        }
        double corr = Math.sqrt(obsT * obsT / (obsT * obsT + (double)nrSamples));
        if (obsT > 0.0) {
            corr = -corr;
        }
        if (Double.isNaN(corr)) {
            return 0.0;
        }
        return corr;
    }

    public static double extrapolateZScore(int originalSampleSize, int newSampleSize, double originalZ) {
        double correlation = ZScores.zScoreToCorrelation(originalZ, originalSampleSize);
        Correlation.correlationToZScore(newSampleSize);
        double newZ = Correlation.convertCorrelationToZScore(newSampleSize, correlation);
        return newZ;
    }

    private static double inverseT(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("Error: probability out of normal range (should be 0 >= x <= 1): " + probability);
        }
        if (probability == 0.0) {
            return -1.7976931348623157E308;
        }
        if (probability == 1.0) {
            return Double.MAX_VALUE;
        }
        if (probability == 0.5) {
            return 0.0;
        }
        return ZScores.findRoot(probability, 0.0, -8.988465674311579E307, 8.988465674311579E307);
    }

    private static double findRoot(double prob, double guess, double xLo, double xHi) {
        double x = guess;
        double xNew = guess;
        double dx = 1.0;
        int i = 0;
        while (Math.abs(dx) > 1.0E-15 && i++ < 15000) {
            double error = tDist.cumulative(x) - prob;
            if (error < 0.0) {
                xLo = x;
            } else {
                xHi = x;
            }
            double pdf = tDist.probability(x);
            if (pdf != 0.0) {
                dx = error / pdf;
                xNew = x - dx;
            }
            if (xNew < xLo || xNew > xHi || pdf == 0.0) {
                xNew = (xLo + xHi) / 2.0;
                dx = xNew - x;
            }
            x = xNew;
        }
        return x;
    }

    public static double betaToZ(double b, double se, double n) {
        return b / (se * Math.sqrt(n));
    }

    static {
        tDist = null;
    }
}

