/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.math.matrix.DoubleMatrixDatasetAC;

@Deprecated
public class DoubleMatrixDatasetRA<T, U>
extends DoubleMatrixDatasetAC {
    private static final Logger LOGGER = Logger.getLogger(DoubleMatrixDatasetRA.class.getName());
    public int nrColsTotal = 0;
    public Set<T> rowsToInclude = null;
    public Set<U> colsToInclude = null;
    public String fileName = null;
    private RandomAccessFile raf;
    private int[] rowIndexToRawRowIndex;
    private int[] colIndexToRawColIndex;

    public DoubleMatrixDatasetRA(String fileName) throws IOException {
        this(fileName, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH);
    }

    public DoubleMatrixDatasetRA(String fileName, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException {
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        if (fileName.endsWith(".binary")) {
            try {
                this.loadExpressionDataInBinaryFormat(fileName, ll);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        } else {
            throw new IOException("Only .binary format supported for random access! Given file: " + fileName);
        }
    }

    public DoubleMatrixDatasetRA(String fileName, Set<T> rowsToInclude) throws IOException {
        this(fileName, rowsToInclude, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH);
    }

    public DoubleMatrixDatasetRA(String fileName, Set<T> rowsToInclude, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException {
        this.rowsToInclude = rowsToInclude;
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        if (fileName.endsWith(".binary")) {
            try {
                this.loadExpressionDataInBinaryFormat(fileName, ll);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        } else {
            throw new IOException("Only .binary format supported for random access! Given file: " + fileName);
        }
    }

    public DoubleMatrixDatasetRA(String fileName, Set<T> rowsToInclude, Set<U> colsToInclude) throws IOException {
        this(fileName, rowsToInclude, colsToInclude, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH);
    }

    public DoubleMatrixDatasetRA(String fileName, Set<T> rowsToInclude, Set<U> colsToInclude, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException {
        this.rowsToInclude = rowsToInclude;
        this.colsToInclude = colsToInclude;
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        if (fileName.endsWith(".binary")) {
            try {
                this.loadExpressionDataInBinaryFormat(fileName, ll);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        } else {
            throw new IOException("Only .binary format supported for random access! Given file: " + fileName);
        }
    }

    private void loadExpressionDataInBinaryFormat(String fileName, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException, ClassNotFoundException {
        this.fileName = fileName;
        File fileBinary = new File(fileName + ".dat");
        int nrRowsThisBinaryFile = -1;
        int nrColsThisBinaryFile = -1;
        this.raf = new RandomAccessFile(fileBinary, "r");
        this.raf.seek(0L);
        byte[] bytes = new byte[4];
        this.raf.read(bytes, 0, 4);
        nrRowsThisBinaryFile = this.byteArrayToInt(bytes);
        this.raf.read(bytes, 0, 4);
        nrColsThisBinaryFile = this.byteArrayToInt(bytes);
        if (this.rowsToInclude == null && this.colsToInclude == null) {
            this.nrRows = nrRowsThisBinaryFile;
            this.nrCols = nrColsThisBinaryFile;
            switch (ll) {
                case LOAD_BOTH: {
                    this.loadRowObjects(fileName, this.nrRows);
                    this.loadColumnObjects(fileName, this.nrCols);
                    break;
                }
                case LOAD_ROWS: {
                    this.loadRowObjects(fileName, this.nrRows);
                    break;
                }
                case LOAD_COLUMNS: {
                    this.loadColumnObjects(fileName, this.nrCols);
                }
            }
            this.nrColsTotal = this.nrCols;
        } else {
            this.loadRowObjects(fileName, nrRowsThisBinaryFile);
            this.loadColumnObjects(fileName, nrColsThisBinaryFile);
            this.nrColsTotal = nrColsThisBinaryFile;
        }
        this.recalculateHashMaps();
        LOGGER.log(Level.INFO, "Access to binary file:\t{0}\tok, nrRows:\t{1}\tnrCols:\t{2}", new Object[]{fileName, this.nrRows, this.nrCols});
    }

    public static List<Object> getRowObjectsOnly(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        File fileRows = new File(fileName + ".rows.ser");
        ArrayList<Object> objects = new ArrayList<Object>();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileRows));
        ObjectInputStream ois = new ObjectInputStream(bis);
        while (bis.available() > 0) {
            objects.add(ois.readObject());
        }
        bis.close();
        ois.close();
        return objects;
    }

    public static List<Object> getColumnObjectsOnly(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        File fileCols = new File(fileName + ".columns.ser");
        ArrayList<Object> objects = new ArrayList<Object>();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileCols));
        ObjectInputStream ois = new ObjectInputStream(bis);
        while (bis.available() > 0) {
            objects.add(ois.readObject());
        }
        bis.close();
        ois.close();
        return objects;
    }

    private void loadRowObjects(String fileName, int nrRowsThisBinaryFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        int[] rowSubsetIndex = new int[nrRowsThisBinaryFile];
        for (int r = 0; r < rowSubsetIndex.length; ++r) {
            rowSubsetIndex[r] = -1;
        }
        File fileRows = new File(fileName + ".rows.ser");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileRows));
        ObjectInputStream ois = new ObjectInputStream(bis);
        int rowIndex = 0;
        this.rowObjects = new ArrayList();
        HashMap<Object, Integer> hashRowsPresentAndRequested = new HashMap<Object, Integer>();
        while (bis.available() > 0) {
            Object rowObject = ois.readObject();
            if (this.rowsToInclude == null || this.rowsToInclude.contains(rowObject)) {
                rowSubsetIndex[rowIndex] = hashRowsPresentAndRequested.size();
                hashRowsPresentAndRequested.put(rowObject, rowIndex);
                this.rowObjects.add(rowObject);
            }
            ++rowIndex;
        }
        bis.close();
        ois.close();
        this.nrRows = hashRowsPresentAndRequested.size();
        this.rowIndexToRawRowIndex = new int[this.nrRows];
        bis = new BufferedInputStream(new FileInputStream(fileRows));
        ois = new ObjectInputStream(bis);
        int rowCounter = 0;
        rowIndex = 0;
        while (bis.available() > 0) {
            Object rowObject = ois.readObject();
            if (this.rowsToInclude == null || this.rowsToInclude.contains(rowObject)) {
                this.rowIndexToRawRowIndex[rowCounter] = rowIndex;
                ++rowCounter;
            }
            ++rowIndex;
        }
        bis.close();
        ois.close();
    }

    private void loadColumnObjects(String fileName, int nrColsThisBinaryFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        int[] colSubsetIndex = new int[nrColsThisBinaryFile];
        for (int c = 0; c < colSubsetIndex.length; ++c) {
            colSubsetIndex[c] = -1;
        }
        File fileCols = new File(fileName + ".columns.ser");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileCols));
        ObjectInputStream ois = new ObjectInputStream(bis);
        int colIndex = 0;
        this.colObjects = new ArrayList();
        HashMap<Object, Integer> hashColsPresentAndRequested = new HashMap<Object, Integer>();
        while (bis.available() > 0) {
            Object colObject = ois.readObject();
            if (this.colsToInclude == null || this.colsToInclude.contains(colObject)) {
                colSubsetIndex[colIndex] = hashColsPresentAndRequested.size();
                hashColsPresentAndRequested.put(colObject, colIndex);
                this.colObjects.add(colObject);
            }
            ++colIndex;
        }
        bis.close();
        ois.close();
        this.nrCols = hashColsPresentAndRequested.size();
        this.colIndexToRawColIndex = new int[this.nrCols];
        bis = new BufferedInputStream(new FileInputStream(fileCols));
        ois = new ObjectInputStream(bis);
        int colCounter = 0;
        colIndex = 0;
        while (bis.available() > 0) {
            Object colObject = ois.readObject();
            if (this.colsToInclude == null || this.colsToInclude.contains(colObject)) {
                this.colIndexToRawColIndex[colCounter] = colIndex;
                ++colCounter;
            }
            ++colIndex;
        }
        bis.close();
        ois.close();
    }

    public double[] getNextRow() {
        if (this.nrCols != this.nrColsTotal) {
            throw new IllegalStateException("Not applicable to datasets with not all columns included. (Columns in file: " + this.nrColsTotal + ", columns included: " + this.nrCols + ")");
        }
        double[] values = new double[this.nrCols];
        int col = 0;
        try {
            for (col = 0; col < this.nrColsTotal; ++col) {
                values[col] = this.raf.readDouble();
            }
        }
        catch (IOException e) {
            System.err.println("Can't get element at column " + col + ": " + e.getMessage());
        }
        return values;
    }

    @Override
    public synchronized double[] get(int x) {
        if (this.nrCols != this.nrColsTotal) {
            throw new IllegalStateException("Not applicable to datasets with not all columns included. (Columns in file: " + this.nrColsTotal + ", columns included: " + this.nrCols + ")");
        }
        int rawRowIndex = x;
        if (this.rowIndexToRawRowIndex != null) {
            rawRowIndex = this.rowIndexToRawRowIndex[x];
        }
        double[] values = new double[this.nrCols];
        int col = 0;
        try {
            this.raf.seek(8L + (long)rawRowIndex * (long)this.nrColsTotal * 8L);
            for (col = 0; col < this.nrColsTotal; ++col) {
                values[col] = this.raf.readDouble();
            }
        }
        catch (IOException e) {
            System.err.println("Can't get element (" + rawRowIndex + ", " + col + "): " + e.getMessage());
        }
        return values;
    }

    @Override
    public synchronized double get(int x, int y) {
        int rawRowIndex = x;
        if (this.rowIndexToRawRowIndex != null) {
            rawRowIndex = this.rowIndexToRawRowIndex[x];
        }
        int rawColIndex = y;
        if (this.colIndexToRawColIndex != null) {
            rawColIndex = this.colIndexToRawColIndex[y];
        }
        double value = Double.NaN;
        try {
            this.raf.seek(8L + ((long)rawRowIndex * (long)this.nrColsTotal + (long)rawColIndex) * 8L);
            value = this.raf.readDouble();
        }
        catch (IOException e) {
            System.err.println("Can't get element (" + rawRowIndex + ", " + rawColIndex + "): " + e.getMessage());
        }
        return value;
    }

    @Override
    public void recalculateHashMaps() {
        if (this.rowObjects != null) {
            this.hashRows.clear();
            for (int probeItr = 0; probeItr < this.nrRows; ++probeItr) {
                this.hashRows.put(this.rowObjects.get(probeItr), probeItr);
            }
        }
        if (this.colObjects != null) {
            this.hashCols.clear();
            for (int sampleItr = 0; sampleItr < this.nrCols; ++sampleItr) {
                this.hashCols.put(this.colObjects.get(sampleItr), sampleItr);
            }
        }
    }

    private byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }
}

