/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.interpolation;

import umcg.genetica.math.Fmath;
import umcg.genetica.util.Primitives;

public class CubicSpline {
    private int nPoints = 0;
    private int nPointsOriginal = 0;
    private double[] y = null;
    private double[] x = null;
    private double yy = Double.NaN;
    private double dydx = Double.NaN;
    private int[] newAndOldIndices;
    private double xMin = Double.NaN;
    private double xMax = Double.NaN;
    private double range = Double.NaN;
    private double[] d2ydx2 = null;
    private double yp1 = Double.NaN;
    private double ypn = Double.NaN;
    private boolean derivCalculated = false;
    private boolean checkPoints = false;
    private static boolean supress = false;
    private static boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public CubicSpline(double[] x, double[] y) {
        this.nPointsOriginal = this.nPoints = x.length;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x and y are of different length " + this.nPoints + " " + y.length);
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        this.d2ydx2 = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.orderPoints();
        this.checkForIdenticalPoints();
        this.calcDeriv();
    }

    public CubicSpline(int nPoints) {
        this.nPointsOriginal = this.nPoints = nPoints;
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        this.x = new double[nPoints];
        this.y = new double[nPoints];
        this.d2ydx2 = new double[nPoints];
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        CubicSpline.potentialRoundingError = potentialRoundingError;
    }

    public void resetData(double[] x, double[] y) {
        this.nPoints = this.nPointsOriginal;
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays x and y are of different length");
        }
        if (this.nPoints != x.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.orderPoints();
        this.checkForIdenticalPoints();
    }

    public static void averageIdenticalAbscissae() {
        averageIdenticalAbscissae = true;
    }

    public void orderPoints() {
        double[] dummy = new double[this.nPoints];
        this.newAndOldIndices = new int[this.nPoints];
        Fmath.selectionSort(this.x, dummy, this.newAndOldIndices);
        Fmath.selectionSort(this.x, this.y, this.x, this.y);
        this.xMin = Primitives.min(this.x);
        this.xMax = Primitives.max(this.x);
        this.range = this.xMax - this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin, this.xMax};
        return limits;
    }

    public void displayLimits() {
        System.out.println("\nThe limits of the abscissae (x-values) are " + this.xMin + " and " + this.xMax + "\n");
    }

    public void checkForIdenticalPoints() {
        int nP = this.nPoints;
        boolean test1 = true;
        int ii = 0;
        while (test1) {
            boolean test2 = true;
            int jj = ii + 1;
            while (test2) {
                if (this.x[ii] == this.x[jj]) {
                    int i;
                    double[] yy;
                    if (this.y[ii] == this.y[jj]) {
                        if (!supress) {
                            System.out.print("CubicSpline: Two identical points, " + this.x[ii] + ", " + this.y[ii]);
                            System.out.println(", in data array at indices " + this.newAndOldIndices[ii] + " and " + this.newAndOldIndices[jj] + ", latter point removed");
                        }
                        double[] xx = new double[this.nPoints - 1];
                        yy = new double[this.nPoints - 1];
                        int[] naoi = new int[this.nPoints - 1];
                        for (i = 0; i < jj; ++i) {
                            xx[i] = this.x[i];
                            yy[i] = this.y[i];
                            naoi[i] = this.newAndOldIndices[i];
                        }
                        for (i = jj; i < this.nPoints - 1; ++i) {
                            xx[i] = this.x[i + 1];
                            yy[i] = this.y[i + 1];
                            naoi[i] = this.newAndOldIndices[i + 1];
                        }
                        --this.nPoints;
                        System.arraycopy(xx, 0, this.x, 0, xx.length);
                        System.arraycopy(yy, 0, this.y, 0, yy.length);
                        System.arraycopy(naoi, 0, this.newAndOldIndices, 0, naoi.length);
                    } else if (averageIdenticalAbscissae) {
                        if (!supress) {
                            System.out.print("CubicSpline: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[ii] + ": " + this.y[ii] + ", " + this.y[jj]);
                            System.out.println(", average of the ordinates taken");
                        }
                        this.y[ii] = (this.y[ii] + this.y[jj]) / 2.0;
                        double[] xx = new double[this.nPoints - 1];
                        yy = new double[this.nPoints - 1];
                        int[] naoi = new int[this.nPoints - 1];
                        for (i = 0; i < jj; ++i) {
                            xx[i] = this.x[i];
                            yy[i] = this.y[i];
                            naoi[i] = this.newAndOldIndices[i];
                        }
                        for (i = jj; i < this.nPoints - 1; ++i) {
                            xx[i] = this.x[i + 1];
                            yy[i] = this.y[i + 1];
                            naoi[i] = this.newAndOldIndices[i + 1];
                        }
                        --this.nPoints;
                        System.arraycopy(xx, 0, this.x, 0, xx.length);
                        System.arraycopy(yy, 0, this.y, 0, yy.length);
                        System.arraycopy(naoi, 0, this.newAndOldIndices, 0, naoi.length);
                    } else {
                        double sepn = this.range * 5.0E-4;
                        if (!supress) {
                            System.out.print("CubicSpline: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[ii] + ": " + this.y[ii] + ", " + this.y[jj]);
                        }
                        boolean check = false;
                        if (ii == 0) {
                            if (this.x[2] - this.x[1] <= sepn) {
                                sepn = (this.x[2] - this.x[1]) / 2.0;
                            }
                            check = this.y[0] > this.y[1] ? (this.y[1] > this.y[2] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn)) : (this.y[2] <= this.y[1] ? this.swap(ii, jj, sepn) : this.stay(ii, jj, sepn));
                        }
                        if (jj == this.nPoints - 1) {
                            if (this.x[nP - 2] - this.x[nP - 3] <= sepn) {
                                sepn = (this.x[nP - 2] - this.x[nP - 3]) / 2.0;
                            }
                            check = this.y[ii] <= this.y[jj] ? (this.y[ii - 1] <= this.y[ii] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn)) : (this.y[ii - 1] <= this.y[ii] ? this.swap(ii, jj, sepn) : this.stay(ii, jj, sepn));
                        }
                        if (ii != 0 && jj != this.nPoints - 1) {
                            if (this.x[ii] - this.x[ii - 1] <= sepn) {
                                sepn = (this.x[ii] - this.x[ii - 1]) / 2.0;
                            }
                            if (this.x[jj + 1] - this.x[jj] <= sepn) {
                                sepn = (this.x[jj + 1] - this.x[jj]) / 2.0;
                            }
                            if (this.y[ii] > this.y[ii - 1]) {
                                if (this.y[jj] > this.y[ii]) {
                                    check = this.y[jj] > this.y[jj + 1] ? (this.y[ii - 1] <= this.y[jj + 1] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn)) : this.stay(ii, jj, sepn);
                                } else if (this.y[jj + 1] > this.y[jj]) {
                                    if (this.y[jj + 1] > this.y[ii - 1]) {
                                        check = this.stay(ii, jj, sepn);
                                    }
                                } else {
                                    check = this.swap(ii, jj, sepn);
                                }
                            } else if (this.y[jj] > this.y[ii]) {
                                if (this.y[jj + 1] > this.y[jj]) {
                                    check = this.stay(ii, jj, sepn);
                                }
                            } else {
                                check = this.y[jj + 1] > this.y[ii - 1] ? this.stay(ii, jj, sepn) : this.swap(ii, jj, sepn);
                            }
                        }
                        if (!check) {
                            check = this.stay(ii, jj, sepn);
                        }
                        if (!supress) {
                            System.out.println(", the two abscissae have been separated by a distance " + sepn);
                        }
                        ++jj;
                    }
                    if (this.nPoints - 1 == ii) {
                        test2 = false;
                    }
                } else {
                    ++jj;
                }
                if (jj < this.nPoints) continue;
                test2 = false;
            }
            if (++ii < this.nPoints - 1) continue;
            test1 = false;
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("Removal of duplicate points has reduced the number of points to less than the required minimum of three data points");
        }
        this.checkPoints = true;
    }

    private boolean swap(int ii, int jj, double sepn) {
        int n = ii;
        this.x[n] = this.x[n] + sepn;
        int n2 = jj;
        this.x[n2] = this.x[n2] - sepn;
        double hold = this.x[ii];
        this.x[ii] = this.x[jj];
        this.x[jj] = hold;
        hold = this.y[ii];
        this.y[ii] = this.y[jj];
        this.y[jj] = hold;
        return true;
    }

    private boolean stay(int ii, int jj, double sepn) {
        int n = ii;
        this.x[n] = this.x[n] - sepn;
        int n2 = jj;
        this.x[n2] = this.x[n2] + sepn;
        return true;
    }

    public static void supress() {
        supress = true;
    }

    public static void unsupress() {
        supress = false;
    }

    public static CubicSpline zero(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        CubicSpline aa = new CubicSpline(n);
        return aa;
    }

    public static CubicSpline[] oneDarray(int n, int m) {
        if (m < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        CubicSpline[] a = new CubicSpline[n];
        for (int i = 0; i < n; ++i) {
            a[i] = CubicSpline.zero(m);
        }
        return a;
    }

    public void setDerivLimits(double yp1, double ypn) {
        this.yp1 = yp1;
        this.ypn = ypn;
        this.calcDeriv();
    }

    public void setDerivLimits() {
        this.yp1 = Double.NaN;
        this.ypn = Double.NaN;
        this.calcDeriv();
    }

    public void setDeriv(double yp1, double ypn) {
        this.yp1 = yp1;
        this.ypn = ypn;
        this.calcDeriv();
    }

    public double[] getDeriv() {
        if (!this.derivCalculated) {
            this.calcDeriv();
        }
        return this.d2ydx2;
    }

    public void setDeriv(double[] deriv) {
        this.d2ydx2 = deriv;
        this.derivCalculated = true;
    }

    public void calcDeriv() {
        double p = 0.0;
        double qn = 0.0;
        double sig = 0.0;
        double un = 0.0;
        double[] u = new double[this.nPoints];
        if (Double.isNaN(this.yp1)) {
            u[0] = 0.0;
            this.d2ydx2[0] = 0.0;
        } else {
            this.d2ydx2[0] = -0.5;
            u[0] = 3.0 / (this.x[1] - this.x[0]) * ((this.y[1] - this.y[0]) / (this.x[1] - this.x[0]) - this.yp1);
        }
        for (int i = 1; i <= this.nPoints - 2; ++i) {
            sig = (this.x[i] - this.x[i - 1]) / (this.x[i + 1] - this.x[i - 1]);
            p = sig * this.d2ydx2[i - 1] + 2.0;
            this.d2ydx2[i] = (sig - 1.0) / p;
            u[i] = (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]) - (this.y[i] - this.y[i - 1]) / (this.x[i] - this.x[i - 1]);
            u[i] = (6.0 * u[i] / (this.x[i + 1] - this.x[i - 1]) - sig * u[i - 1]) / p;
        }
        if (Double.isNaN(this.ypn)) {
            un = 0.0;
            qn = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 / (this.x[this.nPoints - 1] - this.x[this.nPoints - 2]) * (this.ypn - (this.y[this.nPoints - 1] - this.y[this.nPoints - 2]) / (this.x[this.nPoints - 1] - this.x[this.nPoints - 2]));
        }
        this.d2ydx2[this.nPoints - 1] = (un - qn * u[this.nPoints - 2]) / (qn * this.d2ydx2[this.nPoints - 2] + 1.0);
        for (int k = this.nPoints - 2; k >= 0; --k) {
            this.d2ydx2[k] = this.d2ydx2[k] * this.d2ydx2[k + 1] + u[k];
        }
        this.derivCalculated = true;
    }

    public double interpolate(double xx) {
        if (xx < this.x[0]) {
            if (roundingCheck && Math.abs(this.x[0] - xx) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[0])))) * potentialRoundingError) {
                xx = this.x[0];
            } else {
                throw new IllegalArgumentException("x (" + xx + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        if (xx > this.x[this.nPoints - 1]) {
            if (roundingCheck && Math.abs(xx - this.x[this.nPoints - 1]) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[this.nPoints - 1])))) * potentialRoundingError) {
                xx = this.x[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException("x (" + xx + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        double h = 0.0;
        double b = 0.0;
        double a = 0.0;
        double yy = 0.0;
        int k = 0;
        int klo = 0;
        int khi = this.nPoints - 1;
        while (khi - klo > 1) {
            k = khi + klo >> 1;
            if (this.x[k] > xx) {
                khi = k;
                continue;
            }
            klo = k;
        }
        h = this.x[khi] - this.x[klo];
        if (h == 0.0) {
            throw new IllegalArgumentException("Two values of x are identical: point " + klo + " (" + this.x[klo] + ") and point " + khi + " (" + this.x[khi] + ")");
        }
        a = (this.x[khi] - xx) / h;
        b = (xx - this.x[klo]) / h;
        this.yy = a * this.y[klo] + b * this.y[khi] + ((a * a * a - a) * this.d2ydx2[klo] + (b * b * b - b) * this.d2ydx2[khi]) * (h * h) / 6.0;
        this.dydx = (this.y[khi] - this.y[klo]) / h - ((3.0 * a * a - 1.0) * this.d2ydx2[klo] - (3.0 * b * b - 1.0) * this.d2ydx2[khi]) * h / 6.0;
        return this.yy;
    }

    public double[] interpolate_for_y_and_dydx(double xx) {
        this.interpolate(xx);
        double[] ret = new double[]{this.yy, this.dydx};
        return ret;
    }

    public static double interpolate(double xx, double[] x, double[] y, double[] deriv) {
        if (x.length != y.length || x.length != deriv.length || y.length != deriv.length) {
            throw new IllegalArgumentException("array lengths are not all equal");
        }
        int n = x.length;
        double h = 0.0;
        double b = 0.0;
        double a = 0.0;
        double yy = 0.0;
        int k = 0;
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            k = khi + klo >> 1;
            if (x[k] > xx) {
                khi = k;
                continue;
            }
            klo = k;
        }
        h = x[khi] - x[klo];
        if (h == 0.0) {
            throw new IllegalArgumentException("Two values of x are identical");
        }
        a = (x[khi] - xx) / h;
        b = (xx - x[klo]) / h;
        yy = a * y[klo] + b * y[khi] + ((a * a * a - a) * deriv[klo] + (b * b * b - b) * deriv[khi]) * (h * h) / 6.0;
        return yy;
    }
}

