/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.ucsc;

import java.io.IOException;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.io.ucsc.UCSCDataObject;
import umcg.genetica.text.Strings;

public class WigFile
extends TextFile {
    private STEPMODE stepmode = STEPMODE.VARIABLESTEP;
    private byte currentChr = (byte)-1;
    private int currentStart = 0;
    private int currentStep = 1;
    private int currentSpan = 1;
    private long nrLnsReadAfterHeader = 0L;

    public long size() {
        return this.file.length();
    }

    public WigFile(String name, boolean mode) throws IOException {
        super(name, mode);
    }

    public UCSCDataObject parseLn() throws IOException {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        boolean isHeaderLine = false;
        if (line.toLowerCase().contains("variablestep") || line.toLowerCase().contains("fixedstep")) {
            isHeaderLine = true;
        }
        String[] elems = Strings.whitespace.split(line);
        if (isHeaderLine && elems.length > 1) {
            for (int i = 0; i < elems.length; ++i) {
                if (elems[i].toLowerCase().contains("variablestep")) {
                    this.stepmode = STEPMODE.VARIABLESTEP;
                    continue;
                }
                if (elems[i].toLowerCase().contains("fixedstep")) {
                    this.stepmode = STEPMODE.FIXEDSTEP;
                    continue;
                }
                if (elems[i].toLowerCase().contains("chrom")) {
                    this.currentChr = ChrAnnotation.parseChr(elems[i].substring(9));
                    continue;
                }
                if (elems[i].toLowerCase().contains("span")) {
                    this.currentSpan = Integer.parseInt(elems[i].substring(5));
                    continue;
                }
                if (elems[i].toLowerCase().contains("start")) {
                    this.currentStart = Integer.parseInt(elems[i].substring(6));
                    continue;
                }
                if (!elems[i].toLowerCase().contains("step")) continue;
                this.currentStep = Integer.parseInt(elems[i].substring(5));
            }
            this.nrLnsReadAfterHeader = 0L;
            return this.parseLn();
        }
        if (elems.length > 0) {
            int start = -1;
            double value = -1.0;
            try {
                if (this.stepmode == STEPMODE.FIXEDSTEP) {
                    value = Double.parseDouble(elems[0]);
                    if (this.nrLnsReadAfterHeader == 0L) {
                        start = this.currentStart;
                    } else {
                        start = this.currentStart + this.currentStep;
                        this.currentStart += this.currentStep;
                    }
                } else {
                    start = Integer.parseInt(elems[0]);
                    value = Double.parseDouble(elems[1]);
                }
                UCSCDataObject output = new UCSCDataObject(this.currentChr, start, start + this.currentSpan, value, UCSCDataObject.SORTBY.CHRPOS);
                ++this.nrLnsReadAfterHeader;
                return output;
            }
            catch (NumberFormatException e) {
                System.out.println("Error parsing line! " + (Object)((Object)this.stepmode) + "\t" + Strings.concat(elems, Strings.tab));
                return this.parseLn();
            }
        }
        return null;
    }

    public static enum STEPMODE {
        VARIABLESTEP,
        FIXEDSTEP;

    }
}

