/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.ucsc;

import java.util.ArrayList;
import java.util.Collections;
import umcg.genetica.io.ucsc.UCSCDataObject;

public class UCSCTrack
implements Comparable<UCSCTrack> {
    private String name;
    private ArrayList<UCSCDataObject> data;
    private double min;
    private double max;
    private double sd;
    private double mean;

    public UCSCTrack(String name) {
        this.name = name;
        this.data = new ArrayList();
    }

    public void addDataObject(UCSCDataObject o) {
        this.data.add(o);
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void sort() {
        Collections.sort(this.data);
    }

    public void setSD(double sd) {
        this.sd = sd;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    @Override
    public int compareTo(UCSCTrack o) {
        if (o.equals(this)) {
            return 0;
        }
        return this.name.compareTo(o.name);
    }

    public boolean equals(UCSCTrack o) {
        return o.name.equals(this.name);
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<UCSCDataObject> getData() {
        return this.data;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSD() {
        return this.sd;
    }
}

