/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class eQTLTextFile
extends TextFile {
    public static int PVAL = 0;
    public static int SNP = 1;
    public static int SNPCHR = 2;
    public static int SNPLOC = 3;
    public static int PROBE = 4;
    public static int PROBECHR = 5;
    public static int PROBELOC = 6;
    public static int CISTRANS = 7;
    public static int SNPTYPE = 8;
    public static int ASESSEDALLELE = 9;
    public static int METAZ = 10;
    public static int DATASETNAMES = 11;
    public static int DATASETZSCORE = 12;
    public static int DATASETSIZE = 13;
    public static int HUGO = 16;
    public static int DATASECORR = 17;
    public static int METAB = 18;
    public static int DATASETB = 19;
    private static String sepStr = ";";
    private static String tabStr = "\t";
    private static String nullStr = "-";
    private static Pattern separator = Pattern.compile(sepStr);
    public static String header = "PValue\tSNPName\tSNPChr\tSNPChrPos\tProbeName\tProbeChr\tProbeCenterChrPos\tCisTrans\tSNPType\tAlleleAssessed\tOverallZScore\tDatasetsWhereSNPProbePairIsAvailableAndPassesQC\tDatasetsZScores\tDatasetsNrSamples\tIncludedDatasetsMeanProbeExpression\tIncludedDatasetsProbeExpressionVariance\tHGNCName\tIncludedDatasetsCorrelationCoefficient\tMeta-Beta (SE)\tBeta (SE)\tFoldChange\tFDR";

    public eQTLTextFile(String loc, boolean W) throws IOException {
        super(loc, W);
        if (W) {
            this.write(header + "\n");
        }
    }

    public eQTLTextFile(String loc, boolean W, boolean gz) throws IOException {
        super(loc, W);
        if (W) {
            this.write(header + "\n");
        }
    }

    public void write(EQTL[] eqtllist) throws IOException {
        for (EQTL e : eqtllist) {
            this.write(e.toString() + "\n");
        }
    }

    public EQTL[] read() throws IOException {
        String[] elems = this.readLineElemsReturnReference(tab);
        boolean fdrpresent = false;
        if (elems[elems.length - 1].equals("FDR")) {
            fdrpresent = true;
        }
        elems = this.readLineElemsReturnReference(tab);
        ArrayList<EQTL> alEQTLS = new ArrayList<EQTL>();
        while (elems != null) {
            int i;
            String[] subelems;
            EQTL e = new EQTL();
            if (!elems[0].equals(nullStr)) {
                e.setPvalue(Double.parseDouble(elems[0]));
            }
            if (!elems[1].equals(nullStr)) {
                e.setRsName(elems[1]);
            }
            if (!elems[2].equals(nullStr)) {
                e.setRsChr(ChrAnnotation.parseChr(elems[2]));
            }
            if (!elems[3].equals(nullStr)) {
                e.setRsChrPos(Integer.parseInt(elems[3]));
            }
            if (!elems[4].equals(nullStr)) {
                e.setProbe(elems[4]);
            }
            if (!elems[5].equals(nullStr)) {
                e.setProbeChr(ChrAnnotation.parseChr(elems[5]));
            }
            if (!elems[6].equals(nullStr)) {
                e.setProbeChrPos(Integer.parseInt(elems[6]));
            }
            if (!elems[7].equals(nullStr)) {
                e.setType(elems[7]);
            }
            if (!elems[8].equals(nullStr)) {
                e.setAlleles(elems[8]);
            }
            if (!elems[9].equals(nullStr)) {
                e.setAlleleAssessed(elems[9]);
            }
            if (!elems[10].equals(nullStr)) {
                e.setZscore(Double.parseDouble(elems[10]));
            }
            if (!elems[11].equals(nullStr)) {
                e.setDatasets(separator.split(elems[11]));
            }
            if (!elems[12].equals(nullStr)) {
                subelems = separator.split(elems[12]);
                Double[] dsZScores = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsZScores[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsZScores[i] = Double.NaN;
                    }
                }
                e.setDatasetZScores(dsZScores);
            }
            if (!elems[13].equals(nullStr)) {
                String[] samples = elems[13].split(";");
                Integer[] sampleS = new Integer[samples.length];
                for (int i2 = 0; i2 < samples.length; ++i2) {
                    try {
                        sampleS[i2] = Integer.parseInt(samples[i2]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        sampleS[i2] = null;
                    }
                }
                e.setDatasetsSamples(sampleS);
            }
            if (!elems[14].equals(nullStr)) {
                subelems = separator.split(elems[14]);
                Double[] dsPmeans = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsPmeans[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsPmeans[i] = Double.NaN;
                    }
                }
                e.setProbeMeans(dsPmeans);
            }
            if (!elems[15].equals(nullStr)) {
                subelems = separator.split(elems[15]);
                Double[] dsPvars = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsPvars[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsPvars[i] = Double.NaN;
                    }
                }
                e.setProbeVariance(dsPvars);
            }
            if (!elems[16].equals(nullStr)) {
                e.setProbeHUGO(elems[16]);
            }
            if (!elems[17].equals(nullStr)) {
                subelems = separator.split(elems[17]);
                Double[] dsCorrs = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsCorrs[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsCorrs[i] = Double.NaN;
                    }
                }
                e.setCorrelations(dsCorrs);
            }
            if (!elems[18].equals(nullStr)) {
                e.setMetaBeta(elems[18]);
            }
            if (!elems[19].equals(nullStr)) {
                e.setBeta(elems[19]);
            }
            if (elems.length > 20 && !elems[20].equals(nullStr)) {
                e.setFC(elems[20]);
            }
            if (fdrpresent && !elems[elems.length - 1].equals(nullStr)) {
                e.setFDR(Double.parseDouble(elems[elems.length - 1]));
            }
            alEQTLS.add(e);
            elems = this.readLineElemsReturnReference(tab);
        }
        EQTL[] eqtls = new EQTL[]{};
        return alEQTLS.toArray(eqtls);
    }

    public EQTL[] readExpectedSize(int expSize) throws IOException {
        String[] elems = this.readLineElemsReturnReference(tab);
        boolean fdrpresent = false;
        if (elems[elems.length - 1].equals("FDR")) {
            fdrpresent = true;
        }
        elems = this.readLineElemsReturnReference(tab);
        ArrayList<EQTL> alEQTLS = new ArrayList<EQTL>(expSize);
        while (elems != null) {
            EQTL e = new EQTL();
            if (!elems[0].equals(nullStr)) {
                e.setPvalue(Double.parseDouble(elems[0]));
            }
            if (!elems[1].equals(nullStr)) {
                e.setRsName(elems[1]);
            }
            if (!elems[2].equals(nullStr)) {
                e.setRsChr(ChrAnnotation.parseChr(elems[2]));
            }
            if (!elems[3].equals(nullStr)) {
                e.setRsChrPos(Integer.parseInt(elems[3]));
            }
            if (!elems[4].equals(nullStr)) {
                e.setProbe(elems[4]);
            }
            if (!elems[5].equals(nullStr)) {
                e.setProbeChr(ChrAnnotation.parseChr(elems[5]));
            }
            if (!elems[6].equals(nullStr)) {
                e.setProbeChrPos(Integer.parseInt(elems[6]));
            }
            if (!elems[7].equals(nullStr)) {
                e.setType(elems[7]);
            }
            if (!elems[8].equals(nullStr)) {
                e.setAlleles(elems[8]);
            }
            if (!elems[9].equals(nullStr)) {
                e.setAlleleAssessed(elems[9]);
            }
            if (!elems[10].equals(nullStr)) {
                e.setZscore(Double.parseDouble(elems[10]));
            }
            if (!elems[16].equals(nullStr)) {
                e.setProbeHUGO(elems[16]);
            }
            if (!elems[18].equals(nullStr)) {
                e.setMetaBeta(elems[18]);
            }
            if (!elems[19].equals(nullStr)) {
                e.setBeta(elems[19]);
            }
            if (elems.length > 20 && !elems[20].equals(nullStr)) {
                e.setFC(elems[20]);
            }
            if (fdrpresent && !elems[elems.length - 1].equals(nullStr)) {
                e.setFDR(Double.parseDouble(elems[elems.length - 1]));
            }
            alEQTLS.add(e);
            elems = this.readLineElemsReturnReference(tab);
        }
        EQTL[] eqtls = new EQTL[]{};
        return alEQTLS.toArray(eqtls);
    }
}

