/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.converters;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;

public class FinalReportToTriTyper {
    static final double twoDividedByPI = 0.6366197723675814;

    public FinalReportToTriTyper(String inputFile, String outputDirString, boolean isIlluminaFinalReportFile, String delimiter, String decimalSeparator) throws IOException {
        String column;
        int d;
        String[] data;
        String str;
        File outputDir = new File(outputDirString);
        if (!outputDir.isDirectory()) {
            System.out.println("Your output directory does not exist!");
            System.exit(-1);
        }
        HashMap<String, Integer> hashInd = new HashMap<String, Integer>();
        ArrayList<String> vecInd = new ArrayList<String>();
        HashMap<String, Integer> hashSNP = new HashMap<String, Integer>();
        ArrayList<String> vecSNP = new ArrayList<String>();
        System.out.println("");
        System.out.println("TriTyperImporter V1.0, 2008, Lude Franke, University Medical Centre Utrecht, Lude@ludesign.nl");
        System.out.println("");
        System.out.println("Processing file:\t" + inputFile);
        System.out.println("Inventorizing input file, determining number of unique SNPs and samples:");
        int columnSample = -1;
        int columnSNP = -1;
        int columnAllele1 = -1;
        int columnAllele2 = -1;
        int columnTheta = -1;
        int columnR = -1;
        int columnX = -1;
        int columnY = -1;
        boolean rawDataAvailable = false;
        if (!Gpio.canRead(inputFile)) {
            System.out.println("");
            System.out.println("Cannot open file:\t" + inputFile);
            System.out.println("Are you sure it is located at this place?");
            System.exit(-1);
        }
        TextFile in = new TextFile(inputFile, false);
        if (isIlluminaFinalReportFile) {
            String[] data2;
            int countIlluminaFinalReport = 0;
            while ((str = in.readLine()) != null && !(data2 = str.split(delimiter))[0].trim().equals("[Data]")) {
                if (++countIlluminaFinalReport <= 100) continue;
                System.out.println("\nError: You have defined that this file is a final report file, which it does not seem to be as a row with the word [Data] cannot be found!");
                System.exit(-1);
            }
        }
        if ((str = in.readLine()).toLowerCase().startsWith("[header]")) {
            String[] data3;
            while ((str = in.readLine()) != null && !(data3 = str.split(delimiter))[0].trim().equals("[Data]")) {
            }
            str = in.readLine();
        }
        if ((data = str.split(delimiter)).length <= 1) {
            System.out.println("");
            System.out.println("Error parsing input file! The file cannot be delimited!");
            String delimiterDescription = "tab";
            if (delimiter.equals(" ")) {
                delimiterDescription = "space";
            }
            if (delimiter.equals(",")) {
                delimiterDescription = "comma";
            }
            if (delimiter.equals(";")) {
                delimiterDescription = "semicolon";
            }
            System.out.println("Are you sure it is " + delimiterDescription + " delimited ?");
            System.exit(-1);
        }
        for (d = 0; d < data.length; ++d) {
            column = data[d].trim().toLowerCase();
            if (column.equals("sample id")) {
                columnSample = d;
            }
            if (column.equals("snp name")) {
                columnSNP = d;
            }
            if (column.contains("allele1")) {
                columnAllele1 = d;
            }
            if (column.contains("allele 1")) {
                columnAllele1 = d;
            }
            if (column.contains("allele2")) {
                columnAllele2 = d;
            }
            if (column.contains("allele 2")) {
                columnAllele2 = d;
            }
            if (column.equals("r")) {
                columnR = d;
            }
            if (!column.equals("theta")) continue;
            columnTheta = d;
        }
        if (columnSample == -1) {
            System.out.println("\nError: Within the header of this file the sample id column (Sample ID) cannot be found!");
            System.exit(-1);
        }
        if (columnAllele1 == -1) {
            System.out.println("\nError: Within the header of this file the allele 1 column (Allele1) cannot be found!");
            System.exit(-1);
        }
        if (columnAllele2 == -1) {
            System.out.println("\nError: Within the header of this file the allele 2 column (Allele2) cannot be found!");
            System.exit(-1);
        }
        if (columnSNP == -1) {
            System.out.println("\nError: Within the header of this file the SNP name column (SNP Name) cannot be found!");
            System.exit(-1);
        }
        rawDataAvailable = true;
        for (d = 0; d < data.length; ++d) {
            column = data[d].trim().toLowerCase();
            if (column.equals("x")) {
                columnX = d;
            }
            if (!column.equals("y")) continue;
            columnY = d;
        }
        if (!(columnR != -1 && columnTheta != -1 || columnX != -1 && columnY != -1)) {
            System.out.println("Within the header of this file no raw intensity data is present (either R and Theta, or X and Y). Only imputation of triallelic SNPs will be possible");
            rawDataAvailable = false;
        }
        System.out.println("");
        boolean fileAlreadyInventorized = false;
        if (new File(outputDirString + "Individuals.txt").exists() && new File(outputDirString + "SNPs.txt").exists()) {
            fileAlreadyInventorized = true;
        }
        if (!fileAlreadyInventorized) {
            String previousSNP = null;
            String previousInd = null;
            long linesProcessed = 0L;
            while ((str = in.readLine()) != null) {
                data = str.split(delimiter);
                if (data.length <= 1) {
                    System.out.println("\nError parsing input file! The file cannot be delimited!");
                    String delimiterDescription = "tab";
                    if (delimiter.equals(" ")) {
                        delimiterDescription = "space";
                    }
                    if (delimiter.equals(",")) {
                        delimiterDescription = "comma";
                    }
                    if (delimiter.equals(";")) {
                        delimiterDescription = "semicolon";
                    }
                    System.out.println("Are you sure it is " + delimiterDescription + " delimited ?");
                }
                if (data.length <= columnSNP || data.length <= columnSample) {
                    System.out.println("\nError: For record entry " + (linesProcessed + 1L) + " the SNP or sample cannot be parsed! Record: " + str);
                    System.exit(-1);
                }
                String snp = data[columnSNP];
                String ind = data[columnSample];
                if (!snp.equals(previousSNP) && !hashSNP.containsKey(snp)) {
                    hashSNP.put(snp, vecSNP.size());
                    vecSNP.add(snp);
                }
                if (!ind.equals(previousInd) && !hashInd.containsKey(ind)) {
                    hashInd.put(ind, vecInd.size());
                    vecInd.add(ind);
                }
                previousSNP = snp;
                previousInd = ind;
                if (++linesProcessed % 500000L != 0L) continue;
                System.out.println(linesProcessed + "\tLines processed. Number of unique SNPs read so far:\t" + vecSNP.size() + "\tNumber of unique Individuals read so far:\t" + vecInd.size());
            }
            System.out.println(linesProcessed + "\tLines processed. Number of unique SNPs read:\t" + vecSNP.size() + "\tNumber of unique Individuals read:\t" + vecInd.size());
            in.close();
            String fileSNPMappings = new String(outputDirString + "SNPMappings.txt");
            if (!Gpio.canRead(fileSNPMappings)) {
                System.out.println("\nNon critical warning: SNPMappings.txt can not be found in the output directory. Data will not be stored in optimized way, which will negatively affect the speed of TriTyper.\n");
            } else {
                String str2;
                System.out.println("\nLoading SNP mappings from file:\t" + fileSNPMappings);
                TextFile inSNP = new TextFile(fileSNPMappings, false);
                ArrayList<String> vectorTemp = new ArrayList<String>();
                boolean needsSorting = false;
                while ((str2 = inSNP.readLine()) != null) {
                    data = str2.split("\t");
                    if (!hashSNP.containsKey(data[2])) continue;
                    if (data[1].length() != 9) {
                        needsSorting = true;
                        while (data[1].length() < 9) {
                            data[1] = "0" + data[1];
                        }
                    }
                    vectorTemp.add(data[0] + "\t" + data[1] + "\t" + data[2]);
                }
                inSNP.close();
                if (needsSorting) {
                    System.out.println("Sorting SNPs on chromosome and physical position that are present in SNP mappings file:");
                    Collections.sort(vectorTemp);
                }
                HashMap<String, Integer> hashSNPMappings = new HashMap<String, Integer>();
                ArrayList<String> vecSNPMappings = new ArrayList<String>();
                for (int snp = 0; snp < vectorTemp.size(); ++snp) {
                    String snpString = (String)vectorTemp.get(snp);
                    hashSNPMappings.put(snpString.split("\t")[2], vecSNPMappings.size());
                    vecSNPMappings.add(snpString.split("\t")[2]);
                }
                System.out.println("Number of SNPs with available physical mappings:\t" + vecSNPMappings.size());
                boolean[] snpMappingsUsed = new boolean[vecSNPMappings.size()];
                ArrayList vecSNPCopy = new ArrayList();
                for (int snp = 0; snp < vecSNP.size(); ++snp) {
                    String rsName = (String)vecSNP.get(snp);
                    if (!hashSNPMappings.containsKey(rsName)) continue;
                    snpMappingsUsed[((Integer)hashSNPMappings.get((Object)rsName)).intValue()] = true;
                }
                ArrayList<String> vecSNPNew = new ArrayList<String>();
                HashMap<String, Integer> hashSNPNew = new HashMap<String, Integer>();
                for (int snp = 0; snp < vecSNPMappings.size(); ++snp) {
                    if (!snpMappingsUsed[snp]) continue;
                    String rsName = (String)vecSNPMappings.get(snp);
                    hashSNPNew.put(rsName, vecSNPNew.size());
                    vecSNPNew.add(rsName);
                }
                ArrayList<String> snpsWithoutMapping = new ArrayList<String>();
                for (int snp = 0; snp < vecSNP.size(); ++snp) {
                    String rsName = (String)vecSNP.get(snp);
                    if (hashSNPNew.containsKey(rsName)) continue;
                    hashSNPNew.put(rsName, vecSNPNew.size());
                    vecSNPNew.add(rsName);
                    snpsWithoutMapping.add(rsName);
                }
                if (snpsWithoutMapping.size() > 0) {
                    System.out.println("Non critical warning: No physical mapping is available for SNPs:");
                    for (int s = 0; s < snpsWithoutMapping.size(); ++s) {
                        System.out.println((String)snpsWithoutMapping.get(s));
                    }
                    System.out.println("");
                }
                vecSNP.clear();
                hashSNP.clear();
                vecSNP = vecSNPNew;
                hashSNP = hashSNPNew;
            }
            System.out.print("Writing individuals to file:\t");
            TextFile outInd = new TextFile(outputDirString + "Individuals.txt", true);
            for (int ind = 0; ind < vecInd.size(); ++ind) {
                String individual = (String)vecInd.get(ind);
                outInd.write(individual + "\n");
            }
            outInd.close();
            System.out.println("OK");
            System.out.print("Writing SNPs to file:\t");
            TextFile outSNP = new TextFile(outputDirString + "SNPs.txt", true);
            for (int snp = 0; snp < vecSNP.size(); ++snp) {
                outSNP.write((String)vecSNP.get(snp) + "\n");
            }
            outSNP.close();
            System.out.println("OK");
        } else {
            vecInd.clear();
            hashInd.clear();
            TextFile inInd = new TextFile(outputDirString + "Individuals.txt", false);
            while ((str = inInd.readLine()) != null) {
                hashInd.put(str, vecInd.size());
                vecInd.add(str);
            }
            inInd.close();
            vecSNP.clear();
            hashSNP.clear();
            TextFile inSNP = new TextFile(outputDirString + "SNPs.txt", false);
            while ((str = inSNP.readLine()) != null) {
                hashSNP.put(str, vecSNP.size());
                vecSNP.add(str);
            }
            inSNP.close();
        }
        int nrInds = vecInd.size();
        int nrSNPs = vecSNP.size();
        boolean fileOrderPerSampleAllSNPs = false;
        boolean fileOrderPerSNPAllSamples = false;
        in = new TextFile(inputFile, false);
        str = null;
        if (isIlluminaFinalReportFile) {
            while ((str = in.readLine()) != null && !(data = str.split(delimiter))[0].trim().equals("[Data]")) {
            }
        }
        if ((str = in.readLine()).toLowerCase().startsWith("[header]")) {
            while ((str = in.readLine()) != null && !(data = str.split(delimiter))[0].trim().equals("[Data]")) {
            }
            str = in.readLine();
        }
        data = str.split(delimiter);
        int previousIndID = -1;
        int previousSNPID = -1;
        while ((str = in.readLine()) != null) {
            if (str.indexOf("\"") != -1) {
                str = str.replaceAll("\"", "");
            }
            if (str.indexOf("'") != -1) {
                str = str.replaceAll("'", "");
            }
            data = str.split(delimiter);
            String snp = data[columnSNP];
            String ind = data[columnSample];
            int snpID = (Integer)hashSNP.get(snp);
            int indID = (Integer)hashInd.get(ind);
            if (previousIndID != -1 && previousSNPID != -1) {
                if (snpID == previousSNPID && indID != previousIndID) {
                    fileOrderPerSNPAllSamples = true;
                    System.out.println("Based on the import file, TriTyper Importer assumes that the order of the file is such that for each SNP all samples are underneath each other in the import file. This assumptions increases importing performance.");
                }
                if (snpID == previousSNPID || indID != previousIndID) break;
                fileOrderPerSampleAllSNPs = true;
                System.out.println("Based on the import file, TriTyper Importer assumes that the order of the file is such that for each sample all SNPs are underneath each other in the import file. This assumptions increases importing performance.");
                break;
            }
            previousIndID = indID;
            previousSNPID = snpID;
        }
        System.out.print("Initializing binary data files:\t");
        RandomAccessFile file = new RandomAccessFile(outputDirString + "GenotypeMatrix.dat", "rw");
        RandomAccessFile fileRawData = null;
        if (rawDataAvailable) {
            fileRawData = new RandomAccessFile(outputDirString + "RawDataMatrix.dat", "rw");
        }
        System.out.println("OK");
        long size = (long)vecSNP.size() * (long)vecInd.size();
        long sizeGenotypeMatrix = size * 2L;
        long sizeRawDataMatrix = size * 3L;
        file.setLength(0L);
        if (rawDataAvailable) {
            fileRawData.setLength(0L);
        }
        System.out.print("Making binary files zero:\t");
        file.seek(0L);
        if (rawDataAvailable) {
            fileRawData.seek(0L);
        }
        byte[] emptyString = new byte[10000];
        for (int s = 0; s < 10000; ++s) {
            emptyString[s] = 0;
        }
        for (long a = 0L; a < size / 10000L; ++a) {
            file.write(emptyString);
            file.write(emptyString);
            if (!rawDataAvailable) continue;
            fileRawData.write(emptyString);
            fileRawData.write(emptyString);
            fileRawData.write(emptyString);
        }
        long rest = size % 10000L;
        int a = 0;
        while ((long)a < rest) {
            int emptyByte = 0;
            file.write(emptyByte);
            file.write(emptyByte);
            if (rawDataAvailable) {
                fileRawData.write(emptyByte);
                fileRawData.write(emptyByte);
                fileRawData.write(emptyByte);
            }
            ++a;
        }
        System.out.println("OK");
        System.out.println("Processing input file:");
        file.seek(0L);
        if (rawDataAvailable) {
            fileRawData.seek(0L);
        }
        in = new TextFile(inputFile, false);
        str = null;
        if (isIlluminaFinalReportFile) {
            while ((str = in.readLine()) != null && !(data = str.split(delimiter))[0].trim().equals("[Data]")) {
            }
        }
        if ((str = in.readLine()).toLowerCase().startsWith("[header]")) {
            while ((str = in.readLine()) != null && !(data = str.split(delimiter))[0].trim().equals("[Data]")) {
            }
            str = in.readLine();
        }
        data = str.split(delimiter);
        byte[][] bufferAllele1 = null;
        byte[][] bufferAllele2 = null;
        byte[][] bufferR = null;
        byte[][] bufferTheta = null;
        int bufferFirstInd = 0;
        int bufferCurrentPos = 0;
        if (fileOrderPerSampleAllSNPs) {
            bufferAllele1 = new byte[nrSNPs][100];
            bufferAllele2 = new byte[nrSNPs][100];
            bufferR = new byte[nrSNPs][100];
            bufferTheta = new byte[nrSNPs][100];
        }
        if (fileOrderPerSNPAllSamples) {
            bufferAllele1 = new byte[1][nrInds];
            bufferAllele2 = new byte[1][nrInds];
            bufferR = new byte[1][nrInds];
            bufferTheta = new byte[1][nrInds];
        }
        long linesProcessed = 0L;
        previousIndID = -1;
        previousSNPID = -1;
        boolean warningGivenOnABGenotypeDefinition = false;
        while ((str = in.readLine()) != null) {
            if (str.indexOf("\"") != -1) {
                str = str.replaceAll("\"", "");
            }
            if (str.indexOf("'") != -1) {
                str = str.replaceAll("'", "");
            }
            data = str.split(delimiter);
            String snp = data[columnSNP];
            String ind = data[columnSample];
            double r = 0.0;
            double theta = 0.0;
            if (rawDataAvailable) {
                if (columnR != -1 && columnTheta != -1) {
                    if (data.length <= columnR || data.length <= columnTheta) {
                        System.out.println("\nError: For record entry " + (linesProcessed + 1L) + " R or Theta values cannot be parsed! Record: " + str);
                        System.out.println("Can it be there are some entries in the file that do not have R or Theta value information?");
                        System.exit(-1);
                    }
                    String rString = data[columnR];
                    String thetaString = data[columnTheta];
                    if (!decimalSeparator.equals(".")) {
                        thetaString = thetaString.replaceAll(decimalSeparator, ".");
                        rString = rString.replaceAll(decimalSeparator, ".");
                    }
                    try {
                        r = Double.parseDouble(rString);
                    }
                    catch (Exception e) {
                        System.out.println("\nError parsing R value: '" + rString + "'. Are you sure it has been saved in the correct locale?");
                        System.out.println("This method assumes R values have a decimal separator that is a dot.");
                        System.out.println("E.g. if you export a final report from within BeadStudio, using a Dutch Windows");
                        System.out.println("locale, the eventual final report file uses a comma as decimal separator.");
                        System.out.println("In that case use option '-decimalseparatoriscomma'");
                        System.exit(-1);
                    }
                    try {
                        theta = Double.parseDouble(thetaString);
                    }
                    catch (Exception e) {
                        System.out.println("\nError parsing theta value: '" + thetaString + "'. Are you sure it has been saved in the correct locale?");
                        System.out.println("This method assumes theta values have a decimal separator that is a dot.");
                        System.out.println("E.g. if you export a final report from within BeadStudio, using a Dutch Windows");
                        System.out.println("locale, the eventual final report file uses a comma as decimal separator.");
                        System.out.println("In that case use option '-decimalseparatoriscomma'");
                        System.exit(-1);
                    }
                } else {
                    if (data.length <= columnX || data.length <= columnY) {
                        System.out.println("\nError: For record entry " + (linesProcessed + 1L) + " X or Y intensities cannot be parsed! Record: " + str);
                        System.out.println("Can it be there are some entries in the file that do not have X or Y intensity information?");
                        System.exit(-1);
                    }
                    String xString = data[columnX];
                    String yString = data[columnY];
                    if (!decimalSeparator.equals(".")) {
                        xString = xString.replaceAll(decimalSeparator, ".");
                        yString = yString.replaceAll(decimalSeparator, ".");
                    }
                    double x = 0.0;
                    double y = 0.0;
                    try {
                        x = Double.parseDouble(xString);
                    }
                    catch (Exception e) {
                        System.out.println("\nError parsing X value: '" + xString + "'. Are you sure it has been saved in the correct locale?");
                        System.out.println("This method assumes X values have a decimal separator that is a dot.");
                        System.out.println("E.g. if you export a final report from within BeadStudio, using a Dutch Windows");
                        System.out.println("locale, the eventual final report file uses a comma as decimal separator.");
                        System.out.println("In that case use option '-decimalseparatoriscomma'");
                        System.exit(-1);
                    }
                    try {
                        y = Double.parseDouble(yString);
                    }
                    catch (Exception e) {
                        System.out.println("\nError parsing Y value: '" + yString + "'. Are you sure it has been saved in the correct locale?");
                        System.out.println("This method assumes Y values have a decimal separator that is a dot.");
                        System.out.println("E.g. if you export a final report from within BeadStudio, using a Dutch Windows");
                        System.out.println("locale, the eventual final report file uses a comma as decimal separator.");
                        System.out.println("In that case use option '-decimalseparatoriscomma'");
                        System.exit(-1);
                    }
                    r = x + y;
                    theta = 1.0;
                    if (x > 0.0) {
                        theta = 0.6366197723675814 * Math.atan2(y, x);
                    }
                }
            }
            byte rByte = (byte)(-128.0 + Math.min(255.0, r * 50.0));
            byte thetaByte = (byte)(-128.0 + theta * 200.0);
            int allele1 = data[columnAllele1].getBytes()[0];
            int allele2 = data[columnAllele2].getBytes()[0];
            if (allele1 == 45) {
                allele1 = 0;
            }
            if (allele2 == 45) {
                allele2 = 0;
            }
            if (allele1 == 66) {
                allele1 = 67;
                if (!warningGivenOnABGenotypeDefinition) {
                    warningGivenOnABGenotypeDefinition = true;
                    System.out.println("\n\n\nWarning! The input genotype report file contains alleles that have been coded as B! These will be changed to C, please take this into account!!!\n\n\n");
                }
            }
            if (allele2 == 66) {
                allele2 = 67;
                if (!warningGivenOnABGenotypeDefinition) {
                    warningGivenOnABGenotypeDefinition = true;
                    System.out.println("\n\n\nWarning! The input genotype report file contains alleles that have been coded as B! These will be changed to C, please take this into account!!!\n\n\n");
                }
            }
            int snpID = (Integer)hashSNP.get(snp);
            int indID = (Integer)hashInd.get(ind);
            if (fileOrderPerSampleAllSNPs || fileOrderPerSNPAllSamples) {
                if (fileOrderPerSampleAllSNPs) {
                    if (indID != previousIndID && previousIndID != -1) {
                        ++bufferCurrentPos;
                    }
                    if (bufferCurrentPos == 100) {
                        System.out.println("100 samples have been processed, flushing buffers:");
                        for (int s = 0; s < nrSNPs; ++s) {
                            file.seek((long)s * (long)nrInds * 2L + (long)bufferFirstInd);
                            file.write(bufferAllele1[s]);
                            file.seek((long)s * (long)nrInds * 2L + (long)nrInds + (long)bufferFirstInd);
                            file.write(bufferAllele2[s]);
                            if (!rawDataAvailable) continue;
                            fileRawData.seek((long)s * (long)vecInd.size() * 3L + (long)vecInd.size() + (long)bufferFirstInd);
                            fileRawData.write(bufferR[s]);
                            fileRawData.seek((long)s * (long)vecInd.size() * 3L + 2L * (long)vecInd.size() + (long)bufferFirstInd);
                            fileRawData.write(bufferTheta[s]);
                        }
                        bufferAllele1 = new byte[nrSNPs][100];
                        bufferAllele2 = new byte[nrSNPs][100];
                        bufferR = new byte[nrSNPs][100];
                        bufferTheta = new byte[nrSNPs][100];
                        bufferCurrentPos = 0;
                        bufferFirstInd = indID;
                    }
                    bufferAllele1[snpID][bufferCurrentPos] = allele1;
                    bufferAllele2[snpID][bufferCurrentPos] = allele2;
                    bufferR[snpID][bufferCurrentPos] = rByte;
                    bufferTheta[snpID][bufferCurrentPos] = thetaByte;
                } else {
                    if (snpID != previousSNPID && previousSNPID != -1) {
                        int s = previousSNPID;
                        file.seek((long)s * (long)nrInds * 2L);
                        file.write(bufferAllele1[0]);
                        file.seek((long)s * (long)nrInds * 2L + (long)nrInds);
                        file.write(bufferAllele2[0]);
                        if (rawDataAvailable) {
                            fileRawData.seek((long)s * (long)vecInd.size() * 3L + (long)vecInd.size());
                            fileRawData.write(bufferR[0]);
                            fileRawData.seek((long)s * (long)vecInd.size() * 3L + 2L * (long)vecInd.size());
                            fileRawData.write(bufferTheta[0]);
                        }
                        bufferAllele1 = new byte[1][nrInds];
                        bufferAllele2 = new byte[1][nrInds];
                        bufferR = new byte[1][nrInds];
                        bufferTheta = new byte[1][nrInds];
                    }
                    bufferAllele1[0][indID] = allele1;
                    bufferAllele2[0][indID] = allele2;
                    bufferR[0][indID] = rByte;
                    bufferTheta[0][indID] = thetaByte;
                }
            } else {
                file.seek((long)snpID * (long)nrInds * 2L + (long)indID);
                file.write(allele1);
                file.seek((long)snpID * (long)nrInds * 2L + (long)nrInds + (long)indID);
                file.write(allele2);
                if (rawDataAvailable) {
                    fileRawData.seek((long)snpID * (long)vecInd.size() * 3L + (long)vecInd.size() + (long)indID);
                    fileRawData.write(rByte);
                    fileRawData.seek((long)snpID * (long)vecInd.size() * 3L + 2L * (long)vecInd.size() + (long)indID);
                    fileRawData.write(thetaByte);
                }
            }
            if (++linesProcessed % 500000L == 0L) {
                System.out.println(linesProcessed + "\tLines processed");
            }
            previousIndID = indID;
            previousSNPID = snpID;
        }
        if (fileOrderPerSampleAllSNPs || fileOrderPerSNPAllSamples) {
            if (fileOrderPerSampleAllSNPs) {
                System.out.println("Flushing remaining buffer (" + (bufferCurrentPos + 1) + " samples):");
                for (int s = 0; s < nrSNPs; ++s) {
                    byte[] bufferAllele1Subset = new byte[bufferCurrentPos + 1];
                    byte[] bufferAllele2Subset = new byte[bufferCurrentPos + 1];
                    byte[] bufferRSubset = new byte[bufferCurrentPos + 1];
                    byte[] bufferThetaSubset = new byte[bufferCurrentPos + 1];
                    for (int i = 0; i <= bufferCurrentPos; ++i) {
                        bufferAllele1Subset[i] = bufferAllele1[s][i];
                        bufferAllele2Subset[i] = bufferAllele2[s][i];
                        bufferRSubset[i] = bufferR[s][i];
                        bufferThetaSubset[i] = bufferTheta[s][i];
                    }
                    file.seek((long)s * (long)nrInds * 2L + (long)bufferFirstInd);
                    file.write(bufferAllele1Subset);
                    file.seek((long)s * (long)nrInds * 2L + (long)nrInds + (long)bufferFirstInd);
                    file.write(bufferAllele2Subset);
                    if (!rawDataAvailable) continue;
                    fileRawData.seek((long)s * (long)vecInd.size() * 3L + (long)vecInd.size() + (long)bufferFirstInd);
                    fileRawData.write(bufferRSubset);
                    fileRawData.seek((long)s * (long)vecInd.size() * 3L + 2L * (long)vecInd.size() + (long)bufferFirstInd);
                    fileRawData.write(bufferThetaSubset);
                }
            } else {
                int s = previousSNPID;
                file.seek((long)s * (long)nrInds * 2L);
                file.write(bufferAllele1[0]);
                file.seek((long)s * (long)nrInds * 2L + (long)nrInds);
                file.write(bufferAllele2[0]);
                if (rawDataAvailable) {
                    fileRawData.seek((long)s * (long)vecInd.size() * 3L + (long)vecInd.size());
                    fileRawData.write(bufferR[0]);
                    fileRawData.seek((long)s * (long)vecInd.size() * 3L + 2L * (long)vecInd.size());
                    fileRawData.write(bufferTheta[0]);
                }
            }
        }
        System.out.println(linesProcessed + "\tLines processed");
        in.close();
        file.close();
        if (rawDataAvailable) {
            fileRawData.close();
        }
        System.out.println("Import of data has completed successfully!");
        System.out.println("");
        System.out.println("Please ensure you include a valid PhenotypeInformation.txt and SNPMappings.txt in the output directory.");
        System.out.println("These two additional files are required in order for TriTyper to function correctly.");
    }

    public static void main(String[] args) {
        if (Runtime.getRuntime().maxMemory() < 524288000L) {
            System.out.println("Error! You have not dedicated at least 512 Mb to TriTyper Importer. Please use the -Xmx512m option to invoke TriTyper Importer!");
            System.exit(-1);
        }
        if (args.length <= 1) {
            System.out.println("TriTyperImporter V1.0, 2008, Lude Franke, University Medical Centre Utrecht, Lude@ludesign.nl");
            System.out.println("\nUsage:\njava -jar trityperimporter.jar [-options] inputfile outputdir");
            System.out.println("\nThe default action is to process the input file, assuming it is tab delimited.");
            System.out.println("This file has to start with a header, describing which columns represent");
            System.out.println("the sample ID (Sample ID), SNP name (SNP Name), allele 1 genotype (Allele 1),");
            System.out.println("allele 2 genotype (Allele 2). If raw intensity data is available either the");
            System.out.println("R (R) and theta values (Theta) values should be included or X and Y columns.");
            System.out.println("");
            System.out.println("Files will be generated in 'outputdir' that can subsequently be used by TriTyper.");
            System.out.println("");
            System.out.println("It is recommended to use an Illumina final report file, as it is very easy to generate.");
            System.out.println("To use a final report file, please use the option: \"-finalreportformat\".");
            System.out.println("");
            System.out.println("To improve processing speed of TriTyper it is recommended to already have the");
            System.out.println("SNPMappings.txt file available in the output directory. This will sort the SNPs");
            System.out.println("per chromosome, which will considerably improve the speed of triallelic SNP discovery.");
            System.out.println("");
            System.out.println("Options:\t");
            System.out.println("-finalreportformat         Input file has been generated as a final report from within BeadStudio.");
            System.out.println("-tabdelimited              Input file is tab delimited (standard)");
            System.out.println("-commadelimited            Input file is comma delimited");
            System.out.println("-spacedelimited            Input file is space delimited");
            System.out.println("-semicolondelimited        Input file is semicolon delimited");
            System.out.println("-decimalseparatoriscomma   Within the input file decimals are separated with comma's, instead of dots (Applies e.g. to Dutch locale).");
            System.exit(0);
        }
        boolean isIlluminaFinalReportFile = false;
        String delimiter = "\t";
        String decimalSeparator = ".";
        for (int a = 0; a < args.length; ++a) {
            String argument = args[a].trim();
            if (argument.startsWith("-commadelimited")) {
                delimiter = ",";
            }
            if (argument.startsWith("-tabdelimited")) {
                delimiter = "\t";
            }
            if (argument.startsWith("-spacedelimited")) {
                delimiter = " ";
            }
            if (argument.startsWith("-semicolondelimited")) {
                delimiter = ";";
            }
            if (argument.startsWith("-finalreportformat")) {
                isIlluminaFinalReportFile = true;
            }
            if (!argument.startsWith("-decimalseparatoriscomma")) continue;
            decimalSeparator = ",";
        }
        String inputFile = args[args.length - 2].trim();
        String outputDir = args[args.length - 1].trim();
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        try {
            new FinalReportToTriTyper(inputFile, outputDir, isIlluminaFinalReportFile, delimiter, decimalSeparator);
        }
        catch (IOException ex) {
            Logger.getLogger(FinalReportToTriTyper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

