/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.graphics;

import JSci.maths.ArrayMath;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import javax.imageio.ImageIO;
import umcg.genetica.containers.Pair;
import umcg.genetica.containers.Triple;
import umcg.genetica.math.stats.WilcoxonMannWhitney;

public class ViolinBoxPlot {
    private double getWidth(String text, Font font) {
        Graphics2D g2d = new BufferedImage(1, 1, 2).createGraphics();
        TextLayout tL = new TextLayout(text, font, g2d.getFontRenderContext());
        return tL.getBounds().getWidth();
    }

    public void draw(double[][][] vals, String[] datasetNames, String[][] xLabels, String yLabel, Output output, String outputFileName) throws IOException {
        this.draw(vals, datasetNames, xLabels, yLabel, output, outputFileName, false);
    }

    public void draw(double[][][] vals, String[] datasetNames, String[][] xLabels, String yLabel, Output output, String outputFileName, boolean sortresults) throws IOException {
        int category2;
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Graphics2D g2d = null;
        Document document = null;
        PdfWriter writer = null;
        PdfContentByte cb = null;
        BufferedImage bi = null;
        AlphaComposite alphaComposite25 = AlphaComposite.getInstance(3, 0.25f);
        AlphaComposite alphaComposite50 = AlphaComposite.getInstance(3, 0.5f);
        AlphaComposite alphaComposite100 = AlphaComposite.getInstance(2, 1.0f);
        float fontSize = 12.0f;
        Font font = new Font("Gill Sans MT", 0, (int)fontSize);
        Font fontBold = new Font("Gill Sans MT", 1, (int)fontSize);
        Font fontSmall = new Font("Gill Sans MT", 0, 8);
        Font fontBoldSmall = new Font("Gill Sans MT", 1, 8);
        int[] datasetWitdths = new int[datasetNames.length];
        int individualPlotWidth = 70;
        int individualPlotMarginLeft = 10;
        int individualPlotMarginRight = 10;
        int betweenDatasetMargin = 20;
        int marginLeft = 100;
        int marginRight = 100;
        int marginTop = 100;
        int marginBottom = 100;
        int innerHeight = 500;
        int totalDatasetWidth = 0;
        int tableElementHeight = 25;
        boolean printTable = false;
        int maxNrCategories = 0;
        for (int x = 0; x < datasetNames.length; ++x) {
            int nrCategoriesInDataset = vals[x].length;
            datasetWitdths[x] = nrCategoriesInDataset * (individualPlotWidth + individualPlotMarginLeft + individualPlotMarginRight);
            if (nrCategoriesInDataset > 2) {
                printTable = true;
                if (nrCategoriesInDataset > maxNrCategories) {
                    maxNrCategories = nrCategoriesInDataset;
                }
            }
            totalDatasetWidth += datasetWitdths[x];
        }
        int docWidth = marginLeft + marginRight + (totalDatasetWidth += (datasetNames.length - 1) * betweenDatasetMargin);
        int docHeight = marginTop + marginBottom + innerHeight;
        if (printTable) {
            docHeight += maxNrCategories * tableElementHeight;
        }
        if (output == Output.PDF) {
            Rectangle rectangle = new Rectangle((float)docWidth, (float)docHeight);
            document = new Document(rectangle);
            try {
                writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outputFileName));
            }
            catch (DocumentException e) {
                throw new IOException(e.fillInStackTrace());
            }
            document.open();
            cb = writer.getDirectContent();
            cb.saveState();
            g2d = cb.createGraphics((float)docWidth, (float)docHeight);
        } else {
            bi = new BufferedImage(docWidth, docHeight, 1);
            g2d = bi.createGraphics();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, docWidth, docHeight);
        double minValue = Double.MAX_VALUE;
        double maxValue = -1.7976931348623157E308;
        WilcoxonMannWhitney wmw = new WilcoxonMannWhitney();
        double[][][] aucs = new double[vals.length][vals[0].length][vals[0].length];
        double[][][] pvals = new double[vals.length][vals[0].length][vals[0].length];
        for (int dataset = 0; dataset < datasetNames.length; ++dataset) {
            double[][] valsForDs = vals[dataset];
            for (int category1 = 0; category1 < valsForDs.length; ++category1) {
                double[] vals1 = valsForDs[category1];
                double min1 = ArrayMath.min((double[])vals1);
                double max1 = ArrayMath.max((double[])vals1);
                if (min1 < minValue) {
                    minValue = min1;
                }
                if (max1 > maxValue) {
                    maxValue = max1;
                }
                for (category2 = category1 + 1; category2 < valsForDs.length; ++category2) {
                    double[] vals2 = valsForDs[category2];
                    double pValueWilcoxon = wmw.returnWilcoxonMannWhitneyPValue(vals2, vals1);
                    double auc = wmw.getAUC();
                    double min2 = ArrayMath.min((double[])vals2);
                    double max2 = ArrayMath.max((double[])vals2);
                    aucs[dataset][category1][category2] = auc;
                    pvals[dataset][category1][category2] = pValueWilcoxon;
                    if (max2 > maxValue) {
                        maxValue = max2;
                    }
                    if (!(min2 < minValue)) continue;
                    minValue = min2;
                }
            }
        }
        ArrayList<Pair<Double, Integer>> sortedPValuesPerDataset = new ArrayList<Pair<Double, Integer>>();
        ArrayList<Pair<Double, Triple<Integer, Integer, Integer>>> sortedPValuesPerCategory = new ArrayList<Pair<Double, Triple<Integer, Integer, Integer>>>();
        for (int dataset = 0; dataset < vals.length; ++dataset) {
            double[][] aucsfordataset = aucs[dataset];
            double[][] pvaluesfordataset = pvals[dataset];
            double d = Double.MAX_VALUE;
            for (int category1 = 0; category1 < pvaluesfordataset.length; ++category1) {
                for (category2 = category1 + 1; category2 < pvaluesfordataset.length; ++category2) {
                    double valueToSort = pvaluesfordataset[category1][category2];
                    sortedPValuesPerCategory.add(new Pair<Double, Triple<Integer, Integer, Integer>>(Double.valueOf(valueToSort), new Triple<Integer, Integer, Integer>(dataset, category1, category2), Pair.SORTBY.LEFT));
                    if (!(valueToSort < d)) continue;
                    d = valueToSort;
                }
            }
            sortedPValuesPerDataset.add(new Pair<Double, Integer>(Double.valueOf(d), Integer.valueOf(dataset), Pair.SORTBY.LEFT));
        }
        if (sortresults) {
            Collections.sort(sortedPValuesPerDataset, Collections.reverseOrder());
            Collections.sort(sortedPValuesPerCategory, Collections.reverseOrder());
        }
        int datasetCounter = 0;
        int deltaX = 0;
        for (Pair pair : sortedPValuesPerDataset) {
            Integer datasetNumber = (Integer)pair.getRight();
            int datasetwidth = datasetWitdths[datasetNumber];
            g2d.setComposite(alphaComposite100);
            int x = marginLeft + deltaX;
            int height = innerHeight;
            GradientPaint gradient = new GradientPaint(0.0f, marginTop, new Color(230, 230, 230), 0.0f, height, new Color(250, 250, 250));
            g2d.setPaint(gradient);
            g2d.fillRect(x - individualPlotMarginLeft / 2, marginTop - 90, datasetwidth, height + 100);
            ArrayList sortedPValuesForDataset = new ArrayList();
            for (Pair pair2 : sortedPValuesPerCategory) {
                System.out.println(pair2.toString());
                if (!((Integer)((Triple)pair2.getRight()).getLeft()).equals(datasetNumber)) continue;
                sortedPValuesForDataset.add(pair2.getRight());
            }
            HashSet<Integer> visitedCategories = new HashSet<Integer>();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Triple datasetCategoryCombo : sortedPValuesForDataset) {
                Integer category1 = (Integer)datasetCategoryCombo.getMiddle();
                Integer category22 = (Integer)datasetCategoryCombo.getRight();
                if (!visitedCategories.contains(category1)) {
                    arrayList.add(category1);
                    visitedCategories.add(category1);
                }
                if (visitedCategories.contains(category22)) continue;
                arrayList.add(category22);
                visitedCategories.add(category22);
            }
            String datasetName = datasetNames[datasetNumber];
            int y = marginTop;
            g2d.setColor(new Color(0, 0, 0));
            g2d.setFont(fontBold);
            g2d.drawString(datasetName, x + 5, y - 70);
            g2d.setFont(font);
            int[] categoryIndex = new int[vals[datasetNumber].length];
            int categoryCounter = 0;
            int plotStart = x + individualPlotMarginLeft;
            for (Integer category : arrayList) {
                int xposViolin;
                double[] vals1 = vals[datasetNumber][category];
                categoryIndex[category.intValue()] = categoryCounter;
                g2d.setComposite(alphaComposite25);
                g2d.setColor(new Color(223, 36, 20));
                int xposBoxPlot = xposViolin = plotStart - 5 + (individualPlotMarginLeft + individualPlotWidth + individualPlotMarginRight) * categoryCounter;
                this.drawViolinPlot(g2d, xposViolin, y, individualPlotWidth, height, vals1, minValue, maxValue);
                g2d.setComposite(alphaComposite100);
                g2d.setColor(new Color(0, 0, 0));
                this.drawBoxPlot(g2d, xposBoxPlot, y, individualPlotWidth, height, vals1, minValue, maxValue, false);
                double minVal1 = ArrayMath.min((double[])vals1);
                int posY1 = y + height - (int)Math.round((double)height * (minVal1 - minValue) / (maxValue - minValue));
                int linePos = xposViolin + individualPlotWidth / 2;
                g2d.setComposite(alphaComposite25);
                g2d.setStroke(new BasicStroke(1.0f, 0, 0, 2.0f, new float[]{2.0f}, 0.0f));
                g2d.setColor(new Color(223, 36, 20));
                g2d.drawLine(linePos, posY1 + 5, linePos, height + 120);
                g2d.setComposite(alphaComposite100);
                g2d.setFont(fontBoldSmall);
                g2d.setColor(new Color(223, 36, 20));
                g2d.drawString(xLabels[datasetNumber][category], linePos - (int)Math.round(this.getWidth(xLabels[datasetNumber][category], g2d.getFont()) / 2.0), height + 130);
                if (printTable && categoryCounter < arrayList.size()) {
                    int yPos = height + 130 + 30 + categoryCounter * tableElementHeight;
                    g2d.drawString(xLabels[datasetNumber][category], plotStart - 15 - (int)Math.round(this.getWidth(xLabels[datasetNumber][category], g2d.getFont()) / 2.0), yPos);
                }
                ++categoryCounter;
            }
            for (Triple datasetCategoryCombo : sortedPValuesForDataset) {
                Integer category1 = (Integer)datasetCategoryCombo.getMiddle();
                Integer category23 = (Integer)datasetCategoryCombo.getRight();
                int category1Index1 = categoryIndex[category1];
                int category1Index2 = categoryIndex[category23];
                int xpos1 = plotStart - 5 + (individualPlotMarginLeft + individualPlotWidth + individualPlotMarginRight) * category1Index1 + individualPlotWidth / 2;
                int xpos2 = plotStart - 5 + (individualPlotMarginLeft + individualPlotWidth + individualPlotMarginRight) * category1Index2 + individualPlotWidth / 2;
                double maxVal1 = ArrayMath.max((double[])vals[datasetNumber][category1]);
                double maxVal2 = ArrayMath.max((double[])vals[datasetNumber][category23]);
                int posY1 = y + height - (int)Math.round((double)height * (maxVal1 - minValue) / (maxValue - minValue));
                int posY2 = y + height - (int)Math.round((double)height * (maxVal2 - minValue) / (maxValue - minValue));
                int horizontalLineYPos = 0;
                horizontalLineYPos = posY1 < posY2 ? posY1 - 25 : posY2 - 25;
                int midpos = xpos1 + (xpos2 - xpos1) / 2;
                double pValueWilcoxon = pvals[datasetNumber][category1][category23];
                String pValueWilcoxonString = new DecimalFormat("0.#E0", new DecimalFormatSymbols(Locale.US)).format(pValueWilcoxon);
                if (pValueWilcoxon > 0.001) {
                    pValueWilcoxonString = new DecimalFormat("##.###;-##.###", new DecimalFormatSymbols(Locale.US)).format(pValueWilcoxon);
                }
                g2d.setComposite(alphaComposite100);
                g2d.setColor(new Color(100, 100, 100));
                if (printTable) {
                    int yPos1 = height + 130 + 30 + category1Index1 * tableElementHeight;
                    int yPos2 = height + 130 + 30 + category1Index2 * tableElementHeight;
                    g2d.drawString(pValueWilcoxonString, xpos2 - (int)Math.round(this.getWidth(pValueWilcoxonString, g2d.getFont()) / 2.0), yPos1);
                    g2d.drawString(pValueWilcoxonString, xpos1 - (int)Math.round(this.getWidth(pValueWilcoxonString, g2d.getFont()) / 2.0), yPos2);
                    continue;
                }
                g2d.drawLine(xpos1, posY1 - 3, xpos1, horizontalLineYPos);
                g2d.drawLine(xpos1, horizontalLineYPos, xpos2, horizontalLineYPos);
                g2d.drawLine(xpos2, posY2 - 3, xpos2, horizontalLineYPos);
                g2d.drawString(pValueWilcoxonString, midpos - (int)Math.round(this.getWidth(pValueWilcoxonString, g2d.getFont()) / 2.0), horizontalLineYPos - 5);
            }
            deltaX += datasetwidth + betweenDatasetMargin;
            ++datasetCounter;
        }
        g2d.setComposite(alphaComposite100);
        g2d.setStroke(new BasicStroke(1.0f, 0, 0));
        g2d.setColor(new Color(100, 100, 100));
        System.out.println("MAX: " + maxValue);
        System.out.println("MIN: " + minValue);
        if (maxValue <= 1.0 && minValue >= 0.0) {
            System.out.println("New code...");
            double diff = maxValue - minValue;
            double unitY = this.determineUnit(diff);
            double remain = minValue % unitY;
            double startVal = minValue - remain;
            remain = maxValue % unitY;
            double endVal = maxValue + (unitY - remain);
            int posY1 = marginTop + innerHeight - (int)Math.round((double)innerHeight * (startVal - minValue) / (maxValue - minValue));
            int posY2 = marginTop + innerHeight - (int)Math.round((double)innerHeight * (endVal - minValue) / (maxValue - minValue));
            System.out.println(posY1 + "\t" + posY2);
            g2d.drawLine(marginLeft - 10, posY1, marginLeft - 10, posY2);
            g2d.setFont(fontBold);
            DecimalFormat df = new DecimalFormat("0.0");
            for (double v = startVal; v <= endVal; v += unitY) {
                int posY = marginTop + innerHeight - (int)Math.round((double)innerHeight * (v - minValue) / (maxValue - minValue));
                g2d.drawLine(marginLeft - 10, posY, marginLeft - 20, posY);
                g2d.drawString(df.format(v), marginLeft - 25 - (int)this.getWidth(df.format(v), g2d.getFont()), posY + 3);
            }
        } else if (maxValue > 0.0 && minValue >= 0.0) {
            int startVal = (int)Math.ceil(minValue);
            int n = (int)Math.floor(maxValue);
            int posY1 = marginTop + innerHeight - (int)Math.round((double)innerHeight * ((double)startVal - minValue) / (maxValue - minValue));
            int posY2 = marginTop + innerHeight - (int)Math.round((double)innerHeight * ((double)n - minValue) / (maxValue - minValue));
            g2d.drawLine(marginLeft - 10, posY1, marginLeft - 10, posY2);
            g2d.setFont(fontBold);
            for (int v = startVal; v <= n; ++v) {
                int posY = marginTop + innerHeight - (int)Math.round((double)innerHeight * ((double)v - minValue) / (maxValue - minValue));
                g2d.drawLine(marginLeft - 10, posY, marginLeft - 20, posY);
                g2d.drawString(String.valueOf(v), marginLeft - 25 - (int)this.getWidth(String.valueOf(v), g2d.getFont()), posY + 3);
            }
        }
        g2d.translate(marginLeft - 60, marginTop + innerHeight / 2);
        g2d.rotate(-1.5707963267948966);
        g2d.drawString(yLabel, -((int)this.getWidth(yLabel, g2d.getFont())) / 2, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-(marginLeft - 60), -(marginTop + innerHeight / 2));
        g2d.dispose();
        if (output == Output.PDF) {
            cb.restoreState();
            document.close();
            writer.close();
        } else {
            bi.flush();
            ImageIO.write((RenderedImage)bi, output.toString().toLowerCase(), new File(outputFileName));
        }
        Locale.setDefault(defaultLocale);
    }

    public void drawViolinPlot(Graphics2D g2d, int x, int y, int width, int height, double[] vals, double minValue, double maxValue) {
        int pos;
        int nrVals = vals.length;
        double minVals = ArrayMath.min((double[])vals);
        double maxVals = ArrayMath.max((double[])vals);
        int nrBins = 1 + (int)Math.round(Math.sqrt(nrVals) / 4.0);
        int[] binCount = new int[nrBins];
        for (int n = 0; n < nrBins; ++n) {
            double lower = minVals + (maxVals - minVals) * (double)n / (double)nrBins;
            double upper = minVals + (maxVals - minVals) * (double)(n + 1) / (double)nrBins;
            for (int v = 0; v < nrVals; ++v) {
                if (!(vals[v] >= lower) || !(vals[v] < upper)) continue;
                int n2 = n;
                binCount[n2] = binCount[n2] + 1;
            }
        }
        int posYMin = y + height - (int)Math.round((double)height * (maxVals - minValue) / (maxValue - minValue));
        int posYMax = y + height - (int)Math.round((double)height * (minVals - minValue) / (maxValue - minValue));
        double[] posVal = new double[posYMax - posYMin + 1];
        for (int pos2 = posYMin; pos2 <= posYMax; ++pos2) {
            double value = (double)(-pos2 + y + height) * (maxValue - minValue) / (double)height + minValue;
            for (int n = 0; n < nrBins; ++n) {
                double lower = minVals + (maxVals - minVals) * (double)n / (double)nrBins;
                double upper = minVals + (maxVals - minVals) * (double)(n + 1) / (double)nrBins;
                if (!(value >= lower) || !(value < upper)) continue;
                posVal[pos2 - posYMin] = binCount[n];
            }
        }
        double kernelWidth = (double)height / (double)nrBins / 4.0;
        double[] kernelWeights = new double[201];
        for (int d = -100; d <= 100; ++d) {
            double weight;
            kernelWeights[d + 100] = weight = Math.pow(Math.E, -((double)d / kernelWidth) * ((double)d / kernelWidth) / 2.0);
        }
        double[] posValSmoothed = new double[posYMax - posYMin + 1];
        for (int pos3 = posYMin; pos3 <= posYMax; ++pos3) {
            double valSmoothed = 0.0;
            double sumWeights = 0.0;
            for (int q = pos3 - 100; q <= pos3 + 100; ++q) {
                if (q < posYMin || q > posYMax) continue;
                sumWeights += kernelWeights[100 + q - pos3];
                valSmoothed += kernelWeights[100 + q - pos3] * posVal[q - posYMin];
            }
            posValSmoothed[pos3 - posYMin] = valSmoothed / sumWeights;
        }
        double maxSmoothedVal = ArrayMath.max((double[])posValSmoothed);
        for (int pos4 = posYMin; pos4 <= posYMax; ++pos4) {
            int n = pos4 - posYMin;
            posValSmoothed[n] = posValSmoothed[n] / maxSmoothedVal;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(x + width / 2, posYMin);
        for (pos = posYMin; pos <= posYMax; ++pos) {
            path.lineTo((double)(x + width / 2) - posValSmoothed[pos - posYMin] * (double)width / 2.0 - 1.0, (double)pos);
        }
        for (pos = posYMax; pos >= posYMin; --pos) {
            path.lineTo((double)(x + width / 2) + posValSmoothed[pos - posYMin] * (double)width / 2.0 + 1.0, (double)pos);
        }
        path.closePath();
        g2d.draw(path);
        g2d.fill(path);
    }

    public void drawBoxPlot(Graphics2D g2d, int x, int y, int width, int height, double[] vals, double minValue, double maxValue, boolean drawOutliers) {
        double median = ArrayMath.percentile((double[])vals, (double)0.5);
        double q1 = ArrayMath.percentile((double[])vals, (double)0.25);
        double q3 = ArrayMath.percentile((double[])vals, (double)0.75);
        double iqr = q3 - q1;
        int posY = y + height - (int)Math.round((double)height * (median - minValue) / (maxValue - minValue));
        g2d.setStroke(new BasicStroke(2.0f, 0, 1));
        g2d.drawLine(x, posY, x + width, posY);
        int posY1 = y + height - (int)Math.round((double)height * (q3 - minValue) / (maxValue - minValue));
        int posY2 = y + height - (int)Math.round((double)height * (q1 - minValue) / (maxValue - minValue));
        g2d.setStroke(new BasicStroke(1.0f, 0, 1));
        g2d.drawRect(x, posY1, width, posY2 - posY1);
        double whiskerTop = q3 + 1.5 * iqr;
        double whiskerBottom = q1 - 1.5 * iqr;
        double max = ArrayMath.max((double[])vals);
        double min = ArrayMath.min((double[])vals);
        if (min > whiskerBottom) {
            whiskerBottom = min;
        }
        if (max < whiskerTop) {
            whiskerTop = max;
        }
        posY = y + height - (int)Math.round((double)height * (whiskerTop - minValue) / (maxValue - minValue));
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 2.0f, new float[]{2.0f}, 0.0f));
        g2d.drawLine(x + width / 2, posY, x + width / 2, posY1);
        g2d.setStroke(new BasicStroke(1.0f, 0, 1));
        g2d.drawLine(x + width / 2 - 5, posY, x + width / 2 + 5, posY);
        posY = y + height - (int)Math.round((double)height * (whiskerBottom - minValue) / (maxValue - minValue));
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 2.0f, new float[]{2.0f}, 0.0f));
        g2d.drawLine(x + width / 2, posY2, x + width / 2, posY);
        g2d.setStroke(new BasicStroke(1.0f, 0, 1));
        g2d.drawLine(x + width / 2 - 5, posY, x + width / 2 + 5, posY);
        if (drawOutliers) {
            AlphaComposite alphaComposite10 = AlphaComposite.getInstance(3, 0.1f);
            g2d.setComposite(alphaComposite10);
            for (int v = 0; v < vals.length; ++v) {
                if (!(vals[v] > whiskerTop) && !(vals[v] < whiskerBottom)) continue;
                posY = y + height - (int)Math.round((double)height * (vals[v] - minValue) / (maxValue - minValue));
                g2d.drawOval(x + width / 2 - 2, posY - 2, 5, 5);
            }
        }
    }

    private double determineUnit(double range) {
        double divisor = Math.log10(range);
        divisor = Math.floor(divisor);
        divisor = Math.pow(10.0, divisor);
        return divisor;
    }

    public static enum Output {
        PDF,
        PNG;

    }
}

